/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.esi.emf;

import com.nomagic.esi.common.ResBranchRev;
import java.util.UUID;
import org.eclipse.emf.common.util.URI;

public class EsiURI {
    public static UUID getResourceID(URI uRI) {
        String string = uRI.segment(0);
        if (string.charAt(0) != 'R') {
            throw new RuntimeException("URI not valid: 'R' prefix missing from resource segment; " + uRI);
        }
        return UUID.fromString(string.substring(1));
    }

    public static UUID getBranchID(URI uRI) {
        String string = uRI.segment(1);
        if (string.charAt(0) != 'B') {
            throw new RuntimeException("URI not valid: 'B' prefix missing from branch segment; " + uRI);
        }
        return UUID.fromString(string.substring(1));
    }

    public static long getRevision(URI uRI) {
        String string = uRI.segment(2);
        if (string.charAt(0) != 'C') {
            throw new RuntimeException("URI not valid: 'C' prefix missing from revision/commit segment; " + uRI);
        }
        return Long.parseLong(string.substring(1));
    }

    public static ResBranchRev getResBranchRev(URI uRI) {
        UUID uUID = EsiURI.getResourceID(uRI);
        UUID uUID2 = EsiURI.getBranchID(uRI);
        long l2 = EsiURI.getRevision(uRI);
        return new ResBranchRev(uUID, uUID2, l2);
    }
}

