/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.esi.emf;

import com.nomagic.esi.api.CacheManager;
import com.nomagic.esi.api.EObjectStateChangedListener;
import com.nomagic.esi.api.EsiObject;
import com.nomagic.esi.api.EsiResource;
import com.nomagic.esi.api.EsiResourceSet;
import com.nomagic.esi.api.ResourceRef;
import com.nomagic.esi.api.SaveSet;
import com.nomagic.esi.api.Session;
import com.nomagic.esi.api.constants.BranchConstants;
import com.nomagic.esi.api.exceptions.SnapshotNotFoundException;
import com.nomagic.esi.api.info.BranchInfo;
import com.nomagic.esi.api.messages.info.IdAndRev;
import com.nomagic.esi.common.a.a.a;
import com.nomagic.esi.common.a.a.c;
import com.nomagic.esi.emf.EsiResourceImpl;
import com.nomagic.esi.emf.EsiURI;
import com.nomagic.esi.emf.a.E;
import com.nomagic.esi.emf.a.H;
import com.nomagic.esi.emf.a.c.i;
import com.nomagic.esi.emf.a.j;
import com.nomagic.esi.emf.a.w;
import com.nomagic.esi.helper.a.b;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

public class EsiResourceSetImpl
extends ResourceSetImpl
implements EsiResourceSet {
    private final Session session;
    private final c<UUID, EsiObject> objectMap = a.a((int)65536, (a.b)a.b.SOFT);
    private final List<EObjectStateChangedListener> eObjectStateChangedListeners;

    public EsiResourceSetImpl(Session session, i i2) {
        this.session = session;
        Map map = this.getResourceFactoryRegistry().getProtocolToFactoryMap();
        w w2 = new w(i2);
        map.put("esi", w2);
        j.g.a(this);
        this.eObjectStateChangedListeners = Collections.synchronizedList(new ArrayList());
    }

    public void dispose() {
        j.g.b(this);
    }

    public EsiResource createResource(URI uRI) {
        String string = "creating new resource from a URI is not supported;call createResource(String name, String author, String description) instead";
        throw new UnsupportedOperationException(string);
    }

    public Session getSession() {
        return this.session;
    }

    public EsiResource getResource(UUID uUID) {
        return this.getResource(uUID, BranchConstants.UNSPECIFIED, -3L, false, true);
    }

    public EsiResource getResource(UUID uUID, UUID uUID2) {
        return this.getResource(uUID, uUID2, -3L, false, true);
    }

    public EsiResource getResourceByRevision(UUID uUID, long l2) {
        return this.getResource(uUID, BranchConstants.UNSPECIFIED, l2, false, true);
    }

    public EsiResource getResourceNoLoad(UUID uUID) {
        return this.getResource(uUID, BranchConstants.UNSPECIFIED, -3L, false, false);
    }

    public EsiResource getResourceByRevision(UUID uUID, long l2, boolean bl) {
        return this.getResource(uUID, BranchConstants.UNSPECIFIED, l2, bl, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private EsiResource getResource(UUID uUID, UUID uUID2, long l2, boolean bl, boolean bl2) {
        if (uUID2.equals(BranchConstants.ANY)) {
            if (l2 != -2L) throw new IllegalArgumentException("illegal combination of 'ANY' args: branch & rev must both be 'ANY'");
        }
        if (!uUID2.equals(BranchConstants.ANY) && l2 == -2L) {
            throw new IllegalArgumentException("illegal combination of 'ANY' args: branch & rev must both be 'ANY'");
        }
        EsiResource esiResource = this.findResourceForID(uUID);
        if (uUID2.equals(BranchConstants.ANY) && l2 == -2L) {
            return esiResource;
        }
        if (esiResource != null) {
            if (uUID2.equals(BranchConstants.UNSPECIFIED) && l2 != -3L) {
                long l3 = esiResource.getCommitInfo().getID();
                if (l3 == l2) {
                    return esiResource;
                }
                String string = "Cannot add revision %d of resource %s to the resourceSet, because revision %d is already ";
                string = String.valueOf(string) + "present.\n\t(If resource loading was not explicitly invoked, this exception may be due to ";
                string = String.valueOf(string) + "a dependency conflict among resources.)";
                throw new IllegalStateException(String.format(string, l2, uUID, l3));
            }
            if (!uUID2.equals(BranchConstants.UNSPECIFIED) && l2 == -3L) {
                BranchInfo branchInfo = esiResource.getBranchInfo();
                if (branchInfo == null) {
                    String string = "Resource %s is new, so getting a specific branch for it is impossible.";
                    throw new IllegalStateException(String.format(string, uUID));
                }
                UUID uUID3 = esiResource.getResourceInfo().getTrunkID();
                if (branchInfo.getID().equals(uUID2)) return esiResource;
                if (branchInfo.getID().equals(uUID3) && uUID2.equals(BranchConstants.TRUNK)) {
                    return esiResource;
                }
                String string = "Cannot add resource %s, branch %s to the resourceSet because another branch is already present.";
                throw new IllegalStateException(String.format(string, uUID, uUID2));
            }
            if (uUID2.equals(BranchConstants.UNSPECIFIED) && l2 == -3L) {
                return esiResource;
            }
            if (!uUID2.equals(BranchConstants.UNSPECIFIED) && l2 != -3L) {
                throw new IllegalArgumentException("Illegal combination of arguments: branch & revision both specified");
            }
        }
        b.a((String)"resource should be null", (Object)Boolean.TRUE, (Object)(esiResource == null ? 1 : 0));
        if (!bl2) return esiResource;
        if (l2 == -3L) {
            l2 = -1L;
            if (uUID2.equals(BranchConstants.UNSPECIFIED)) {
                uUID2 = BranchConstants.TRUNK;
            }
        }
        URI uRI = new H().createUri(uUID, uUID2, l2);
        esiResource = this.getResource(uRI, true);
        if (!bl) return esiResource;
        ((EsiResourceImpl)esiResource).setReadOnly(true);
        return esiResource;
    }

    private EsiResource findResourceForID(UUID uUID) {
        for (Resource resource : this.getResources()) {
            if (!((EsiResource)resource).getID().equals(uUID)) continue;
            return (EsiResource)resource;
        }
        return null;
    }

    public EsiResource getResource(URI uRI) {
        UUID uUID = EsiURI.getResourceID(uRI);
        EsiResource esiResource = this.findResourceForID(uUID);
        if (esiResource != null) {
            UUID uUID2 = EsiURI.getBranchID(uRI);
            long l2 = EsiURI.getRevision(uRI);
            if (l2 != esiResource.getCommitInfo().getID()) {
                String string = "Cannot add resource %s, branch %s, revision %d to the resourceSet, ";
                string = String.valueOf(string) + "because another branch/revision is already present.";
                throw new IllegalStateException(String.format(string, uUID, uUID2, l2));
            }
            return esiResource;
        }
        return (EsiResource)super.getResource(uRI, true);
    }

    public EsiResource getResource(URI uRI, boolean bl) {
        if (!bl) {
            throw new IllegalArgumentException("demandLoad 'false' not supported");
        }
        return (EsiResource)super.getResource(uRI, bl);
    }

    public EsiResource createResource(String string, String string2) {
        URI uRI = new H().createUriForNewResource();
        EsiResource esiResource = (EsiResource)super.createResource(uRI);
        ((EsiResourceImpl)esiResource).setName(string);
        ((EsiResourceImpl)esiResource).setDescription(string2);
        return esiResource;
    }

    public c<UUID, EsiObject> doGetObjectMap() {
        return this.objectMap;
    }

    public Map<UUID, EsiObject> getObjectMap() {
        return Collections.unmodifiableMap(this.objectMap);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<EsiResource> getLoadedDependents(EsiResource esiResource) {
        LinkedList<EsiResource> linkedList = new LinkedList<EsiResource>();
        for (Resource resource : this.getResources()) {
            EsiResource esiResource2 = (EsiResource)resource;
            for (ResourceRef resourceRef : esiResource2.getDependencies()) {
                if (!resourceRef.getResourceID().equals(esiResource.getID())) continue;
                linkedList.add(esiResource2);
            }
        }
        return linkedList;
    }

    protected Resource demandCreateResource(URI uRI) {
        Resource.Factory factory = this.getResourceFactoryRegistry().getFactory(uRI, "");
        if (factory != null) {
            Resource resource = factory.createResource(uRI);
            this.demandLoadHelper(resource);
            this.getResources().add((Object)resource);
            return resource;
        }
        return null;
    }

    protected void demandLoadHelper(Resource resource) {
        try {
            if (!resource.isLoaded()) {
                this.demandLoad(resource);
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw unsupportedOperationException;
        }
        catch (IOException iOException) {
            this.handleDemandLoadException(resource, iOException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EsiResource loadSnapshot(UUID uUID, long l2, String string) {
        List list = this.session.getCacheManager().getSnapshotKeys(uUID, l2);
        if (!list.contains(string)) {
            throw new SnapshotNotFoundException(uUID, l2, string);
        }
        EsiResource esiResource = this.getResourceNoLoad(uUID);
        if (esiResource != null) {
            long l3;
            if (esiResource.getCommitInfo() == null && !esiResource.getContents().isEmpty()) {
                String string2 = "new (uncommitted) resource %s is currently open and not empty;\n\t";
                string2 = String.valueOf(string2) + "cannot load snapshot for revision %d";
                throw new IllegalStateException(String.format(string2, uUID, l2));
            }
            if (esiResource.getCommitInfo() != null && (l3 = esiResource.getCommitInfo().getID()) != l2) {
                String string3 = "resource %s is already open at a different revision (%d);\n\t";
                string3 = String.valueOf(string3) + "cannot load snapshot for revision %d";
                throw new IllegalStateException(String.format(string3, uUID, l3, l2));
            }
            if (esiResource.isModified()) {
                String string4 = "resource %s, revision %d is open and modified (dirty); cannot load local state";
                throw new IllegalStateException(String.format(string4, uUID, l2));
            }
        } else if (l2 == 0L) {
            URI uRI = new H().a(uUID);
            esiResource = (EsiResource)super.createResource(uRI);
        } else {
            esiResource = this.getResourceByRevision(uUID, l2);
        }
        esiResource.loadSnapshot(string);
        return esiResource;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<EsiResource> loadFrom(File file, String string) {
        CacheManager cacheManager = this.getSession().getCacheManager();
        List list = cacheManager.importFrom(file);
        ArrayList<EsiResource> arrayList = new ArrayList<EsiResource>(list.size());
        for (IdAndRev idAndRev : list) {
            UUID uUID = idAndRev.getID();
            long l2 = idAndRev.getRevision();
            EsiResource esiResource = this.getResourceByRevision(uUID, l2);
            if (string != null && !string.isEmpty() && cacheManager.getSnapshotRevisions(uUID).contains(l2) && cacheManager.getSnapshotKeys(uUID, l2).contains(string)) {
                esiResource = this.loadSnapshot(uUID, l2, string);
            }
            arrayList.add(esiResource);
        }
        return arrayList;
    }

    public SaveSet createSaveSet() {
        CacheManager cacheManager = this.session.getCacheManager();
        E e2 = new E(cacheManager);
        return e2;
    }

    public void addEObjectStateChangedListener(EObjectStateChangedListener eObjectStateChangedListener) {
        b.a((String)"eObject state changed listener", (Object)eObjectStateChangedListener);
        this.eObjectStateChangedListeners.add(eObjectStateChangedListener);
    }

    public void removeEObjectStateChangedListener(EObjectStateChangedListener eObjectStateChangedListener) {
        b.a((String)"eObject state changed listener", (Object)eObjectStateChangedListener);
        this.eObjectStateChangedListeners.remove(eObjectStateChangedListener);
    }

    public List<EObjectStateChangedListener> getEObjectStateChangedListeners() {
        return this.eObjectStateChangedListeners;
    }
}

