/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.esi.emf;

import com.nomagic.esi.api.BlobInputStream;
import com.nomagic.esi.api.BlobOutputStream;
import com.nomagic.esi.api.CacheManager;
import com.nomagic.esi.api.CachedStatus;
import com.nomagic.esi.api.CachingStyle;
import com.nomagic.esi.api.ChangeDetail;
import com.nomagic.esi.api.EObjectState;
import com.nomagic.esi.api.EsiObject;
import com.nomagic.esi.api.EsiResource;
import com.nomagic.esi.api.MergeContext;
import com.nomagic.esi.api.ModeContext;
import com.nomagic.esi.api.RepositoryManager;
import com.nomagic.esi.api.ResourceRef;
import com.nomagic.esi.api.RestoreContext;
import com.nomagic.esi.api.RestoredObject;
import com.nomagic.esi.api.SnapshotMode;
import com.nomagic.esi.api.constants.BranchConstants;
import com.nomagic.esi.api.exceptions.EObjectDiagnosticsException;
import com.nomagic.esi.api.exceptions.ReadOnlyException;
import com.nomagic.esi.api.info.BlobInfo;
import com.nomagic.esi.api.info.BranchInfo;
import com.nomagic.esi.api.info.CommitInfo;
import com.nomagic.esi.api.info.ResourceInfo;
import com.nomagic.esi.api.messages.CommonAncestorFindingAlgorithm;
import com.nomagic.esi.api.messages.OperationResult;
import com.nomagic.esi.api.messages.info.IdAndRev;
import com.nomagic.esi.api.preload.PreloadingPolicy;
import com.nomagic.esi.api.update.ChangeSet;
import com.nomagic.esi.common.ResBranchRev;
import com.nomagic.esi.core.msg.info.CommonAncestorAlgorithmInfo;
import com.nomagic.esi.core.msg.info.MergeInfoImpl;
import com.nomagic.esi.core.msg.info.OpenResourceInfo;
import com.nomagic.esi.core.msg.info.ResourceBranchCommit;
import com.nomagic.esi.core.msg.info.ResourceRefImpl;
import com.nomagic.esi.core.msg.info.impl.BlobInfoImpl;
import com.nomagic.esi.core.msg.info.impl.BlobOutputInfoImpl;
import com.nomagic.esi.core.msg.info.impl.BranchInfoImpl;
import com.nomagic.esi.core.msg.info.impl.ChangeDetailInfo;
import com.nomagic.esi.core.msg.info.impl.CommitInfoImpl;
import com.nomagic.esi.core.msg.info.impl.ResourceInfoImpl;
import com.nomagic.esi.core.msg.info.impl.RevisionTypeAndInfo;
import com.nomagic.esi.core.msg.preload.PreloadingPolicyImpl;
import com.nomagic.esi.emf.EsiResourceSetImpl;
import com.nomagic.esi.emf.EsiURI;
import com.nomagic.esi.emf.a.H;
import com.nomagic.esi.emf.a.c.g;
import com.nomagic.esi.emf.a.c.i;
import com.nomagic.esi.emf.a.e.b;
import com.nomagic.esi.emf.a.k;
import com.nomagic.esi.emf.a.l;
import com.nomagic.esi.emf.a.m;
import com.nomagic.esi.emf.a.n;
import com.nomagic.esi.emf.a.o;
import com.nomagic.esi.emf.a.x;
import com.nomagic.esi.emf.a.z;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EsiResourceImpl
extends ResourceImpl
implements EsiResource {
    private static ResourceInfoImpl NEW_RESOURCE_INFO;
    private static CommitInfoImpl NEW_COMMIT_INFO;
    private static BranchInfoImpl NEW_BRANCH_INFO;
    private static final Logger LOG;
    private static final boolean AUTO_FIX_DEPENDENCIES = false;
    private static final boolean PREVENT_UPDATE_CONFLICTS = false;
    private final AtomicBoolean isCommitting = new AtomicBoolean();
    private final i modelManager;
    private final UUID resourceID;
    private boolean readOnly = false;
    private ResourceInfo resourceInfo;
    private BranchInfoImpl branchInfo;
    private CommitInfoImpl commitInfo;
    private MetadataMap metadata;
    private DependencyList dependencies;
    private final UUID branchIDforLoad;
    private final long revisionForLoad;
    private x store;
    private final PreloadingPolicy preloadingPolicy;
    private k modeContext;
    private final List<UUID> blobIDs;
    private List<UUID> snapShotRootIDs;

    static {
        UUID uUID = UUID.fromString("09054768-2db2-4d09-983f-782e9b8089d8");
        UUID uUID2 = UUID.fromString("cae17fbf-d742-4d27-b66a-e6f55449172a");
        Date date = new Date();
        NEW_RESOURCE_INFO = new ResourceInfoImpl(null, null, false, null, null, date, date);
        RevisionTypeAndInfo revisionTypeAndInfo = RevisionTypeAndInfo.getUncommittedType((UUID)uUID, (UUID)uUID2, (long)0L);
        NEW_COMMIT_INFO = new CommitInfoImpl(revisionTypeAndInfo, null, null, 0L, null, null, null);
        NEW_BRANCH_INFO = new BranchInfoImpl(null, null, null, null, 0L, 0L, 0L, null, false);
        LOG = LoggerFactory.getLogger(EsiResourceImpl.class);
    }

    public EsiResourceImpl(URI uRI, i i2) {
        super(uRI);
        com.nomagic.esi.helper.a.b.a((String)"uri", (Object)uRI);
        com.nomagic.esi.helper.a.b.a((String)"modelManager", (Object)i2);
        ResBranchRev resBranchRev = EsiURI.getResBranchRev(uRI);
        this.resourceID = resBranchRev.resourceID;
        this.branchIDforLoad = resBranchRev.branchID;
        this.revisionForLoad = resBranchRev.revision;
        this.blobIDs = new LinkedList<UUID>();
        this.store = new com.nomagic.esi.emf.a.i(this, i2.k());
        this.modelManager = i2;
        this.preloadingPolicy = new PreloadingPolicyImpl(0, null, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResourceInfo getResourceInfo() {
        if (this.resourceInfo != null && !this.resourceInfo.equals(NEW_RESOURCE_INFO)) {
            return this.resourceInfo;
        }
        return null;
    }

    public Set<EsiObject> getAddedObjects() {
        return this.store.j();
    }

    public Set<EsiObject> getDirtyObjects() {
        return this.store.k();
    }

    public Set<EsiObject> getDeletedObjects() {
        return this.store.l();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public EsiObject getObject(UUID uUID) {
        return this.getObject(uUID, false);
    }

    public EsiObject getObject(UUID uUID, boolean bl) {
        return this.store.a(uUID, bl);
    }

    @Deprecated
    public List<EsiObject> getObjects(Iterable<UUID> iterable) {
        return this.store.a(iterable, false);
    }

    public Map<UUID, OperationResult<EsiObject>> getExistObjects(Iterable<UUID> iterable, boolean bl) {
        return this.store.b(iterable, bl);
    }

    @Deprecated
    public List<EsiObject> getObjects(Iterable<UUID> iterable, boolean bl) {
        return this.store.a(iterable, bl);
    }

    public UUID getID() {
        return this.resourceID;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void save(Map<?, ?> map) throws IOException {
        if (map == null) {
            String string4 = "options map is null; caller must pass a map with all required options, or (easier & safer) use EsiResource.commit(CommitOptions) instead";
            throw new IllegalArgumentException(string4);
        }
        String string3 = (String)map.get("commit.description");
        com.nomagic.esi.helper.a.b.c((String)"comment", (String)string3);
        String string2 = (String)map.get("newbranch.name");
        String string = (String)map.get("newbranch.description");
        if (string2 == null && string == null) {
            this.commit(string3);
            return;
        }
        com.nomagic.esi.helper.a.b.c((String)"newBranchName", (String)string2);
        com.nomagic.esi.helper.a.b.c((String)"newBranchDescription", (String)string);
        this.commit(string3, string2, string);
    }

    public void commitNewBranch(String string, String string2, String string3) {
        com.nomagic.esi.helper.a.b.c((String)"comment", (String)string);
        com.nomagic.esi.helper.a.b.c((String)"newBranchName", (String)string2);
        com.nomagic.esi.helper.a.b.c((String)"newBranchDescription", (String)string3);
        this.commit(string, string2, string3);
    }

    public void commit(String string) {
        com.nomagic.esi.helper.a.b.c((String)"comment", (String)string);
        this.commit(string, null, null);
    }

    public void mergeCommit(String string) {
        com.nomagic.esi.helper.a.b.c((String)"comment", (String)string);
        String string2 = this.getResourceSet().getSession().getUsername();
        this.doCommit(string2, string, null, null);
    }

    public void restoreCommit(String string) {
        com.nomagic.esi.helper.a.b.c((String)"comment", (String)string);
        String string2 = this.getResourceSet().getSession().getUsername();
        this.doCommit(string2, string, null, null);
    }

    private void commit(String string, String string2, String string3) {
        this.checkSpecialMode("commit");
        String string4 = this.getResourceSet().getSession().getUsername();
        this.doCommit(string4, string, string2, string3);
    }

    private void doCommit(String string, String string2, String string3, String string4) {
        if (this.readOnly) {
            throw new ReadOnlyException();
        }
        if (!this.isCommitting.compareAndSet(false, true)) {
            throw new IllegalStateException("another commit of this resource is in progress");
        }
        try {
            List<UUID> list = this.getRootIDs();
            ResourceBranchCommit resourceBranchCommit = null;
            List<ResourceRefImpl> list2 = this.getOrCreateDependency().asList();
            if (this.modeContext instanceof m) {
                m m2 = (m)this.modeContext;
                resourceBranchCommit = this.store.a(m2.n(), m2.o(), m2.p(), string2, list, list2, this.blobIDs, m2.q());
            } else {
                o o2 = new o(string2, string3, string4);
                resourceBranchCommit = this.store.a(o2, list, list2, this.blobIDs);
            }
            this.resourceInfo = resourceBranchCommit.getResourceInfo();
            this.branchInfo = resourceBranchCommit.getBranchInfo();
            this.commitInfo = resourceBranchCommit.getCommitInfo();
            this.snapShotRootIDs = null;
            this.metadata = null;
            this.dependencies = null;
            this.modeContext = null;
            this.blobIDs.clear();
        }
        finally {
            this.isCommitting.set(false);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void fixDependencies() {
        List<EsiResource> list = ((EsiResourceSetImpl)this.resourceSet).getLoadedDependents(this);
        for (EsiResource esiResource : list) {
            esiResource.changeDependency((EsiResource)this, this.commitInfo.getID());
        }
    }

    private List<UUID> getRootIDs() {
        EsiContentsEList esiContentsEList = (EsiContentsEList)this.getContents();
        return esiContentsEList.getRootIDs();
    }

    public List<UUID> getRootIDsWithoutLoadContents() {
        ArrayList<UUID> arrayList;
        block8: {
            block9: {
                block7: {
                    arrayList = new ArrayList<UUID>();
                    if (this.contents == null) break block7;
                    arrayList.addAll(this.getRootIDs());
                    break block8;
                }
                if (this.snapShotRootIDs == null) break block9;
                arrayList.addAll(this.snapShotRootIDs);
                break block8;
            }
            if (this.commitInfo != null) {
                arrayList.addAll(this.commitInfo.getRootObjectIDs());
            }
        }
        return arrayList;
    }

    public boolean isAttachedDetachedHelperRequired() {
        return true;
    }

    protected void attachedHelper(EObject eObject) {
        super.attachedHelper(eObject);
        this.store.c((EsiObject)eObject);
    }

    protected void detachedHelper(EObject eObject) {
        super.detachedHelper(eObject);
        this.store.d((EsiObject)eObject);
    }

    public EsiResourceSetImpl getResourceSet() {
        return (EsiResourceSetImpl)super.getResourceSet();
    }

    public void load(Map<?, ?> map) throws IOException {
        this.checkSpecialMode("load");
        ResBranchRev resBranchRev = new ResBranchRev(this.resourceID, this.branchIDforLoad, this.revisionForLoad);
        this.load(resBranchRev);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void load(ResBranchRev resBranchRev) {
        this.isLoading = true;
        try {
            long l2 = this.getRevision();
            OpenResourceInfo openResourceInfo = this.modelManager.a(resBranchRev, true);
            if (openResourceInfo != null) {
                this.resourceInfo = openResourceInfo.getResourceInfo();
                this.branchInfo = openResourceInfo.getBranchInfo();
                this.commitInfo = openResourceInfo.getCommitInfo();
                this.snapShotRootIDs = null;
                this.contents = null;
            }
            if (l2 > 0L && this.commitInfo.getID() != l2) {
                this.store.a(l2);
            }
        }
        finally {
            this.isLoading = false;
        }
        Notification notification = this.setLoaded(true);
        if (notification != null) {
            this.eNotify(notification);
        }
        this.setModified(false);
        if (this.resourceInfo != null) {
            this.setReadOnly(this.resourceInfo.isRemoved());
        }
        this.metadata = null;
        this.dependencies = null;
    }

    private ResourceImpl.ContentsEList<EObject> getRootObjects(List<UUID> list) {
        List<EsiObject> list2 = this.store.a(list, false);
        EsiObject[] esiObjectArray = list2.toArray(new EsiObject[list.size()]);
        String string = "the roots size should be the same as root ids size";
        Boolean bl = Boolean.TRUE;
        boolean bl2 = esiObjectArray.length == list.size();
        com.nomagic.esi.helper.a.b.a((String)string, (Object)bl, (Object)bl2);
        return new EsiContentsEList((EObject[])esiObjectArray);
    }

    protected void doUnload() {
        this.store.m();
        this.getErrors().clear();
        this.getWarnings().clear();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EList<EObject> getContents() {
        if (this.contents != null) return this.contents;
        if (this.snapShotRootIDs != null) {
            this.contents = this.getRootObjects(this.snapShotRootIDs);
            this.snapShotRootIDs = null;
            return this.contents;
        }
        if (this.commitInfo == null) {
            this.contents = new EsiContentsEList();
            return this.contents;
        }
        this.contents = this.getRootObjects(this.commitInfo.getRootObjectIDs());
        return this.contents;
    }

    public Map<String, Object> getMetadata() {
        return this.getOrCreateMetadata();
    }

    public List<ResourceRef> getDependencies() {
        this.dependencies = this.getOrCreateDependency();
        return Collections.unmodifiableList(this.dependencies.asList());
    }

    public void setName(String string) {
        this.getOrCreateMetadata().put("name", (Object)string);
    }

    public void setDescription(String string) {
        this.getOrCreateMetadata().put("description", (Object)string);
    }

    public void addDependency(EsiResource esiResource) {
        Object object3;
        long l2;
        UUID uUID;
        block14: {
            block15: {
                CommitInfo commitInfo;
                block13: {
                    block12: {
                        if (esiResource != this && !esiResource.getID().equals(this.resourceID)) break block12;
                        String string = "cannot add a resource as a dependency of itself";
                        throw new IllegalStateException(string);
                    }
                    BranchInfo branchInfo = esiResource.getBranchInfo();
                    commitInfo = esiResource.getCommitInfo();
                    if (commitInfo != null && branchInfo != null) break block13;
                    String string = "cannot add a resource that has never been persisted, as a dependency; commit the resource first";
                    throw new IllegalStateException(string);
                }
                if (((EsiResourceImpl)esiResource).isModified()) {
                    String string = "cannot add a resource that has been modified but not saved, as a dependency; commit the resource first";
                    throw new IllegalStateException(string);
                }
                uUID = esiResource.getID();
                Set<UUID> set = this.computeTransitiveDeps(esiResource.getDependencies(), null);
                if (set.contains(this.resourceID)) {
                    String string = "cannot add resource %s as a dependency of resource %s because it would create a cycle";
                    throw new IllegalStateException(String.format(string, uUID, this.resourceID));
                }
                if (esiResource.getResourceInfo().isRemoved()) {
                    throw new IllegalStateException("cannot add resource %s as a dependency because it has been removed");
                }
                l2 = commitInfo.getID();
                Object object2 = null;
                for (Object object3 : this.getDependencies()) {
                    if (!object3.getResourceID().equals(uUID)) continue;
                    object2 = object3;
                    break;
                }
                if (object2 == null) break block14;
                if (object2.getRevision() == l2) break block15;
                object3 = "cannot add revision %d of resource %s as a dependency because its revision %d is already declared as such";
                throw new IllegalStateException(String.format((String)object3, l2, uUID, object2.getRevision()));
            }
            object3 = "cannot add revision %d of resource %s as a dependency because it's already present";
            throw new IllegalStateException(String.format((String)object3, l2, uUID));
        }
        object3 = new ResourceRefImpl(uUID, l2);
        this.getOrCreateDependency().add((ResourceRefImpl)object3);
    }

    public void changeDependency(EsiResource esiResource, long l2) {
        boolean bl = this.removeDependency(esiResource.getID());
        if (!bl) {
            throw new IllegalStateException("cannot change dependency because it is not present");
        }
        this.addDependency(esiResource);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Set<UUID> computeTransitiveDeps(List<ResourceRef> list, Set<UUID> set) {
        if (set == null) {
            set = new HashSet<UUID>(128);
        }
        RepositoryManager repositoryManager = this.getResourceSet().getSession().getRepositoryManager();
        for (ResourceRef resourceRef : list) {
            UUID uUID = resourceRef.getResourceID();
            if (!set.add(uUID)) continue;
            CommitInfo commitInfo = repositoryManager.getCommitInfo(uUID, resourceRef.getRevision());
            this.computeTransitiveDeps(commitInfo.getDependencies(), set);
        }
        return set;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isModified() {
        return this.store.p() || this.isDependencyDirty() || this.isMetadataDirty();
    }

    public boolean removeDependency(UUID uUID) {
        Iterator iterator = this.getOrCreateDependency().iterator();
        while (iterator.hasNext()) {
            ResourceRefImpl resourceRefImpl = (ResourceRefImpl)iterator.next();
            if (!resourceRefImpl.getResourceID().equals(uUID)) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BranchInfo getBranchInfo() {
        if (this.branchInfo != null && !this.branchInfo.equals((Object)NEW_BRANCH_INFO)) {
            return this.branchInfo;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CommitInfo getCommitInfo() {
        if (this.commitInfo != null && !this.commitInfo.equals((Object)NEW_COMMIT_INFO) && this.commitInfo.getID() != 0L) {
            return this.commitInfo;
        }
        return null;
    }

    public UUID getBranchID() {
        UUID uUID = this.branchInfo != null ? this.branchInfo.getID() : BranchConstants.TRUNK;
        return uUID;
    }

    public long getRevision() {
        long l2 = this.commitInfo != null ? this.commitInfo.getID() : 0L;
        return l2;
    }

    public String toString() {
        return String.format("resourceID=%s, branchID=%s, revision=%d", this.getID(), this.getBranchID(), this.getRevision());
    }

    public ChangeSet update() {
        return this.update(-1L);
    }

    public ChangeSet update(long l2) {
        block2: {
            this.checkSpecialMode("update");
            if (l2 == -1L || l2 >= this.getRevision()) break block2;
            String string = "target revision (%d) is prior to the revision that is currently loaded (%d); cannot update to the past";
            throw new IllegalArgumentException(String.format(string, l2, this.getRevision()));
        }
        b b2 = this.store.n();
        this.store.o();
        ResBranchRev resBranchRev = new ResBranchRev(this.resourceID, this.getBranchID(), l2);
        this.load(resBranchRev);
        return b2;
    }

    public ChangeSet reset() {
        this.checkSpecialMode("reset");
        return this.doReset(false);
    }

    public ChangeSet doReset(boolean bl) {
        b b2 = this.store.n();
        this.store.o();
        this.contents = null;
        if (!bl) {
            this.modeContext = null;
        }
        this.blobIDs.clear();
        return b2;
    }

    public URI getURI() {
        if (this.commitInfo != null) {
            return new H().createUriForRevision(this.resourceID, this.commitInfo.getID());
        }
        return this.uri;
    }

    public void setURI(URI uRI) {
        throw new UnsupportedOperationException("EsiResourceImpl.setURI");
    }

    public long getTimeStamp() {
        throw new UnsupportedOperationException("EsiResourceImpl.getTimeStamp");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setReadOnly(boolean bl) {
        if (!bl && this.resourceInfo != null && this.resourceInfo.isRemoved()) {
            throw new IllegalStateException("a removed resource cannot be put into read-write mode");
        }
        this.readOnly = bl;
    }

    public NotificationChain basicSetResourceSet(ResourceSet resourceSet, NotificationChain notificationChain) {
        if (resourceSet == null) {
            this.unload_noContentFetch();
            this.store = null;
        }
        return super.basicSetResourceSet(resourceSet, notificationChain);
    }

    public void unload_noContentFetch() {
        if (this.isLoaded) {
            Notification notification = this.setLoaded(false);
            try {
                this.doUnload();
            }
            catch (Throwable throwable) {
                if (notification != null) {
                    this.eNotify(notification);
                }
                this.setTimeStamp(-1L);
                throw throwable;
            }
            if (notification != null) {
                this.eNotify(notification);
            }
            this.setTimeStamp(-1L);
        }
    }

    public List<EsiObject> getObjectsByEClass(Collection<EClass> collection, EsiObject esiObject) {
        return this.store.a(collection, esiObject);
    }

    public PreloadingPolicy getPreloadingPolicy() {
        return this.preloadingPolicy;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MetadataMap getOrCreateMetadata() {
        if (this.metadata != null) return this.metadata;
        if (this.resourceInfo != null) {
            this.metadata = new MetadataMap(this.resourceInfo.getMetadata());
            return this.metadata;
        }
        this.metadata = new MetadataMap();
        return this.metadata;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isMetadataDirty() {
        return this.metadata != null && this.metadata.isDirty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DependencyList getOrCreateDependency() {
        if (this.dependencies != null) return this.dependencies;
        if (this.commitInfo != null) {
            this.dependencies = new DependencyList(this.commitInfo.getDependencyImpls());
            return this.dependencies;
        }
        this.dependencies = new DependencyList();
        return this.dependencies;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean isDependencyDirty() {
        return this.dependencies != null && this.dependencies.isDirty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void takeSnapshot(SnapshotMode snapshotMode, String string) throws EObjectDiagnosticsException {
        CacheManager cacheManager = this.getResourceSet().getSession().getCacheManager();
        CachedStatus cachedStatus = cacheManager.getStatus(this.resourceID, this.getRevision());
        if (cachedStatus != CachedStatus.COMPLETE) {
            if (snapshotMode == SnapshotMode.LOADED) {
                this.store.q();
            } else if (snapshotMode == SnapshotMode.COMPLETE && this.getRevision() > 0L) {
                cacheManager.cache(this.getID(), this.getRevision(), CachingStyle.IMMEDIATE);
            }
        }
        List<UUID> list = this.getRootIDs();
        HashMap<String, Object> hashMap = this.getOrCreateMetadata().asHashMap();
        this.store.a(list, this.dependencies, hashMap, this.blobIDs, string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadSnapshot(String string) {
        if (this.isModified()) {
            throw new IllegalStateException("resource has uncommitted modifications; cannot load local state");
        }
        g g2 = this.store.c(string);
        CommitInfoImpl commitInfoImpl = g2.m();
        this.snapShotRootIDs = commitInfoImpl.getRootObjectIDs();
        if (!this.getOrCreateDependency().equals(commitInfoImpl.getDependencies())) {
            this.dependencies = new DependencyList();
            this.dependencies.addAll(commitInfoImpl.getDependencyImpls());
        }
        this.contents = null;
        HashMap<String, Object> hashMap = g2.o();
        if (!this.getMetadata().equals(hashMap)) {
            this.getMetadata().putAll(hashMap);
        }
        this.blobIDs.clear();
        List<UUID> list = g2.q();
        if (list == null) return;
        if (list.isEmpty()) return;
        this.blobIDs.addAll(list);
    }

    public void saveAs(File file, String string) throws EObjectDiagnosticsException {
        this.takeSnapshot(SnapshotMode.COMPLETE, string);
        CacheManager cacheManager = this.getResourceSet().getSession().getCacheManager();
        long l2 = this.getRevision();
        cacheManager.exportTo(file, Collections.singletonList(new IdAndRev(this.resourceID, l2)));
    }

    public void removeSnapshot(String string) {
        CacheManager cacheManager = this.getResourceSet().getSession().getCacheManager();
        cacheManager.removeSnapshot(this.getID(), this.getRevision(), string);
    }

    public void removeAllSnapshots() {
        CacheManager cacheManager = this.getResourceSet().getSession().getCacheManager();
        cacheManager.removeAllSnapshots(this.getID(), this.getRevision());
    }

    public List<String> getSnapshotKeys() {
        CacheManager cacheManager = this.getResourceSet().getSession().getCacheManager();
        return cacheManager.getSnapshotKeys(this.getID(), this.getRevision());
    }

    public MergeContext enterMergeMode(long l2, CommonAncestorFindingAlgorithm commonAncestorFindingAlgorithm, boolean bl) {
        com.nomagic.esi.helper.a.b.a((String)"algorithm", (Object)commonAncestorFindingAlgorithm);
        if (commonAncestorFindingAlgorithm == CommonAncestorFindingAlgorithm.A0_OLD_STYLE_LOWEST_COMMON_ANCESTOR) {
            throw new IllegalArgumentException("not support an old algorithm anymore");
        }
        this.checkSpecialMode("enterMergeMode");
        if (this.isModified()) {
            String string = "cannot merge the resource that has been modified but not saved";
            throw new IllegalStateException(string);
        }
        UUID uUID = this.branchInfo.getID();
        long l3 = this.commitInfo.getID();
        CommonAncestorAlgorithmInfo commonAncestorAlgorithmInfo = new CommonAncestorAlgorithmInfo(commonAncestorFindingAlgorithm, bl);
        MergeInfoImpl mergeInfoImpl = this.modelManager.a(this.resourceID, this.getRevision(), l2, commonAncestorAlgorithmInfo);
        List list = mergeInfoImpl.getCommonAncestors();
        IdAndRev idAndRev = (IdAndRev)list.get(0);
        ResBranchRev resBranchRev = new ResBranchRev(this.resourceID, idAndRev.getID(), idAndRev.getRevision());
        this.load(resBranchRev);
        m m2 = new m(this, new IdAndRev(uUID, l3), l2, commonAncestorAlgorithmInfo, list, idAndRev);
        this.modeContext = m2;
        return m2;
    }

    public RestoreContext enterRestoreMode() {
        this.checkSpecialMode("enterRestoreMode");
        if (this.getCommitInfo() == null) {
            throw new IllegalStateException("new resource has nothing to be restored");
        }
        l l2 = new l(this, this.getBranchInfo().getID(), this.getCommitInfo().getID());
        this.modeContext = l2;
        return l2;
    }

    public List<RestoredObject> restoreObjects(Collection<UUID> collection, long l2) {
        return this.store.a(collection, l2);
    }

    Mode getMode() {
        if (this.modeContext == null) {
            return Mode.NORMAL;
        }
        return this.modeContext.j();
    }

    private void checkSpecialMode(String string) {
        if (this.modeContext != null) {
            String string2 = String.valueOf(EsiResourceImpl.class.getSimpleName()) + '.' + string;
            String string3 = "%s not allowed while in special mode %s";
            throw new IllegalStateException(String.format(string3, new Object[]{string2, this.modeContext.j()}));
        }
    }

    public ModeContext getModeContext() {
        return this.modeContext;
    }

    public BlobOutputStream addBlob(Map<String, Object> map) {
        BlobOutputInfoImpl blobOutputInfoImpl = this.modelManager.a(this.getID(), map);
        if (!blobOutputInfoImpl.isAddToServerImmediately()) {
            UUID uUID = blobOutputInfoImpl.getID();
            this.blobIDs.add(uUID);
        }
        return blobOutputInfoImpl.getOutstream();
    }

    public BlobInputStream openBlobStream(UUID uUID) {
        UUID uUID2 = this.getID();
        BlobInputStream blobInputStream = this.modelManager.a(uUID, uUID2);
        return blobInputStream;
    }

    public List<BlobInfo> getBlobInfos() {
        List<BlobInfoImpl> list = this.modelManager.a(this.getID());
        ArrayList<BlobInfoImpl> arrayList = new ArrayList<BlobInfoImpl>(list);
        return Collections.unmodifiableList(arrayList);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<ChangeDetail> getObjectsHistory(List<UUID> list, UUID uUID, long l2, long l3, boolean bl) {
        com.nomagic.esi.helper.a.b.a((String)"scope", list);
        ArrayList<UUID> arrayList = new ArrayList<UUID>(list);
        List<ChangeDetailInfo> list2 = this.modelManager.a(arrayList, this.getID(), uUID, l2, l3, bl);
        ArrayList<ChangeDetail> arrayList2 = new ArrayList<ChangeDetail>(list2.size());
        for (ChangeDetailInfo changeDetailInfo : list2) {
            n n2 = new n(arrayList, changeDetailInfo.getRevision(), changeDetailInfo.getBranchID(), changeDetailInfo.getStateValues());
            arrayList2.add(n2);
        }
        return arrayList2;
    }

    public List<EObjectState> getObjectsState(List<UUID> list, long l2) {
        List<EObjectState> list2 = this.store.a(list, l2);
        return list2;
    }

    public ChangeSet getChangeSet() {
        b b2 = this.store.n();
        return b2;
    }

    private class DependencyList
    extends ArrayList<ResourceRefImpl> {
        private static final long serialVersionUID = 2081039095094649757L;
        private boolean isDirty;

        DependencyList() {
        }

        DependencyList(Collection<ResourceRefImpl> collection) {
            super(collection);
        }

        @Override
        public boolean add(ResourceRefImpl resourceRefImpl) {
            this.isDirty = true;
            return super.add(resourceRefImpl);
        }

        @Override
        public boolean addAll(Collection<? extends ResourceRefImpl> collection) {
            this.isDirty = true;
            return super.addAll(collection);
        }

        @Override
        public ResourceRefImpl remove(int n2) {
            this.isDirty = true;
            return (ResourceRefImpl)super.remove(n2);
        }

        @Override
        public boolean remove(Object object) {
            this.isDirty = true;
            return super.remove(object);
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            this.isDirty = true;
            return super.removeAll(collection);
        }

        @Override
        public void clear() {
            this.isDirty = true;
            super.clear();
        }

        List<ResourceRefImpl> asList() {
            ArrayList<ResourceRefImpl> arrayList = new ArrayList<ResourceRefImpl>(this);
            return arrayList;
        }

        public boolean isDirty() {
            return this.isDirty;
        }
    }

    private class EsiContentsEList
    extends ResourceImpl.ContentsEList<EObject> {
        private static final long serialVersionUID = -5876596341321491693L;

        EsiContentsEList() {
            super((ResourceImpl)EsiResourceImpl.this);
        }

        EsiContentsEList(EObject[] eObjectArray) {
            super((ResourceImpl)EsiResourceImpl.this);
            this.setData(eObjectArray.length, eObjectArray);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        List<UUID> getRootIDs() {
            LinkedList<UUID> linkedList = new LinkedList<UUID>();
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                UUID uUID = ((EsiObject)iterator.next()).esiID();
                linkedList.add(uUID);
            }
            return linkedList;
        }

        public void addUnique(EObject eObject) {
            z z2;
            if (eObject instanceof EsiObject && !(z2 = (z)eObject).esiState().isFreeOrNewOrGone()) {
                x x2 = z2.esiStore();
                if (x2 != EsiResourceImpl.this.store) {
                    throw new IllegalStateException("persisted object being attached to different resource");
                }
            }
            super.addUnique((Object)eObject);
        }
    }

    private class MetadataMap
    extends HashMap<String, Object> {
        private static final long serialVersionUID = -2876008009682644134L;
        private boolean isDirty;

        MetadataMap() {
        }

        MetadataMap(Map<String, Object> map) {
            super(map);
        }

        @Override
        public Object put(String string, Object object) {
            this.isDirty = true;
            return super.put(string, object);
        }

        @Override
        public void putAll(Map<? extends String, ? extends Object> map) {
            if (!map.isEmpty()) {
                this.isDirty = true;
            }
            super.putAll(map);
        }

        @Override
        public Object remove(Object object) {
            if (!(object instanceof String)) {
                return null;
            }
            Object v2 = this.get(object);
            if (v2 != null) {
                super.put((String)object, null);
                this.isDirty = true;
            }
            return v2;
        }

        @Override
        public void clear() {
            if (!this.isEmpty()) {
                super.clear();
                this.isDirty = true;
            }
        }

        HashMap<String, Object> asHashMap() {
            HashMap<String, Object> hashMap = new HashMap<String, Object>(this.size());
            hashMap.putAll(this);
            return hashMap;
        }

        public boolean isDirty() {
            return this.isDirty;
        }
    }

    public static enum Mode {
        NORMAL,
        RESTORE,
        MERGE;

    }
}

