/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.trinity.rhapsody.ecore.robj;

import com.ibm.accessibility.com.win32.IDispatch;
import com.ibm.trinity.rhapsody.ecore.REOperationException;
import com.ibm.trinity.rhapsody.ecore.robj.RhpCollection;
import com.ibm.trinity.rhapsody.ecore.robj.RhpModelElement;

public class RhpRelation
extends RhpModelElement {
    private static String instanceNameOf(String str) {
        return "its" + str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    private boolean hasDefaultName(RhpModelElement cls) {
        String strCls = cls.getName();
        String strDefInst = RhpRelation.instanceNameOf(strCls);
        String strName = this.getName();
        if (strName.equals(strCls)) {
            if (strName.startsWith("part_")) {
                return true;
            }
            return strName.startsWith("its");
        }
        if (strName.equals(strDefInst)) {
            return true;
        }
        if (strName.startsWith(strDefInst + "_")) {
            String strOrd = strName.substring(strDefInst.length() + 1);
            try {
                int n = Integer.parseInt(strOrd);
                if (n >= 0) {
                    return true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    private String resolveInstanceName(RhpModelElement newCls) throws REOperationException {
        if (newCls == null) {
            return null;
        }
        RhpModelElement oldCls = this.getOtherClass();
        if (oldCls == null) {
            throw new REOperationException("Instance does not have otherClass: " + this);
        }
        if (!this.hasDefaultName(oldCls)) {
            return null;
        }
        String strNew = RhpRelation.instanceNameOf(newCls.getName());
        RhpModelElement cls = this.getOwner();
        RhpCollection children = cls.getNestedElements();
        RhpModelElement target = children.find(strNew);
        if (target == null) {
            return null;
        }
        for (int i = 1; i <= 1000; ++i) {
            String str = strNew + "_" + i;
            target = children.find(str);
            if (target != null) continue;
            return str;
        }
        throw new REOperationException("Too many name conflicts: " + newCls);
    }

    public RhpModelElement getOtherClass() {
        Object oc = this.idisp.get("otherClass");
        if (oc instanceof IDispatch) {
            return new RhpModelElement((IDispatch)oc);
        }
        return null;
    }

    public RhpRelation getInverse() {
        Object rel = this.idisp.get("inverse");
        if (rel instanceof IDispatch) {
            return new RhpRelation((IDispatch)rel);
        }
        return null;
    }

    public boolean setOtherClass(Object rhpval) throws REOperationException {
        if (!RhpModelElement.Type.IRPClassifier.isRhpModelElement(rhpval)) {
            throw new REOperationException("OtherClass must be IRPClassifier: " + rhpval);
        }
        RhpModelElement rme = (RhpModelElement)rhpval;
        String instName = this.resolveInstanceName(rme);
        if (instName != null) {
            this.setName(instName);
        }
        this.idisp.put("otherClass", (Object)rme.idisp);
        IDispatch idispOC = (IDispatch)this.idisp.get("otherClass");
        String guid = rme.getGUID();
        return guid.equals(idispOC.get("GUID"));
    }

    public RhpRelation(RhpModelElement rme) {
        super(rme.idisp);
    }

    RhpRelation(IDispatch idisp) {
        super(idisp);
    }
}

