/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.trinity.rhapsody.ecore.robj;

import com.ibm.accessibility.com.win32.DispatchException;
import com.ibm.accessibility.com.win32.IDispatch;
import com.ibm.trinity.rhapsody.ecore.impl.DMParams;
import com.ibm.trinity.rhapsody.ecore.robj.RhpApplicationHandler;
import com.ibm.trinity.rhapsody.ecore.robj.RhpModelElement;
import com.ibm.trinity.spi.FatalModelAccessException;
import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;

public class RhpProject
extends RhpModelElement {
    public String getFilename() {
        return (String)this.get("filename");
    }

    public String getCurrentDirectory() {
        return (String)this.get("currentDirectory");
    }

    public IPath pathOf() {
        Path projectPath = new Path(this.getFilename());
        if (!projectPath.isAbsolute()) {
            IPath curDir = new Path(this.getCurrentDirectory()).removeTrailingSeparator();
            projectPath = curDir.append((IPath)projectPath);
        }
        return projectPath;
    }

    public void save() {
        this.idisp.invoke0("save");
    }

    public void saveAs(String filename) {
        this.idisp.invoke1("saveAs", (Object)filename);
    }

    public void close() {
        try {
            this.setNotifyPluginOnElementsChanged(false);
        }
        catch (FatalModelAccessException fatalModelAccessException) {
        }
        finally {
            this.idisp.invoke0("close");
        }
    }

    public RhpModelElement findElementByGUID(String guid) {
        return this.invokeRhp("findElementByGUID", guid);
    }

    public void moveProject(DMParams.Options dmOptions, URI uri) throws IOException {
        Object[] args = new Object[]{dmOptions.get((Object)DMParams.username), dmOptions.get((Object)DMParams.password), uri.toString(), dmOptions.get((Object)DMParams.projectAreaName), dmOptions.get((Object)DMParams.streamName)};
        try {
            this.idisp.invoke("moveToDesignManager", args);
        }
        catch (DispatchException e) {
            throw new IOException("Failed to moveToDesignManager: " + dmOptions, e);
        }
    }

    private void setNotifyPluginOnElementsChanged(boolean flag) throws FatalModelAccessException {
        int arg = flag ? 1 : 0;
        try {
            this.idisp.invoke1("setNotifyPluginOnElementsChanged", (Object)arg);
        }
        catch (DispatchException e) {
            throw new FatalModelAccessException("Rhapsody API is older than expected: IRPProject#setNotifyPluginOnElementsChanged() is unavailable");
        }
    }

    RhpProject(IDispatch idisp, RhpApplicationHandler handler) throws FatalModelAccessException {
        super(idisp);
        if (handler != null) {
            this.setNotifyPluginOnElementsChanged(true);
        }
    }
}

