/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.trinity.rhapsody.ecore.robj;

import com.ibm.accessibility.com.win32.DispatchException;
import com.ibm.accessibility.com.win32.IDispatch;
import com.ibm.accessibility.com.win32.IUnknown;
import com.ibm.trinity.rhapsody.ecore.robj.RhpCollection;
import java.util.UUID;
import org.apache.log4j.Logger;

public class RhpModelElement {
    static final Logger LOGGER = Logger.getLogger(RhpModelElement.class);
    protected final IDispatch idisp;
    private String reTypeName;

    static void initialize(boolean isVer2) {
        if (isVer2) {
            Type.initialize2();
        } else {
            Type.initialize1();
        }
    }

    protected static boolean typeOf(Type type, IDispatch d) {
        IUnknown iunk;
        try {
            iunk = d.queryInterface(type.uuid);
        }
        catch (DispatchException e) {
            return false;
        }
        if (iunk == null) {
            return false;
        }
        iunk.release();
        return true;
    }

    public boolean typeOf(Type type) {
        return RhpModelElement.typeOf(type, this.idisp);
    }

    public String getMetaClass() {
        return (String)this.idisp.get("metaClass");
    }

    public String getRETypeName() {
        if (this.reTypeName != null) {
            return this.reTypeName;
        }
        String ifName = (String)this.idisp.get("interfaceName");
        this.reTypeName = "RE" + ifName.substring(3);
        return this.reTypeName;
    }

    public String getGUID() {
        try {
            return (String)this.idisp.get("GUID");
        }
        catch (DispatchException e) {
            return null;
        }
    }

    public String getName() {
        return (String)this.idisp.get("name");
    }

    public void setName(String name) {
        this.idisp.put("name", (Object)name);
    }

    public RhpCollection getNestedElements() {
        IDispatch idispNestedElements = (IDispatch)this.idisp.invoke0("getNestedElements");
        return new RhpCollection(idispNestedElements);
    }

    public boolean isValid() {
        try {
            this.idisp.get("GUID");
            return true;
        }
        catch (DispatchException e) {
            LOGGER.warn((Object)("Invalid IRPModelElement detected: " + this));
            return false;
        }
    }

    public String getErrorMessage() {
        try {
            return (String)this.idisp.invoke0("getErrorMessage");
        }
        catch (DispatchException e) {
            return "NOERR";
        }
    }

    public void removeStereotype(RhpModelElement rme) {
        this.invoke("removeStereotype", rme.idisp);
    }

    public String getUserDefinedMetaClass() {
        return (String)this.idisp.get("userDefinedMetaClass");
    }

    public RhpModelElement changeTo(String metaclass) {
        IDispatch d = (IDispatch)this.idisp.invoke1("changeTo", (Object)metaclass);
        return new RhpModelElement(d);
    }

    public RhpModelElement getOwner() {
        return (RhpModelElement)this.get("owner");
    }

    public void setOwner(RhpModelElement rme) {
        this.idisp.put("owner", (Object)rme.idisp);
    }

    public RhpModelElement getStereotype() {
        Object o = this.idisp.get("stereotype");
        if (!(o instanceof IDispatch)) {
            return null;
        }
        return new RhpModelElement((IDispatch)o);
    }

    public RhpCollection getStreotypes() {
        Object o = this.idisp.get("stereotypes");
        if (!(o instanceof IDispatch)) {
            return null;
        }
        return new RhpCollection((IDispatch)o);
    }

    public void setStereotype(RhpModelElement rme) {
        this.idisp.put("stereotype", (Object)rme.idisp);
    }

    public String getFullPathName() {
        return (String)this.idisp.invoke0("getFullPathName");
    }

    public RhpModelElement addNewAggr(String type, String name) {
        return this.invokeRhp("addNewAggr", type, name);
    }

    public void deleteFromProject() {
        this.idisp.invoke0("deleteFromProject");
    }

    private Object convertResult(Object o) {
        if (o instanceof IDispatch) {
            IDispatch d = (IDispatch)o;
            if (RhpModelElement.typeOf(Type.IRPCollection, d)) {
                return new RhpCollection(d);
            }
            if (o instanceof IDispatch) {
                return new RhpModelElement(d);
            }
        }
        return o;
    }

    public Object invoke(String name, Object ... args) {
        return this.convertResult(this.idisp.invoke(name, args));
    }

    public RhpCollection getAllTags() {
        Object o = this.idisp.get("allTags");
        if (!(o instanceof IDispatch)) {
            return null;
        }
        return new RhpCollection((IDispatch)o);
    }

    public RhpModelElement setTagValue(RhpModelElement baseTag, String value) {
        return this.invokeRhp("setTagValue", baseTag.idisp, value);
    }

    public RhpModelElement invokeRhp(String name, Object ... args) {
        Object o = this.idisp.invoke(name, args);
        if (o == null) {
            return null;
        }
        if (o instanceof IDispatch) {
            return new RhpModelElement((IDispatch)o);
        }
        throw new RuntimeException("Invalid RhpModelElement: " + o);
    }

    public RhpCollection invokeCol(String name, Object ... args) {
        Object o = this.idisp.invoke(name, args);
        if (o instanceof IDispatch) {
            return new RhpCollection((IDispatch)o);
        }
        throw new RuntimeException("Invalid RhpModelElement: " + o);
    }

    public Object get(String name) {
        Object o;
        try {
            if ("errorMessage".equals(name)) {
                return this.getErrorMessage();
            }
            if ("fullPathName".equals(name)) {
                return this.getFullPathName();
            }
            if ("inTransitions".equals(name)) {
                return this.invokeCol("getInTransitions", new Object[0]);
            }
            if ("logicalCollaboration".equals(name)) {
                return this.invokeRhp("getLogicalCollaboration", new Object[0]);
            }
            if ("connector".equals(name)) {
                RhpCollection collection = this.invokeCol("getNestedElements", new Object[0]);
                Object[] ss = collection.getItems();
                return collection;
            }
            o = this.idisp.get(name);
        }
        catch (DispatchException e) {
            return null;
        }
        return this.convertResult(o);
    }

    public RhpCollection getCol(String name) {
        Object o = this.idisp.get(name);
        if (o instanceof IDispatch) {
            return new RhpCollection((IDispatch)o);
        }
        throw new RuntimeException("Invalid RhpModelElement: " + o);
    }

    public Object get(String name, Object ... args) {
        return this.convertResult(this.idisp.get(name, args));
    }

    public void put(String name, Object val) {
        if (val instanceof RhpModelElement) {
            this.idisp.put(name, (Object)((RhpModelElement)val).idisp);
        } else {
            this.idisp.put(name, val);
        }
    }

    public int hashCode() {
        String guid = this.getGUID();
        if (guid == null) {
            return this.idisp.hashCode();
        }
        return guid.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof RhpModelElement)) {
            return false;
        }
        RhpModelElement rme = (RhpModelElement)o;
        if (this.idisp.equalsCOMObject((Object)rme.idisp)) {
            return true;
        }
        return this.getGUID().equals(rme.getGUID());
    }

    protected RhpModelElement(IDispatch idisp) {
        this.idisp = idisp;
    }

    public RhpModelElement addRECustomConnector(RhpModelElement fromPart, RhpModelElement toPart, Object object, RhpModelElement fromPort, RhpModelElement toPort) {
        try {
            IDispatch idisNull = this.idisp.newIDispatch(0L);
            Object[] ss = new Object[]{fromPart.idisp, toPart.idisp, idisNull, fromPort.idisp, toPort.idisp};
            RhpModelElement aa = this.invokeRhp("addLink", ss);
            aa.invoke("addStereotype", "connector", "link");
            return aa;
        }
        catch (Throwable e) {
            System.out.println(e);
            return null;
        }
    }

    public static enum Type {
        IRPProject,
        IRPClass,
        IRPCollection,
        IRPInstance,
        IRPClassifier,
        IRPRelation,
        IRPFlow,
        IRPHyperLink,
        IRPUnit,
        IRPPackage,
        IRPDiagram,
        IRPStateVertex,
        IRPState,
        IRPStatechart,
        IRPStereotype,
        IRPGraphNode;

        public UUID uuid;

        private void setUUID(String uuidStr) {
            this.uuid = UUID.fromString(uuidStr);
        }

        static void initialize1() {
            IRPProject.setUUID("DE34202F-0011-11D3-8E4D-0060080B70BC");
            IRPClass.setUUID("DE342027-0011-11D3-8E4D-0060080B70BC");
            IRPCollection.setUUID("57DBF9F3-F318-11D2-B825-00104B3E6572");
            IRPInstance.setUUID("5CD30502-CBB3-11D6-B66B-0050DA4FA123");
            IRPClassifier.setUUID("CCE08504-FCFA-11D2-8E4D-0060080B70BC");
            IRPRelation.setUUID("8A6656B3-FB6D-11D2-8E4D-0060080B70BC");
            IRPFlow.setUUID("99694D71-C5F3-4D18-B45E-4294C4D20339");
            IRPHyperLink.setUUID("B5829A27-C6E4-456D-ABF2-73E0442981C3");
            IRPUnit.setUUID("57DBF9F1-F318-11D2-B825-00104B3E6572");
            IRPPackage.setUUID("CCE08506-FCFA-11D2-8E4D-0060080B70BC");
            IRPDiagram.setUUID("315B0276-1611-11D3-8E50-0060080B70BC");
            IRPStateVertex.setUUID("12094020-2D4A-11D3-B5A6-00105AA800A9");
            IRPState.setUUID("12094022-2D4A-11D3-B5A6-00105AA800A9");
            IRPStatechart.setUUID("315B027A-1611-11D3-8E50-0060080B70BC");
            IRPStereotype.setUUID("9C6D0891-FBA0-11D2-B825-00104B3E6572");
            IRPGraphNode.setUUID("9C3EBC1F-B52A-4350-8875-2240C18D92C6");
        }

        static void initialize2() {
            IRPProject.setUUID("C1E0F4DB-2B50-11E8-9927-463500000031");
            IRPClass.setUUID("C1E0F4D7-2B50-11E8-9927-463500000031");
            IRPCollection.setUUID("C1E0F4CB-2B50-11E8-9927-463500000031");
            IRPInstance.setUUID("C1E0F4CD-2B50-11E8-9927-463500000031");
            IRPClassifier.setUUID("C1E0F4D2-2B50-11E8-9927-463500000031");
            IRPRelation.setUUID("C1E0F4CC-2B50-11E8-9927-463500000031");
            IRPFlow.setUUID("C1E0F52C-2B50-11E8-9927-463500000031");
            IRPHyperLink.setUUID("C1E0F4DF-2B50-11E8-9927-463500000031");
            IRPUnit.setUUID("C1E0F4CA-2B50-11E8-9927-463500000031");
            IRPPackage.setUUID("C1E0F4D4-2B50-11E8-9927-463500000031");
            IRPDiagram.setUUID("C1E0F4F1-2B50-11E8-9927-463500000031");
            IRPStateVertex.setUUID("C1E0F506-2B50-11E8-9927-463500000031");
            IRPState.setUUID("C1E0F507-2B50-11E8-9927-463500000031");
            IRPStatechart.setUUID("C1E0F4F6-2B50-11E8-9927-463500000031");
            IRPStereotype.setUUID("C1E0F4D3-2B50-11E8-9927-463500000031");
            IRPGraphNode.setUUID("C1E0F4EE-2B50-11E8-9927-463500000031");
        }

        public boolean isRhpModelElement(Object o) {
            if (!(o instanceof RhpModelElement)) {
                return false;
            }
            RhpModelElement rme = (RhpModelElement)o;
            return rme.typeOf(this);
        }
    }
}

