/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.trinity.rhapsody.ecore.robj;

import com.ibm.accessibility.com.win32.ComService;
import com.ibm.accessibility.com.win32.DispatchException;
import com.ibm.accessibility.com.win32.IDispatch;
import com.ibm.accessibility.com.win32.IUnknown;
import com.ibm.accessibility.com.win32.ResourceManager;
import com.ibm.trinity.rhapsody.ecore.IntegrationMode;
import com.ibm.trinity.rhapsody.ecore.RhpAccessFailureException;
import com.ibm.trinity.rhapsody.ecore.impl.DMParams;
import com.ibm.trinity.rhapsody.ecore.robj.RhpApplicationHandler;
import com.ibm.trinity.rhapsody.ecore.robj.RhpModelElement;
import com.ibm.trinity.rhapsody.ecore.robj.RhpProject;
import com.ibm.trinity.spi.FatalModelAccessException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;

public class RhpApplication {
    private static final Logger LOGGER = Logger.getLogger(RhpApplication.class);
    private final IDispatch idisp;
    private boolean isRhpV2;
    private final IntegrationMode integrationMode;
    private static final String RHP2APP_CLS_ID = "{C1E0F602-2B50-11E8-9927-463500000031}";
    private static final String RHPAPP_CLS_ID = "{57DBF9D8-F318-11D2-B825-00104B3E6572}";
    private static final String RHP2INPROC_CLS_ID = "{C1E0F612-2B50-11E8-9927-463500000031}";
    private static final String RHPINPROC_CLS_ID = "{D091DB69-424A-40C7-94E9-0525EC6954EE}";
    private final ResourceManager rm;

    public boolean isRhpV2() {
        return this.isRhpV2;
    }

    IDispatch getIDispatch() {
        return this.idisp;
    }

    private RhpProject newRhpProject(IDispatch idisp, RhpApplicationHandler handler) throws FatalModelAccessException {
        if (idisp == null) {
            return null;
        }
        if (this.integrationMode == IntegrationMode.SPY_ACTIVE_APPLICATION) {
            handler.connect();
            return new RhpProject(idisp, handler);
        }
        return new RhpProject(idisp, null);
    }

    public String version() {
        return (String)this.idisp.invoke0("version");
    }

    public String versionNumberLong() {
        return (String)this.idisp.invoke0("versionNumberLong");
    }

    public String getErrorMessage() {
        try {
            return (String)this.idisp.invoke0("getErrorMessage");
        }
        catch (DispatchException e) {
            return "No error of IRPApplication.";
        }
    }

    public RhpProject openProject(String path, RhpApplicationHandler handler) throws FatalModelAccessException {
        try {
            IDispatch d = (IDispatch)this.idisp.invoke1("openProject", (Object)path);
            if (d == null) {
                String str = this.getErrorMessage();
                LOGGER.error((Object)("Failed to openProject: " + path + " " + str));
                return null;
            }
            return this.newRhpProject(d, handler);
        }
        catch (DispatchException e) {
            LOGGER.error((Object)("Failed to openProjectWithLastSession: " + path + " " + e));
            return null;
        }
    }

    public RhpProject openProject(DMParams.Options dmOptions, URI uri, RhpApplicationHandler handler) throws IOException, FatalModelAccessException {
        Object[] args = new Object[]{dmOptions.get((Object)DMParams.username), dmOptions.get((Object)DMParams.password), uri.toString(), dmOptions.get((Object)DMParams.projectAreaName), dmOptions.get((Object)DMParams.streamName), dmOptions.get((Object)DMParams.modelName)};
        try {
            IDispatch d = (IDispatch)this.idisp.invoke("openProjectFromDesignManager", args);
            return this.newRhpProject(d, handler);
        }
        catch (DispatchException e) {
            throw new IOException("Failed to openProjectFromDesignManager: " + dmOptions, e);
        }
    }

    public List<RhpProject> getProjects(RhpApplicationHandler handler) throws FatalModelAccessException {
        Object o = this.idisp.get("projects");
        if (!(o instanceof IDispatch)) {
            return new ArrayList<RhpProject>(0);
        }
        IDispatch idispCor = (IDispatch)o;
        if (!((o = idispCor.get("Items")) instanceof Object[])) {
            return new ArrayList<RhpProject>(0);
        }
        Object[] projs = (Object[])o;
        ArrayList<RhpProject> ret = new ArrayList<RhpProject>(projs.length);
        for (Object proj : projs) {
            if (!(proj instanceof IDispatch)) continue;
            ret.add(this.newRhpProject((IDispatch)proj, handler));
        }
        return ret;
    }

    public void quit() {
        try {
            switch (this.integrationMode) {
                case DLL_SERVER: {
                    try {
                        this.idisp.invoke0("terminateApplication");
                    }
                    catch (DispatchException dispatchException) {}
                    break;
                }
                case LOCAL_SERVER: {
                    try {
                        this.idisp.invoke0("quit");
                    }
                    catch (DispatchException dispatchException) {}
                    break;
                }
                case ACTIVE_APPLICATION: 
                case SPY_ACTIVE_APPLICATION: {
                    this.idisp.invoke0("disconnectFromTarget");
                    break;
                }
                default: {
                    throw new IllegalStateException("Fatal error: Unknown Integration Mode: " + this.integrationMode);
                }
            }
        }
        catch (DispatchException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RhpApplication(IntegrationMode integrationMode) throws IOException {
        IDispatch d;
        this.integrationMode = integrationMode;
        this.rm = ResourceManager.newResourceManager(null);
        IUnknown iunk = null;
        int rhpVer = integrationMode.getRhpAPIVersion();
        switch (integrationMode) {
            case DLL_SERVER: {
                if (rhpVer != 1 && (iunk = ComService.coCreateInstance((ResourceManager)this.rm, (String)RHP2INPROC_CLS_ID, (int)1, (boolean)false)) != null) {
                    this.isRhpV2 = true;
                    break;
                }
                if (rhpVer > 1) break;
                iunk = ComService.coCreateInstance((ResourceManager)this.rm, (String)RHPINPROC_CLS_ID, (int)1, (boolean)false);
                this.isRhpV2 = false;
                break;
            }
            case LOCAL_SERVER: {
                if (rhpVer != 1 && (iunk = ComService.coCreateInstance((ResourceManager)this.rm, (String)RHP2APP_CLS_ID, (int)4, (boolean)false)) != null) {
                    this.isRhpV2 = true;
                    break;
                }
                if (rhpVer > 1) break;
                iunk = ComService.coCreateInstance((ResourceManager)this.rm, (String)RHPAPP_CLS_ID, (int)4, (boolean)false);
                this.isRhpV2 = false;
                break;
            }
            case ACTIVE_APPLICATION: 
            case SPY_ACTIVE_APPLICATION: {
                if (rhpVer != 1 && (iunk = ComService.getActiveObject((ResourceManager)this.rm, (String)RHP2APP_CLS_ID, (boolean)false)) != null) {
                    this.isRhpV2 = true;
                    break;
                }
                if (rhpVer <= 1) {
                    iunk = ComService.getActiveObject((ResourceManager)this.rm, (String)RHPAPP_CLS_ID, (boolean)false);
                    this.isRhpV2 = false;
                }
                if (iunk != null) break;
                throw new RhpAccessFailureException("Failed to connect to the active Rhapsody application.  Please make sure that Rhapsody is running.");
            }
            default: {
                throw new IllegalArgumentException("Fatal error: Unknown Integration Mode: " + integrationMode);
            }
        }
        if (iunk == null) {
            throw new RhpAccessFailureException("Failed to initialize Rhapsody.  Check your Rhaposdy installation");
        }
        RhpModelElement.initialize(this.isRhpV2);
        try {
            d = (IDispatch)iunk.queryInterface(IUnknown.IID_IDispatch);
        }
        finally {
            iunk.release();
        }
        if (d == null) {
            throw new IOException("Failed to initialize IDispatch of RhpApplication: " + integrationMode);
        }
        if (integrationMode == IntegrationMode.DLL_SERVER) {
            IDispatch dApp = (IDispatch)d.invoke0("getHiddenApplication");
            if (dApp == null) {
                throw new IOException("getHiddenApplication failed in DLL_SERVER mode");
            }
            d.release();
            d = dApp;
        }
        this.idisp = d;
    }
}

