/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.trinity.rhapsody.ecore.impl;

import com.ibm.accessibility.com.win32.DispatchException;
import com.ibm.trinity.rhapsody.ecore.REObjectException;
import com.ibm.trinity.rhapsody.ecore.impl.REObjectImpl;
import com.ibm.trinity.rhapsody.ecore.robj.RhpGraphNode;
import com.ibm.trinity.rhapsody.ecore.robj.RhpModelElement;
import com.ibm.trinity.rhapsody.ecore.robj.RhpState;
import com.ibm.trinity.rhapsody.ecore.robj.RhpStateVertex;
import com.ibm.trinity.rhapsody.ecore.robj.RhpStatechart;
import com.ibm.trinity.rhapsody.ecore.robj.RhpStatechartDiagram;
import com.ibm.trinity.rhapsody.ecore.robj.RhpTransition;
import com.ibm.trinity.rhapsody.rhp.api.impl.REStateImpl;
import com.ibm.trinity.rhapsody.rhp.api.impl.REStateVertexImpl;
import com.ibm.trinity.rhapsody.rhp.api.impl.REStatechartImpl;
import com.ibm.trinity.rhapsody.rhp.api.impl.RETransitionImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;

class RhpStatechartUtil {
    private static final Logger LOGGER = Logger.getLogger(RhpStatechartUtil.class);
    private static final boolean DIAGRAM_SUPPORT = true;
    private static final int NEWSTATE_WIDTH = 100;
    private static final int NEWSTATE_HEIGHT = 50;
    private static final int NEWSTATE_MARGIN = 10;
    private static final int NEWSTATE_MIN_WIDTH = 110;
    private static final int NEWSTATE_INNER_SPACE = 70;
    private static final int NEWSTATE_SPACE = 70;

    RhpStatechartUtil() {
    }

    private static RhpStatechart findStatechart(EObject owner) {
        while (owner != null) {
            if (owner instanceof REStatechartImpl) {
                REStatechartImpl res = (REStatechartImpl)owner;
                return new RhpStatechart(res.rhpModelElement);
            }
            owner = owner.eContainer();
        }
        return null;
    }

    private static void recreateRhpTransitionGraphEdge(RETransitionImpl rtr, RhpTransition tr, RhpStateVertex newSts, RhpStateVertex newTts) {
        RhpStatechart sc = RhpStatechartUtil.findStatechart(rtr);
        if (sc == null) {
            return;
        }
        RhpStatechartDiagram dgm = sc.getStatechartDiagram();
        if (dgm == null) {
            return;
        }
        RhpGraphNode ges = dgm.findRhpGraphNode(newSts);
        if (ges == null) {
            return;
        }
        RhpGraphNode get = dgm.findRhpGraphNode(newTts);
        if (get == null) {
            return;
        }
        dgm.addNewEdgeForElement(tr, ges, 0, 0, get, 0, 0);
    }

    public static boolean setRhpTransitionTarget(RETransitionImpl rtr, Object rhpVal) throws REObjectException {
        if (!RhpModelElement.Type.IRPStateVertex.isRhpModelElement(rhpVal)) {
            throw new REObjectException("Target of a transition must be StateVertex");
        }
        RhpStateVertex newTts = new RhpStateVertex((RhpModelElement)rhpVal);
        RhpTransition tr = new RhpTransition(rtr.rhpModelElement);
        RhpStateVertex oldTts = tr.getItsTarget();
        if (newTts.equals(oldTts)) {
            return false;
        }
        try {
            RhpStatechartUtil.recreateRhpTransitionGraphEdge(rtr, tr, tr.getItsSource(), newTts);
        }
        catch (DispatchException e) {
            LOGGER.error((Object)("Failed to update the diagram: " + tr));
        }
        return true;
    }

    public static RhpTransition createRhpTransition(REObjectImpl owner, RETransitionImpl tr) throws REObjectException {
        RhpTransition rtr;
        if (!(owner instanceof REStateVertexImpl)) {
            throw new REObjectException("Transitions must be added to statevertex.");
        }
        RhpStateVertex rss = new RhpStateVertex(owner.rhpModelElement);
        REStateVertexImpl tts = (REStateVertexImpl)tr.getItsTarget();
        RhpStateVertex rst = tts == null ? rss : new RhpStateVertex(tts.rhpModelElement);
        try {
            rtr = rss.addTransition(rst);
        }
        catch (DispatchException exc) {
            throw new REObjectException("Failed to create a transition of " + rss + " - " + rst);
        }
        try {
            RhpStatechartDiagram dgm;
            RhpStatechart sc = RhpStatechartUtil.findStatechart((EObject)owner);
            if (sc != null && (dgm = sc.getStatechartDiagram()) != null) {
                RhpGraphNode ges = dgm.findRhpGraphNode(rss);
                RhpGraphNode get = dgm.findRhpGraphNode(rst);
                if (ges != null && get != null) {
                    dgm.addNewEdgeForElement(rtr, ges, 0, 0, get, 0, 0);
                }
            }
        }
        catch (DispatchException exc) {
            LOGGER.error((Object)("Failed to update statechart diagram: " + rtr));
        }
        return rtr;
    }

    private static void restoreDescendants(GElem tgt, ArrayList<GElem> gelems) {
        GElem ge;
        int size = gelems.size();
        for (int idx = 0; idx < size && (ge = gelems.get(idx)).getBottom() >= tgt.getY(); ++idx) {
            if (ge == tgt || !tgt.contains(ge)) continue;
            ge.reset();
        }
    }

    private static void enlargeAscendants(GElem tgt, ArrayList<GElem> gelems) {
        GElem ge;
        int x = tgt.getX();
        int right = tgt.getRight();
        int y = tgt.getY();
        int bottom = tgt.getBottom();
        for (int idx = gelems.size() - 1; idx >= 0 && (ge = gelems.get(idx)).getBottom() >= bottom; --idx) {
            if (ge.getY() > y || ge.getX() > x || ge.getRight() < right) continue;
            ge.enlarge(110, 70 + ge.getHeight());
            RhpStatechartUtil.restoreDescendants(ge, gelems);
        }
    }

    private static void putNewState(RhpState parent, RhpState st, RhpStatechart sc) {
        int y;
        int x;
        RhpStatechartDiagram dgm = sc.getStatechartDiagram();
        List<RhpGraphNode> ges = dgm.getRhpGraphNodes();
        ArrayList<GElem> gelems = new ArrayList<GElem>(ges.size());
        GElem parentElem = null;
        for (RhpGraphNode gn : ges) {
            GElem ge = new GElem(gn);
            gelems.add(ge);
            RhpModelElement mo = gn.getModelObject();
            if (parent == null || !parent.equals(mo)) continue;
            parentElem = ge;
        }
        Collections.sort(gelems);
        int idx = gelems.size() - 1;
        if (parentElem == null) {
            x = 0;
            if (idx < 0) {
                y = 0;
            } else {
                GElem elem = (GElem)gelems.get(idx);
                y = elem.getBottom();
            }
            y += 10;
        } else {
            GElem ge;
            y = parentElem.getY();
            int downDiff = 70;
            if (parentElem.getWidth() < 110) {
                downDiff += parentElem.getHeight();
            }
            while (idx >= 0 && (ge = (GElem)gelems.get(idx)).getBottom() >= y) {
                if (ge != parentElem && ge.getY() >= parentElem.getY() && !parentElem.contains(ge)) {
                    ge.down(downDiff);
                }
                --idx;
            }
            RhpStatechartUtil.enlargeAscendants(parentElem, gelems);
            x = parentElem.getX();
            y = parentElem.getBottom() - 70 + 10;
        }
        sc.addNewNodeForElement(st, x, y, 100, 50);
    }

    public static RhpState createRhpState(REObjectImpl owner, REStateImpl s) throws REObjectException {
        String name = s.getName();
        if (!(owner instanceof REStateImpl)) {
            throw new REObjectException("States must be added to state");
        }
        REStateImpl res = (REStateImpl)owner;
        RhpStatechart sc = RhpStatechartUtil.findStatechart(res);
        RhpState parent = new RhpState(res.rhpModelElement);
        RhpState st = parent.addState(name);
        try {
            RhpStatechartUtil.putNewState(parent, st, sc);
        }
        catch (DispatchException exc) {
            LOGGER.error((Object)("Failed to update statechart diagram: " + st));
        }
        return st;
    }

    public static class GElem
    implements Comparable<GElem> {
        private int x;
        private int y;
        private int width;
        private int height;
        public final RhpGraphNode gn;

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getRight() {
            return this.x + this.width;
        }

        public int getBottom() {
            return this.y + this.height;
        }

        public int getWidth() {
            return this.height;
        }

        public int getHeight() {
            return this.height;
        }

        private void reportError(String mes) {
            throw new RuntimeException("Invalid GraphNode:" + mes);
        }

        public void down(int diff) {
            this.y += diff;
            this.gn.setGraphicalProperty("Position", this.x + "," + this.y);
        }

        public void enlarge(int newW, int newH) {
            if (newW > this.width) {
                this.gn.setGraphicalProperty("Width", Integer.toString(newW));
                this.width = newW;
            }
            if (newH > this.height) {
                this.gn.setGraphicalProperty("Height", Integer.toString(newH));
                this.height = newH;
            }
        }

        public boolean contains(GElem e) {
            return this.x <= e.x && this.y <= e.y && e.getRight() <= this.getRight() && e.getBottom() <= this.getBottom();
        }

        public void reset() {
            this.gn.setGraphicalProperty("Position", this.x + "," + this.y);
            this.gn.setGraphicalProperty("Width", Integer.toString(this.width));
            this.gn.setGraphicalProperty("Height", Integer.toString(this.height));
        }

        @Override
        public int compareTo(GElem e) {
            return this.getBottom() - e.getBottom();
        }

        public GElem(RhpGraphNode gn) {
            this.gn = gn;
            String pos = gn.getGraphicalPropertyString("Position");
            int idx = pos.indexOf(44);
            if (idx < 0) {
                this.reportError("Position does not have `,'");
            }
            this.x = Integer.parseInt(pos.substring(0, idx));
            this.y = Integer.parseInt(pos.substring(idx + 1));
            String wstr = gn.getGraphicalPropertyString("Width");
            this.width = Integer.parseInt(wstr);
            String hstr = gn.getGraphicalPropertyString("Height");
            this.height = Integer.parseInt(hstr);
        }

        public GElem(int bottom) {
            this.x = 0;
            this.y = bottom;
            this.width = 0;
            this.height = 0;
            this.gn = null;
        }
    }
}

