/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.trinity.rhapsody.ecore.impl;

import com.ibm.accessibility.com.win32.DispatchException;
import com.ibm.accessibility.com.win32.Handler;
import com.ibm.accessibility.com.win32.HandlerRegistry;
import com.ibm.trinity.rhapsody.ecore.Activator;
import com.ibm.trinity.rhapsody.ecore.REObjectException;
import com.ibm.trinity.rhapsody.ecore.REOperationException;
import com.ibm.trinity.rhapsody.ecore.RhpAccessFailureException;
import com.ibm.trinity.rhapsody.ecore.RhpApiResource;
import com.ibm.trinity.rhapsody.ecore.adapter.RhpModelAccessAdapter;
import com.ibm.trinity.rhapsody.ecore.impl.DMParams;
import com.ibm.trinity.rhapsody.ecore.impl.REObjectImpl;
import com.ibm.trinity.rhapsody.ecore.impl.RhpApiResourceFactoryImpl;
import com.ibm.trinity.rhapsody.ecore.impl.RhpStatechartUtil;
import com.ibm.trinity.rhapsody.ecore.robj.RhpApplication;
import com.ibm.trinity.rhapsody.ecore.robj.RhpApplicationHandler;
import com.ibm.trinity.rhapsody.ecore.robj.RhpCollection;
import com.ibm.trinity.rhapsody.ecore.robj.RhpModelElement;
import com.ibm.trinity.rhapsody.ecore.robj.RhpProject;
import com.ibm.trinity.rhapsody.ecore.robj.RhpRelation;
import com.ibm.trinity.rhapsody.rhp.api.ApiFactory;
import com.ibm.trinity.rhapsody.rhp.api.ApiPackage;
import com.ibm.trinity.rhapsody.rhp.api.REClassifier;
import com.ibm.trinity.rhapsody.rhp.api.RECustomConnector;
import com.ibm.trinity.rhapsody.rhp.api.REInstance;
import com.ibm.trinity.rhapsody.rhp.api.REModelElement;
import com.ibm.trinity.rhapsody.rhp.api.REPort;
import com.ibm.trinity.rhapsody.rhp.api.RETransition;
import com.ibm.trinity.rhapsody.rhp.api.impl.ApiPackageImpl;
import com.ibm.trinity.rhapsody.rhp.api.impl.REAttributeImpl;
import com.ibm.trinity.rhapsody.rhp.api.impl.REClassifierImpl;
import com.ibm.trinity.rhapsody.rhp.api.impl.RECustomConnectorImpl;
import com.ibm.trinity.rhapsody.rhp.api.impl.REDependencyImpl;
import com.ibm.trinity.rhapsody.rhp.api.impl.REFlowImpl;
import com.ibm.trinity.rhapsody.rhp.api.impl.REGeneralizationImpl;
import com.ibm.trinity.rhapsody.rhp.api.impl.REInstanceImpl;
import com.ibm.trinity.rhapsody.rhp.api.impl.REModelElementImpl;
import com.ibm.trinity.rhapsody.rhp.api.impl.REProjectImpl;
import com.ibm.trinity.rhapsody.rhp.api.impl.RERelationImpl;
import com.ibm.trinity.rhapsody.rhp.api.impl.REStateImpl;
import com.ibm.trinity.rhapsody.rhp.api.impl.REStateVertexImpl;
import com.ibm.trinity.rhapsody.rhp.api.impl.REStereotypedTagImpl;
import com.ibm.trinity.rhapsody.rhp.api.impl.RETagImpl;
import com.ibm.trinity.rhapsody.rhp.api.impl.RETransitionImpl;
import com.ibm.trinity.spi.DataSourceModelAccessException;
import com.ibm.trinity.spi.FatalModelAccessException;
import com.ibm.trinity.spi.ModelAccessException;
import com.maplesoft.maplembse.license.CheckLicense;
import com.maplesoft.maplembse.license.LicenseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalCommandStack;
import org.eclipse.emf.transaction.TransactionalEditingDomain;

public class RhpApiResourceImpl
extends XMIResourceImpl
implements RhpApiResource {
    public static final String OPTION_TXDOMAIN = RhpApiResourceImpl.class.getName() + ".TransactionalEditingDomain";
    private static final Logger LOGGER = Logger.getLogger((String)RhpApiResourceImpl.class.getName());
    protected static boolean DEBUG = false;
    protected final Map<String, REObjectImpl> guidToEObjectMap = new HashMap<String, REObjectImpl>();
    private boolean isProxyMode = true;
    protected boolean bURIChanged = false;
    protected RhpApplication rpapp = null;
    protected RhpProject rpprj = null;
    private RhpModelAccessAdapter adapter = null;
    private boolean modelChanged = false;
    private REObjectImpl ownerTryToAdd = null;
    private RhpHandler handler = null;
    private Handler workbookHandler = null;
    private DMParams.Options dmOptions;

    public static void setDebug(boolean b) {
        DEBUG = b;
    }

    static void out(String str) {
        if (DEBUG) {
            System.out.println(str);
        }
    }

    static void err(String str) {
        if (DEBUG) {
            System.err.println(str);
        }
    }

    public void setRhpModelAccessAdapter(RhpModelAccessAdapter adapter) {
        this.adapter = adapter;
    }

    private void processModelElementChange(String guid) {
        RhpModelElement rme;
        REObjectImpl reo = this.guidToEObjectMap.get(guid);
        if (LOGGER.isDebugEnabled()) {
            rme = this.rpprj.findElementByGUID(guid);
            StringBuilder sb = new StringBuilder("onElementsChanged: ");
            if (rme == null) {
                sb.append("DELETED ");
            } else {
                sb.append(rme.getFullPathName());
                sb.append(' ');
            }
            if (reo != null) {
                reo.rhpModelElement = rme;
                sb.append("RO:");
                sb.append((Object)reo);
            }
            LOGGER.debug((Object)sb.toString());
            if (reo == null) {
                return;
            }
        } else {
            if (reo == null) {
                return;
            }
            rme = this.rpprj.findElementByGUID(guid);
        }
        if (rme == null) {
            this.modelChanged = true;
            try {
                this.deleteEObject(reo, false);
            }
            catch (REObjectException e) {
                LOGGER.error((Object)("Failed to delete REObject: " + reo), (Throwable)((Object)e));
            }
        } else {
            reo.rhpModelElement = rme;
            if (!reo.isValid()) {
                return;
            }
            try {
                if (((Object)((Object)reo)).equals((Object)this.ownerTryToAdd)) {
                    reo.reloadChangedElementFeatures(false);
                } else {
                    reo.reloadChangedElementFeatures(true);
                }
                this.modelChanged = true;
            }
            catch (REObjectException e) {
                LOGGER.error((Object)("Failed to reload REObject: " + reo), (Throwable)((Object)e));
            }
        }
    }

    private void notifyToWorkbook() {
        if (this.workbookHandler != null) {
            this.workbookHandler.defaultHandler(0, null);
        }
    }

    private RhpApplication getRhpApplication() throws LicenseException {
        if (this.rpapp == null) {
            CheckLicense.check((String)"MapleMBSERhpAdapter");
            this.rpapp = Activator.getDefault().getRhpApplication();
            this.handler = new RhpHandler(this.rpapp);
            LOGGER.info((Object)("Got the Rhapsody Application object: version=" + this.rpapp.versionNumberLong()));
        }
        return this.rpapp;
    }

    public RhpApiResourceImpl(URI uri) {
        this(uri, null);
    }

    public RhpApiResourceImpl(URI uri, DMParams.Options options) {
        super(uri);
        this.dmOptions = options;
        this.setTrackingModification(true);
        this.workbookHandler = HandlerRegistry.getInstance().get("TrinityWorkbook");
    }

    @Override
    public void setProxyMode(boolean isProxyMode) {
        this.isProxyMode = isProxyMode;
        LOGGER.info((Object)("Set proxy mode to " + isProxyMode + ": " + this.getURI().toString()));
    }

    public void setApplication(RhpApplication app) {
        if (this.rpapp != null) {
            this.handler.disconnect();
        }
        this.rpapp = app;
        this.handler = new RhpHandler(this.rpapp);
    }

    private boolean openRhpDMProject() throws IOException, FatalModelAccessException, LicenseException {
        if (this.dmOptions == null) {
            return false;
        }
        RhpApplication app = this.getRhpApplication();
        RhpProject theProject = app.openProject(this.dmOptions, this.getURI(), this.handler);
        if (theProject == null) {
            return false;
        }
        this.rpprj = theProject;
        return true;
    }

    private boolean openRhpFileProject() throws IOException, FatalModelAccessException, LicenseException {
        URI uri = this.getURI();
        if (!RhpApiResourceFactoryImpl.isRhapsodyFileURI(uri)) {
            return false;
        }
        String expectedProjectPath = uri.toFileString();
        assert (expectedProjectPath != null) : "";
        RhpApplication app = this.getRhpApplication();
        RhpProject theProject = null;
        List<RhpProject> projects = app.getProjects(this.handler);
        for (RhpProject project : projects) {
            IPath projectPath = project.pathOf();
            if (!projectPath.toOSString().equals(expectedProjectPath)) continue;
            theProject = project;
            break;
        }
        if (theProject == null && (theProject = app.openProject(expectedProjectPath, this.handler)) == null) {
            StringBuilder s = new StringBuilder("The Rhapsody model seems corrupted: ");
            s.append(expectedProjectPath);
            throw new IOException(s.toString());
        }
        this.rpprj = theProject;
        return true;
    }

    private void loadProject(TransactionalEditingDomain editingDomain, LoadCommand cmd) throws ModelAccessException {
        if (editingDomain == null) {
            cmd.doTrinityExecute();
        } else {
            TransactionalCommandStack stack = (TransactionalCommandStack)editingDomain.getCommandStack();
            try {
                stack.execute((Command)cmd, Collections.EMPTY_MAP);
                ModelAccessException e = cmd.getException();
                if (e != null) {
                    throw e;
                }
            }
            catch (RollbackException e) {
                throw new DataSourceModelAccessException("Failed to load the Rhapsody Project", (Throwable)e);
            }
            catch (InterruptedException e) {
                throw new DataSourceModelAccessException("Interrupted while loading the Rhapsody Project");
            }
            finally {
                stack.flush();
            }
        }
    }

    public void load(Map<?, ?> options) throws IOException {
        StringBuffer sb = new StringBuffer();
        sb.append("Start loading Rhapsody model: ");
        sb.append("proxyMode=").append(Boolean.toString(this.isProxyMode));
        sb.append(", uri=").append(this.getURI());
        LOGGER.info((Object)sb.toString());
        Object o = options.get(OPTION_TXDOMAIN);
        TransactionalEditingDomain editingDomain = o instanceof TransactionalEditingDomain ? (TransactionalEditingDomain)o : null;
        try {
            if (this.rpprj != null) {
                return;
            }
            if (this.openRhpDMProject()) {
                this.loadProject(editingDomain, new LoadRhpDMProjectCommand(editingDomain, this));
            } else if (this.openRhpFileProject()) {
                this.loadProject(editingDomain, new LoadRhpProjectCommand(editingDomain, this));
            } else {
                super.load(options);
            }
        }
        catch (RhpAccessFailureException exc) {
            LOGGER.error((Object)("Failed to access Rhapsody: " + exc.getMessage()));
            throw new IOException(exc.getMessage(), exc);
        }
        catch (LicenseException exc) {
            LOGGER.error((Object)("Failed to get a license for Rhapsody Adapter: " + exc.getMessage()));
            throw new IOException(exc);
        }
        catch (ModelAccessException exc) {
            LOGGER.error((Object)("Failed to open the Rhapsody model: " + exc.getMessage()));
            throw new IOException(exc);
        }
        catch (FatalModelAccessException exc) {
            LOGGER.error((Object)exc.getMessage());
            throw new IOException(exc.getMessage());
        }
        catch (DispatchException e) {
            LOGGER.error((Object)("Failed to open the Rhapsody model: " + e.getMessage()));
            e.printStackTrace();
            throw new IOException(e);
        }
        finally {
            this.setModified(false);
        }
    }

    protected void doUnload() {
        if (this.contents.size() != 1) {
            LOGGER.error((Object)("[Unload] Number of roots: " + this.contents.size()));
        }
        for (EObject e : this.contents) {
            if (!(e instanceof REProjectImpl)) continue;
            REProjectImpl prj = (REProjectImpl)e;
            prj.rhpModelElement = null;
        }
        if (this.rpprj != null) {
            this.rpprj.close();
            this.rpprj = null;
        }
        if (this.rpapp != null) {
            this.handler.disconnect();
            Activator.getDefault().disposeRhpApplication(this.rpapp);
            this.rpapp = null;
        }
        this.guidToEObjectMap.clear();
        boolean b = this.eDeliver();
        this.eSetDeliver(false);
        this.eAdapters().clear();
        this.eSetDeliver(b);
        super.doUnload();
    }

    public void touch(REModelElementImpl remel) throws ModelAccessException {
        String guid;
        REObjectImpl result;
        RhpRelation rhpRel;
        RhpRelation rhpInv;
        RERelationImpl rel;
        RERelationImpl inv;
        remel.loadFeature((EStructuralFeature)ApiPackage.eINSTANCE.getREModelElement_NestedElements());
        if (remel instanceof RERelationImpl && (inv = (RERelationImpl)(rel = (RERelationImpl)remel).getInverse()) == null && (rhpInv = (rhpRel = new RhpRelation(remel.rhpModelElement)).getInverse()) != null && (result = this.doGetEObjectByID(guid = rhpInv.getGUID(), false)) instanceof RERelationImpl) {
            inv = (RERelationImpl)result;
            rel.setInverse(inv);
            inv.setInverse(rel);
        }
        for (EObject e : remel.eContents()) {
            this.touch((REModelElementImpl)e);
        }
    }

    public void setURI(URI uri) {
        URI uri0 = this.getURI();
        DMParams.Options params = new DMParams.Options();
        URI dmuri = params.processDMURI(uri);
        if (dmuri != null) {
            if (!params.equals(this.dmOptions)) {
                this.dmOptions = params;
                this.bURIChanged = true;
            }
            uri = dmuri;
        } else {
            this.dmOptions = null;
        }
        if (!uri.equals(uri0)) {
            super.setURI(uri);
            this.bURIChanged = true;
        }
    }

    public void saveAs(URI uri, Map<?, ?> options) throws IOException {
        this.setURI(uri);
        this.save(options);
    }

    public void saveCopyAs(URI uri, Map<?, ?> options) throws IOException {
        URI orgUri = this.uri;
        this.saveAs(uri, options);
        this.uri = orgUri;
        this.save(options);
    }

    private void saveToChangedURI() throws IOException {
        URI uri = this.getURI();
        if (this.dmOptions != null) {
            this.rpprj.moveProject(this.dmOptions, uri);
        } else {
            String str0;
            if (uri.isFile()) {
                str0 = uri.toFileString();
                str0 = URI.decode((String)str0);
            } else if (uri.isPlatform()) {
                String str = uri.toPlatformString(true);
                IWorkspaceRoot wsr = ResourcesPlugin.getWorkspace().getRoot();
                IFile file = wsr.getFile((IPath)new Path(str));
                IPath path = file.getRawLocation();
                str0 = path.toOSString();
            } else {
                throw new IOException("Unexpected URI: " + uri.toString());
            }
            this.rpprj.saveAs(str0);
        }
        this.bURIChanged = false;
    }

    public void save(Map<?, ?> options) throws IOException {
        if (this.dmOptions == null && !RhpApiResourceFactoryImpl.isRhapsodyFileURI(this.getURI())) {
            super.save(options);
            return;
        }
        switch (Activator.getDefault().getIntegrationMode()) {
            case ACTIVE_APPLICATION: 
            case SPY_ACTIVE_APPLICATION: {
                return;
            }
        }
        if (this.bURIChanged) {
            this.saveToChangedURI();
        } else {
            this.rpprj.save();
        }
        this.setModified(false);
    }

    REObjectImpl getEObjectFromRhpModelElement(RhpModelElement rme) {
        String guid = rme.getGUID();
        REObjectImpl result = this.doGetEObjectByID(guid, false);
        if (result == null) {
            result = this.createEObject(rme);
            result.eSetProxyURI(this.getURI().appendFragment(guid));
        }
        return result;
    }

    protected REObjectImpl getEObjectByID(String guid) {
        return this.doGetEObjectByID(guid, true);
    }

    protected REObjectImpl doGetEObjectByID(String guid, boolean canCreate) {
        REObjectImpl result = this.guidToEObjectMap.get(guid);
        if (result != null) {
            return result;
        }
        if (canCreate && this.rpprj != null) {
            RhpModelElement mel = this.getRhapsodyModelElement(guid);
            if (mel == null) {
                return null;
            }
            result = this.createEObject(mel);
            this.guidToEObjectMap.put(guid, result);
            if (this.isProxyMode) {
                return result;
            }
            try {
                result.loadAllFeatures();
                return result;
            }
            catch (REObjectException rEObjectException) {
                // empty catch block
            }
        }
        return null;
    }

    void createInverseRelation(REClassifierImpl owrc, RERelationImpl rel, RhpRelation rhpRel) {
        RhpRelation rhpInverse = rhpRel.getInverse();
        if (rhpInverse != null) {
            RERelationImpl inverse = (RERelationImpl)ApiFactory.eINSTANCE.createRERelation();
            inverse.setRhpModelElement(rhpInverse);
            inverse.setInverse(rel);
            rel.setInverse(inverse);
            owrc.getNestedElements().add((Object)inverse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(REObjectImpl owner, EStructuralFeature ftr, EObject obj, int index, Map<EStructuralFeature, Object> inits) throws ModelAccessException {
        RhpModelElement mel;
        REModelElementImpl reo;
        block26: {
            if (owner == null || !owner.isValid()) {
                throw new REObjectException("Invalid owner object");
            }
            if (!(obj instanceof REModelElementImpl)) {
                throw new REObjectException("Invalid child object");
            }
            if (!ftr.equals(ApiPackageImpl.eINSTANCE.getREModelElement_NestedElements())) {
                throw new REObjectException("Not a containment feature: " + ftr.getName());
            }
            if (index >= 0) {
                throw new REObjectException("nestedElements of Rhapsody does not support ordered set: " + index);
            }
            reo = (REModelElementImpl)obj;
            this.ownerTryToAdd = owner;
            try {
                String strcls;
                if (obj instanceof RETransitionImpl) {
                    reo.rhpModelElement = mel = RhpStatechartUtil.createRhpTransition(owner, (RETransitionImpl)obj);
                    break block26;
                }
                if (obj instanceof REStateImpl) {
                    reo.rhpModelElement = mel = RhpStatechartUtil.createRhpState(owner, (REStateImpl)obj);
                    break block26;
                }
                if (obj instanceof RERelationImpl && !(obj instanceof REInstanceImpl)) {
                    if (!(owner instanceof REClassifierImpl)) {
                        throw new REObjectException("Non-classifier model element cannot have association or composition");
                    }
                    RERelationImpl rel = (RERelationImpl)obj;
                    if ("Composition".equals(rel.getRelationType())) {
                        throw new REOperationException("Composition type relationship cannot be created.  Use REInstance instead.");
                    }
                    mel = null;
                    reo.rhpModelElement = null;
                    break block26;
                }
                if (obj instanceof REStereotypedTagImpl) {
                    mel = null;
                    break block26;
                }
                if (obj instanceof RECustomConnector) {
                    mel = null;
                    break block26;
                }
                String strname = null;
                String struser = strcls = reo.addNewAggrCls();
                if (inits != null) {
                    if (inits.containsKey(ApiPackage.eINSTANCE.getREModelElement_UserDefinedMetaClass())) {
                        struser = reo.getUserDefinedMetaClass();
                    }
                    if (inits.containsKey(ApiPackage.eINSTANCE.getREModelElement_Name())) {
                        strname = reo.getName();
                    }
                }
                RhpModelElement monr = owner.rhpModelElement;
                try {
                    mel = monr.addNewAggr(strcls, strname);
                }
                catch (DispatchException exc) {
                    throw new REObjectException("Failed to create an object: " + strname + "/" + strcls, exc);
                }
                reo.rhpModelElement = mel;
                strcls = mel.getUserDefinedMetaClass();
                if (struser != null && !struser.equals(strcls)) {
                    if (strcls.equals("PrimitiveOperation") && struser.equals("Operation")) {
                    } else {
                        LOGGER.info((Object)("Failed to create a new object of class: " + strcls));
                        reo.rhpModelElement = mel = mel.changeTo(struser);
                    }
                }
            }
            finally {
                this.ownerTryToAdd = null;
            }
        }
        if (owner instanceof REModelElementImpl && reo instanceof REModelElementImpl) {
            ((REModelElementImpl)owner).getNestedElements().add((Object)reo);
        }
        if (mel != null) {
            try {
                reo.initsRhpAndLoadNestedElemenets(inits);
            }
            catch (ModelAccessException exc) {
                mel.deleteFromProject();
                throw exc;
            }
            this.guidToEObjectMap.put(reo.getRhpModelElement().getGUID(), reo);
        }
    }

    private REObjectImpl createEObject(RhpModelElement element) {
        EClassifier cls;
        String className = element.getRETypeName();
        if ("RETag".equals(className)) {
            Object baseObj = element.get("base");
            if (baseObj instanceof RhpModelElement) {
                EClass eCls = ApiPackage.eINSTANCE.getREStereotypedTag();
                REStereotypedTagImpl sTag = (REStereotypedTagImpl)EcoreUtil.create((EClass)eCls);
                sTag.setRhpModelElement(element);
                sTag.initBaseTag((RhpModelElement)baseObj);
                return sTag;
            }
            cls = ApiPackage.eINSTANCE.getRETag();
        } else {
            if ("RELink".equals(className)) {
                EClass eCls = ApiPackage.eINSTANCE.getRECustomConnector();
                RECustomConnectorImpl cConnector = (RECustomConnectorImpl)EcoreUtil.create((EClass)eCls);
                cConnector.setRhpModelElement(element);
                if (element.get("fromPort") != null) {
                    cConnector.setFPort((REPort)((Object)this.getEObjectFromRhpModelElement((RhpModelElement)element.get("fromPort"))));
                }
                if (element.get("toPort") != null) {
                    cConnector.setTPort((REPort)((Object)this.getEObjectFromRhpModelElement((RhpModelElement)element.get("toPort"))));
                }
                if (element.get("from") != null) {
                    cConnector.setFromPart((REInstance)((Object)this.getEObjectFromRhpModelElement((RhpModelElement)element.get("from"))));
                }
                if (element.get("to") != null) {
                    cConnector.setToPart((REInstance)((Object)this.getEObjectFromRhpModelElement((RhpModelElement)element.get("to"))));
                }
                return cConnector;
            }
            cls = ApiPackage.eINSTANCE.getEClassifier(className);
            if (cls == null) {
                cls = ApiPackage.eINSTANCE.getREModelElement();
            } else if (!(cls instanceof EClass)) {
                throw new IllegalArgumentException("No corresponding EClass is found: " + className);
            }
        }
        REObjectImpl result = (REObjectImpl)EcoreUtil.create((EClass)((EClass)cls));
        result.setRhpModelElement(element);
        return result;
    }

    void deleteTree(REObjectImpl reo) throws REObjectException {
        EObject[] arr;
        Object[] arr0 = new EObject[]{};
        for (EObject o : arr = (EObject[])reo.eContents().toArray(arr0)) {
            if (!(o instanceof REObjectImpl)) {
                throw new REObjectException("*** Internal Error ***");
            }
            this.deleteTree((REObjectImpl)o);
        }
        RhpModelElement mel = reo.getRhpModelElement();
        reo.setRhpModelElement(null);
        if (mel != null && mel.isValid()) {
            String strguid = mel.getGUID();
            this.guidToEObjectMap.remove(strguid);
        }
        EcoreUtil.delete((EObject)reo);
    }

    private void deleteTags(REClassifierImpl cls, REModelElement mel, ArrayList<REObjectImpl> rts) {
        if (EcoreUtil.isAncestor(rts, (EObject)mel)) {
            return;
        }
        if (mel instanceof RETagImpl) {
            RETagImpl tag = (RETagImpl)mel;
            REClassifier typ = tag.getType();
            if (typ == null) {
                return;
            }
            if (typ.equals(cls)) {
                rts.add(0, tag);
            }
            return;
        }
        for (EObject o : mel.eContents()) {
            if (!(o instanceof REModelElement)) continue;
            this.deleteTags(cls, (REModelElement)o, rts);
        }
    }

    private void deleteTags(REClassifierImpl cls, ArrayList<REObjectImpl> rts, boolean rhpDelete) throws REObjectException {
        REProjectImpl prj;
        RETagImpl tag;
        REClassifier typ;
        Object o = cls.eGetWithLoad((EStructuralFeature)ApiPackage.eINSTANCE.getREModelElement_Owner());
        if (o instanceof RETagImpl && cls.equals(typ = (REClassifier)(tag = (RETagImpl)o).eGetWithLoad((EStructuralFeature)ApiPackage.eINSTANCE.getREVariable_Type()))) {
            return;
        }
        if (rhpDelete) {
            cls.loadFeature((EStructuralFeature)ApiPackage.eINSTANCE.getREModelElement_Project());
        }
        if ((prj = (REProjectImpl)cls.getProject()) != null) {
            this.deleteTags(cls, prj, rts);
        }
    }

    protected void deleteEObject(REObjectImpl reo, ArrayList<REObjectImpl> rts, boolean rhpDelete) throws REObjectException {
        if (rts.contains((Object)reo)) {
            rts.remove((Object)reo);
        } else {
            REObjectImpl dreo;
            if (EcoreUtil.isAncestor(rts, (EObject)reo)) {
                return;
            }
            do {
                dreo = null;
                for (REObjectImpl d : rts) {
                    if (!EcoreUtil.isAncestor((EObject)reo, (EObject)d)) continue;
                    dreo = d;
                    break;
                }
                if (dreo == null) continue;
                rts.remove((Object)dreo);
            } while (dreo != null);
        }
        rts.add(0, reo);
        this.deleteRefs(reo, rts, rhpDelete);
    }

    protected void deleteRefs(REObjectImpl reo, ArrayList<REObjectImpl> rts, boolean rhpDelete) throws REObjectException {
        REObjectImpl[] aContents;
        EList el = reo.eContents();
        REObjectImpl[] a0 = new REObjectImpl[]{};
        for (REObjectImpl creo : aContents = (REObjectImpl[])el.toArray((Object[])a0)) {
            this.deleteRefs(creo, rts, rhpDelete);
        }
        if (reo instanceof REClassifierImpl) {
            this.deleteTags((REClassifierImpl)reo, rts, rhpDelete);
        } else if (reo instanceof RERelationImpl) {
            RERelationImpl rel = (RERelationImpl)reo;
            RERelationImpl inverse = (RERelationImpl)rel.getInverse();
            if (inverse != null) {
                inverse.setInverse(null);
                this.deleteTree(inverse);
            }
        } else if (reo instanceof REStateVertexImpl) {
            if (!rhpDelete) {
                return;
            }
            reo.loadFeature((EStructuralFeature)ApiPackage.eINSTANCE.getREStateVertex_InTransitions());
            REStateVertexImpl resv = (REStateVertexImpl)reo;
            EList<RETransition> erefs = resv.getInTransitions();
            for (REModelElement eref : erefs) {
                this.deleteEObject((REObjectImpl)((Object)eref), rts, rhpDelete);
            }
        }
        if (!rhpDelete) {
            return;
        }
        reo.loadFeature((EStructuralFeature)ApiPackage.eINSTANCE.getREModelElement_References());
        REModelElementImpl rmel = (REModelElementImpl)reo;
        EList<REModelElement> erefs = rmel.getReferences();
        for (REModelElement eref : erefs) {
            if (eref instanceof REDependencyImpl || eref instanceof REGeneralizationImpl || eref instanceof REFlowImpl || eref instanceof RERelationImpl) {
                this.deleteEObject((REObjectImpl)((Object)eref), rts, rhpDelete);
                continue;
            }
            if (eref instanceof RETagImpl) {
                if (eref.equals(reo.eContainer())) continue;
                this.deleteEObject((REObjectImpl)((Object)eref), rts, rhpDelete);
                continue;
            }
            if (!(eref instanceof REAttributeImpl)) continue;
            this.deleteEObject((REObjectImpl)((Object)eref), rts, rhpDelete);
        }
    }

    public void deleteEObject(REObjectImpl reo, boolean rhpDelete) throws REObjectException {
        ArrayList<REObjectImpl> rts = new ArrayList<REObjectImpl>();
        this.deleteEObject(reo, rts, rhpDelete);
        for (REObjectImpl r : rts) {
            if (rhpDelete) {
                RhpModelElement mel = r.getRhpModelElement();
                if (mel == null) {
                    this.deleteTree(r);
                    continue;
                }
                if (!mel.isValid()) {
                    throw new REObjectException("Invalid object");
                }
                this.deleteTree(r);
                try {
                    mel.deleteFromProject();
                    continue;
                }
                catch (DispatchException exc) {
                    throw new REObjectException("Error in deleting an RPObject", exc);
                }
            }
            this.deleteTree(r);
        }
    }

    public void deleteEObject(REObjectImpl reo) throws REObjectException {
        this.deleteEObject(reo, true);
    }

    @Override
    public RhpModelElement getRhapsodyModelElement(String guid) {
        if (this.rpprj == null) {
            return null;
        }
        RhpModelElement result = null;
        String id = URI.decode((String)guid);
        result = this.rpprj.findElementByGUID(id);
        return result;
    }

    public void attached(EObject eObject) {
        RhpModelElement mel;
        REObjectImpl reo;
        LOGGER.debug((Object)("Attached: " + eObject));
        super.attached(eObject);
        if (eObject instanceof REObjectImpl && !(reo = (REObjectImpl)eObject).eIsProxy() && (mel = reo.getRhpModelElement()) != null && mel.isValid()) {
            this.guidToEObjectMap.put(mel.getGUID(), reo);
        }
    }

    public void detached(EObject eObject) {
        REObjectImpl reo;
        LOGGER.debug((Object)("Detatched: " + eObject));
        if (eObject instanceof REObjectImpl && !(reo = (REObjectImpl)eObject).eIsProxy()) {
            RhpModelElement mel = reo.getRhpModelElement();
            if (mel != null && mel.isValid()) {
                this.guidToEObjectMap.remove(mel.getGUID());
            } else {
                Object err = this.rpapp != null ? this.rpapp.getErrorMessage() : "Detach to invalid RhpModelElement: " + mel;
                LOGGER.error(err);
            }
        }
        super.detached(eObject);
    }

    private class RhpHandler
    extends RhpApplicationHandler {
        @Override
        public void processModelElementsChange(String[] guids) {
            RhpApiResourceImpl.this.modelChanged = false;
            RhpApiResourceImpl.this.adapter.executeCommand(new EditCommand(guids));
            if (RhpApiResourceImpl.this.modelChanged) {
                RhpApiResourceImpl.this.notifyToWorkbook();
            }
        }

        RhpHandler(RhpApplication app) {
            super(app);
        }
    }

    private static abstract class LoadCommand
    extends RecordingCommand {
        protected final RhpApiResourceImpl rhpResource;
        private ModelAccessException exception = null;

        LoadCommand(TransactionalEditingDomain txDomain, RhpApiResourceImpl rhpResource) {
            super(txDomain);
            this.rhpResource = rhpResource;
        }

        ModelAccessException getException() {
            return this.exception;
        }

        protected abstract void doTrinityExecute() throws ModelAccessException;

        protected final void doExecute() {
            try {
                this.doTrinityExecute();
            }
            catch (ModelAccessException e) {
                this.exception = e;
            }
        }
    }

    private static class LoadRhpDMProjectCommand
    extends LoadCommand {
        LoadRhpDMProjectCommand(TransactionalEditingDomain txDomain, RhpApiResourceImpl rhpResource) {
            super(txDomain, rhpResource);
        }

        @Override
        protected final void doTrinityExecute() throws ModelAccessException {
            Object[] items;
            REProjectImpl root = (REProjectImpl)this.rhpResource.createEObject(this.rhpResource.rpprj);
            this.rhpResource.getContents().add((Object)root);
            RhpCollection c = this.rhpResource.rpprj.getNestedElements();
            for (Object o : items = c.getItems()) {
                if (!RhpModelElement.Type.IRPPackage.isRhpModelElement(o)) continue;
                RhpModelElement rme = (RhpModelElement)o;
                rme.invoke("getNestedElementsRecursive", new Object[0]);
            }
            this.rhpResource.touch(root);
        }
    }

    private static class LoadRhpProjectCommand
    extends LoadCommand {
        LoadRhpProjectCommand(TransactionalEditingDomain txDomain, RhpApiResourceImpl rhpResource) {
            super(txDomain, rhpResource);
        }

        @Override
        protected final void doTrinityExecute() throws ModelAccessException {
            REObjectImpl root = this.rhpResource.createEObject(this.rhpResource.rpprj);
            this.rhpResource.getContents().add((Object)root);
            this.rhpResource.touch((REProjectImpl)root);
        }
    }

    private class EditCommand
    extends RhpModelAccessAdapter.RhpRecordingCommand {
        private final String[] guids;

        protected final void doExecute() {
            for (String guid : this.guids) {
                RhpApiResourceImpl.this.processModelElementChange(guid);
            }
        }

        public EditCommand(String[] guids) {
            super(RhpApiResourceImpl.this.adapter);
            this.guids = guids;
        }
    }
}

