/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.trinity.rhapsody.ecore.impl;

import com.ibm.trinity.rhapsody.ecore.RhpApiResource;
import com.ibm.trinity.rhapsody.ecore.impl.DMParams;
import com.ibm.trinity.rhapsody.ecore.impl.RhpApiResourceImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;

public class RhpApiResourceFactoryImpl
extends ResourceFactoryImpl {
    public static final String SYSTEM_PROPERTY_PROXY_MODE = "com.ibm.trinity.rhapsody.ecore.ProxyMode";

    private Resource setProxyMode(RhpApiResource res) {
        String proxyMode = System.getProperty(SYSTEM_PROPERTY_PROXY_MODE);
        if (proxyMode == null || Boolean.TRUE.toString().equalsIgnoreCase(proxyMode)) {
            res.setProxyMode(true);
        } else {
            res.setProxyMode(false);
        }
        return res;
    }

    public static boolean isRhapsodyFileURI(URI uri) {
        String ext = uri.fileExtension();
        return "rpy".equalsIgnoreCase(ext) || "rpyx".equalsIgnoreCase(ext);
    }

    private Resource createRhapsodyDMResource(URI uri) {
        DMParams.Options dmParams = new DMParams.Options();
        if ((uri = dmParams.processDMURI(uri)) == null) {
            return null;
        }
        RhpApiResourceImpl result = new RhpApiResourceImpl(uri, dmParams);
        return this.setProxyMode(result);
    }

    private Resource createRhapsodyFileResource(URI uri) {
        if (!RhpApiResourceFactoryImpl.isRhapsodyFileURI(uri)) {
            return null;
        }
        RhpApiResourceImpl result = new RhpApiResourceImpl(uri);
        return this.setProxyMode(result);
    }

    public Resource createResource(URI uri) {
        Resource res = this.createRhapsodyDMResource(uri);
        if (res != null) {
            return res;
        }
        res = this.createRhapsodyFileResource(uri);
        if (res != null) {
            return res;
        }
        return new ResourceImpl(uri);
    }
}

