/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.trinity.rhapsody.ecore.impl;

import com.ibm.accessibility.com.win32.DispatchException;
import com.ibm.trinity.rhapsody.ecore.REObjectException;
import com.ibm.trinity.rhapsody.ecore.REOperationException;
import com.ibm.trinity.rhapsody.ecore.impl.RhpApiResourceImpl;
import com.ibm.trinity.rhapsody.ecore.impl.RhpStatechartUtil;
import com.ibm.trinity.rhapsody.ecore.robj.RhpClassifier;
import com.ibm.trinity.rhapsody.ecore.robj.RhpCollection;
import com.ibm.trinity.rhapsody.ecore.robj.RhpModelElement;
import com.ibm.trinity.rhapsody.ecore.robj.RhpRelation;
import com.ibm.trinity.rhapsody.rhp.api.ApiPackage;
import com.ibm.trinity.rhapsody.rhp.api.REModelElement;
import com.ibm.trinity.rhapsody.rhp.api.RETransition;
import com.ibm.trinity.rhapsody.rhp.api.impl.REClassifierImpl;
import com.ibm.trinity.rhapsody.rhp.api.impl.REInstanceImpl;
import com.ibm.trinity.rhapsody.rhp.api.impl.REModelElementImpl;
import com.ibm.trinity.rhapsody.rhp.api.impl.RERelationImpl;
import com.ibm.trinity.rhapsody.rhp.api.impl.RETransitionImpl;
import com.ibm.trinity.spi.ModelAccessException;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class REObjectImpl
extends EObjectImpl {
    static final Logger LOGGER = Logger.getLogger((String)REObjectImpl.class.getName());
    protected RhpModelElement rhpModelElement;
    protected boolean isNowLoading;
    private Map<EStructuralFeature, Object> inits;

    public void setInits(Map<EStructuralFeature, Object> inits) {
        this.inits = inits;
    }

    public Map<EStructuralFeature, Object> getInits() {
        return this.inits;
    }

    protected REObjectImpl() {
    }

    protected void setRhpModelElement(RhpModelElement mel) {
        this.rhpModelElement = mel;
    }

    public RhpModelElement getRhpModelElement() {
        return this.rhpModelElement;
    }

    public boolean isValid() {
        if (this.rhpModelElement != null && this.rhpModelElement.isValid()) {
            return true;
        }
        LOGGER.warn((Object)("Invalid REObject detected: " + this));
        return false;
    }

    protected static String formatFeature(EStructuralFeature f) {
        if (f == null) {
            return "(null)";
        }
        return f.getEContainingClass().getName() + "..." + f.getName();
    }

    protected String formatFeature(int featureID) {
        return REObjectImpl.formatFeature(this.eClass().getEStructuralFeature(featureID));
    }

    private static void logError(EStructuralFeature eFeature, String title, String msg) {
        StringBuffer sb = new StringBuffer(title);
        sb.append("feature=").append(REObjectImpl.formatFeature(eFeature));
        sb.append(" (").append(msg).append(")");
        LOGGER.error((Object)sb.toString());
    }

    public Object eGetWithLoad(EStructuralFeature eFeature) throws REObjectException {
        if (this.rhpModelElement == null) {
            return this.eGet(eFeature);
        }
        int featureID = eFeature.getFeatureID();
        if (featureID == 110) {
            return 0;
        }
        if (!this.eIsSet(featureID) || eFeature.isVolatile() || eFeature.isMany() && !eFeature.equals(ApiPackage.eINSTANCE.getREModelElement_NestedElements())) {
            try {
                this.loadFeatureWithoutEMFNotification(eFeature);
            }
            catch (ModelAccessException exc) {
                REObjectImpl.logError(eFeature, "Failed to fetch feature value: ", this.rhpModelElement.getErrorMessage());
            }
        }
        return this.eGet(eFeature);
    }

    private void checkName(Object val) throws REOperationException {
        if (val == null || !(val instanceof String)) {
            throw new REOperationException("Invalid name: " + val);
        }
    }

    private void checkLabel(Object val) throws REOperationException {
        if (val == null || !(val instanceof String)) {
            throw new REOperationException("Invalid label: " + val);
        }
    }

    private void checkString(Object val) throws REOperationException {
        if (val == null || !(val instanceof String)) {
            throw new REOperationException("Invalid value - String expected: " + val);
        }
    }

    private void changeTo(Object val) throws ModelAccessException {
        if (!(val instanceof String)) {
            throw new REObjectException("Invalid value: " + val);
        }
        String strval = val.toString();
        String strmeta = this.rhpModelElement.getUserDefinedMetaClass();
        if (!(strmeta.equals(strval) || strmeta.equals("PrimitiveOperation") && strval.equals("Operation"))) {
            this.rhpModelElement = this.rhpModelElement.changeTo(strval);
        }
        this.loadFeature((EStructuralFeature)ApiPackage.eINSTANCE.getREModelElement_UserDefinedMetaClass());
        this.loadFeature((EStructuralFeature)ApiPackage.eINSTANCE.getREModelElement_Stereotype());
        this.loadFeature((EStructuralFeature)ApiPackage.eINSTANCE.getREModelElement_Stereotypes());
    }

    private void eSetRhpOwner(Object val, Object rhpval) throws ModelAccessException {
        if (val == null) {
            RhpApiResourceImpl rsc = (RhpApiResourceImpl)this.eResource();
            rsc.deleteEObject(this);
        } else {
            if (!(rhpval instanceof RhpModelElement)) {
                throw new REOperationException("setOwner cannot be applied to non-RhpModelElement object: " + rhpval);
            }
            this.rhpModelElement.setOwner((RhpModelElement)rhpval);
            this.eSetIfChanged((EStructuralFeature)ApiPackage.eINSTANCE.getREModelElement_Owner(), val);
            if (this instanceof RERelationImpl) {
                this.loadFeature((EStructuralFeature)ApiPackage.eINSTANCE.getRERelation_OfClass());
            }
        }
    }

    private void eSetRhpName(Object val, Object rhpval) throws ModelAccessException {
        this.checkName(rhpval);
        this.rhpModelElement.setName((String)rhpval);
        this.eSetIfChanged((EStructuralFeature)ApiPackage.eINSTANCE.getREModelElement_Name(), val);
        this.loadFeature((EStructuralFeature)ApiPackage.eINSTANCE.getREModelElement_DisplayName());
        if (this instanceof RERelationImpl) {
            this.loadFeature((EStructuralFeature)ApiPackage.eINSTANCE.getRERelation_RelationRoleName());
            this.loadFeature((EStructuralFeature)ApiPackage.eINSTANCE.getRERelation_RelationLabel());
            if (this instanceof REInstanceImpl) {
                REInstanceImpl inst = (REInstanceImpl)this;
                this.loadFeature((EStructuralFeature)ApiPackage.eINSTANCE.getRERelation_OtherClass());
                REClassifierImpl cls = (REClassifierImpl)inst.getOtherClass();
                if (cls != null) {
                    cls.loadFeature((EStructuralFeature)ApiPackage.eINSTANCE.getREModelElement_Name());
                    cls.loadFeature((EStructuralFeature)ApiPackage.eINSTANCE.getREModelElement_DisplayName());
                }
            }
        }
    }

    private void eSetRhpDisplayName(Object val, Object rhpval) throws ModelAccessException {
        this.checkLabel(rhpval);
        this.rhpModelElement.put("displayName", rhpval);
        this.eSetIfChanged((EStructuralFeature)ApiPackage.eINSTANCE.getREModelElement_DisplayName(), val);
        if (this instanceof RERelationImpl) {
            this.loadFeature((EStructuralFeature)ApiPackage.eINSTANCE.getRERelation_RelationLabel());
        }
    }

    private void eSetRhpStereotype(Object val, Object rhpval) throws ModelAccessException {
        if (rhpval == null) {
            RhpModelElement rme = this.rhpModelElement.getStereotype();
            if (rme != null) {
                this.rhpModelElement.removeStereotype(rme);
            }
        } else if (RhpModelElement.Type.IRPStereotype.isRhpModelElement(rhpval)) {
            if (!(rhpval instanceof RhpModelElement)) {
                throw new REOperationException("setStereotype cannot be applied to non-RhpModelElement object: " + rhpval);
            }
            this.rhpModelElement.setStereotype((RhpModelElement)rhpval);
        } else {
            throw new REOperationException("Not a stereotype: " + rhpval);
        }
        this.eSetIfChanged((EStructuralFeature)ApiPackage.eINSTANCE.getREModelElement_Stereotype(), val);
        this.loadFeature((EStructuralFeature)ApiPackage.eINSTANCE.getREModelElement_UserDefinedMetaClass());
    }

    protected void eSetInvRelationOfClass(Object val) throws ModelAccessException {
        if (!(val instanceof REModelElementImpl)) {
            return;
        }
        REModelElementImpl oc = (REModelElementImpl)val;
        this.eSetIfChanged((EStructuralFeature)ApiPackage.eINSTANCE.getREModelElement_Owner(), oc);
    }

    private void eSetRhpOtherClass(Object val, Object rhpval) throws ModelAccessException {
        if (val == null) {
            RhpApiResourceImpl rsc = (RhpApiResourceImpl)this.eResource();
            if (rsc != null) {
                rsc.deleteEObject(this);
            }
        } else if (this instanceof RERelationImpl) {
            RhpApiResourceImpl rsc;
            RhpRelation rhpRel;
            RERelationImpl rel = (RERelationImpl)this;
            if (this.rhpModelElement == null) {
                if (!(val instanceof REClassifierImpl)) {
                    return;
                }
                REModelElement owner = rel.getOwner();
                if (!(owner instanceof REClassifierImpl)) {
                    throw new REObjectException("Non-classifier model element cannot have association or composition");
                }
                REClassifierImpl owrc = (REClassifierImpl)owner;
                RhpClassifier rc = new RhpClassifier(owrc.rhpModelElement);
                rhpRel = rc.addRelationTo(rel, rhpval);
                if (rhpRel == null) {
                    return;
                }
                this.rhpModelElement = rhpRel;
                RhpApiResourceImpl rsc2 = (RhpApiResourceImpl)rel.eResource();
                rsc2.attached(rel);
            } else {
                rhpRel = new RhpRelation(this.rhpModelElement);
                rhpRel.setOtherClass(rhpval);
                this.eSetIfChanged((EStructuralFeature)ApiPackage.eINSTANCE.getRERelation_OtherClass(), val);
                this.loadFeature((EStructuralFeature)ApiPackage.eINSTANCE.getREModelElement_Name());
                this.loadFeature((EStructuralFeature)ApiPackage.eINSTANCE.getREModelElement_DisplayName());
                this.loadFeature((EStructuralFeature)ApiPackage.eINSTANCE.getRERelation_RelationRoleName());
                this.loadFeature((EStructuralFeature)ApiPackage.eINSTANCE.getRERelation_RelationLabel());
                this.loadFeature((EStructuralFeature)ApiPackage.eINSTANCE.getREModelElement_NestedElements());
                RERelationImpl inverse = (RERelationImpl)rel.getInverse();
                if (inverse != null) {
                    rsc = (RhpApiResourceImpl)inverse.eResource();
                    rsc.deleteTree(inverse);
                }
                if (!(val instanceof REClassifierImpl)) {
                    return;
                }
            }
            REClassifierImpl valrc = (REClassifierImpl)val;
            rsc = (RhpApiResourceImpl)valrc.eResource();
            rsc.createInverseRelation(valrc, rel, rhpRel);
        } else {
            this.rhpModelElement.put("otherClass", rhpval);
            this.eSetIfChanged((EStructuralFeature)ApiPackage.eINSTANCE.getRERelation_OtherClass(), val);
            ((RhpApiResourceImpl)this.eResource()).touch((REModelElementImpl)this);
        }
    }

    private void eSetRhpSysMLPortDirection(Object val, Object rhpval) throws ModelAccessException {
        if (!("In".equals(val) || "Out".equals(val) || "InOut".equals(val) || "Unspecified".equals(val))) {
            throw new REObjectException("Invalid value: " + val);
        }
        this.rhpModelElement.put("portDirection", rhpval);
        this.eSetIfChanged((EStructuralFeature)ApiPackage.eINSTANCE.getRESysMLPort_PortDirection(), val);
    }

    private void eSetIfChanged(EStructuralFeature ef, Object val) throws ModelAccessException {
        Object oval = this.eGet(ef);
        if (oval == null || !oval.equals(val)) {
            this.eSet(ef, val);
        }
    }

    private static boolean equal(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    private static boolean isIgnore(EStructuralFeature feature) {
        String ignore = EcoreUtil.getAnnotation((EModelElement)feature, (String)"http://w3.ibm.com/Rhapsody/", (String)"ignore");
        return "true".equals(ignore);
    }

    public void eSetToRhp(EStructuralFeature ef, Object val) throws ModelAccessException {
        if (this.rhpModelElement == null) {
            this.eSet(ef, val);
        }
        if (ef.isMany()) {
            throw new REOperationException("Not a simple feature: " + ef.getName());
        }
        if (REObjectImpl.isIgnore(ef)) {
            return;
        }
        Object rhpval = this.getUnwrappedValue(val, ef);
        if (ef.equals(ApiPackage.eINSTANCE.getREModelElement_UserDefinedMetaClass())) {
            if (rhpval == null) {
                throw new REOperationException("Not a stereotype: " + rhpval);
            }
            this.changeTo(rhpval);
            return;
        }
        if (this instanceof RETransition) {
            if (ef.equals(ApiPackage.eINSTANCE.getRETransition_ItsSource())) {
                throw new REOperationException("ItsSource of RETransition cannot be changed.");
            }
            if (ef.equals(ApiPackage.eINSTANCE.getREModelElement_Owner())) {
                throw new REOperationException("Owner of RETransition cannot be changed.");
            }
            if (ef.equals(ApiPackage.eINSTANCE.getREModelElement_Name())) {
                throw new REOperationException("Name of RETransition cannot be changed.");
            }
            if (ef.equals(ApiPackage.eINSTANCE.getRETransition_ItsTarget())) {
                if (RhpStatechartUtil.setRhpTransitionTarget((RETransitionImpl)this, rhpval)) {
                    this.eSetIfChanged(ef, val);
                }
                return;
            }
        }
        String name = ef.getName();
        try {
            Object oldval;
            if (this.rhpModelElement != null && REObjectImpl.equal(oldval = this.rhpModelElement.get(name), rhpval)) {
                this.eSetIfChanged(ef, val);
                return;
            }
            if (ef.equals(ApiPackage.eINSTANCE.getREUnit_Filename())) {
                throw new REOperationException("Unsuppoted feature");
            }
            if (ef.equals(ApiPackage.eINSTANCE.getREModelElement_Owner()) || ef.equals(ApiPackage.eINSTANCE.getREDependency_Dependent())) {
                this.eSetRhpOwner(val, rhpval);
            } else if (ef.equals(ApiPackage.eINSTANCE.getREModelElement_Name())) {
                this.eSetRhpName(val, rhpval);
            } else if (ef.equals(ApiPackage.eINSTANCE.getREModelElement_DisplayName())) {
                this.eSetRhpDisplayName(val, rhpval);
            } else if (ef.equals(ApiPackage.eINSTANCE.getREModelElement_Stereotype())) {
                this.eSetRhpStereotype(val, rhpval);
            } else if (ef.equals(ApiPackage.eINSTANCE.getREFlow_End1()) || ef.equals(ApiPackage.eINSTANCE.getREFlow_End2())) {
                if (val == null) {
                    rsc = (RhpApiResourceImpl)this.eResource();
                    rsc.deleteEObject(this);
                } else {
                    this.rhpModelElement.put(name, rhpval);
                }
                this.eSetIfChanged(ef, val);
            } else if (ef.equals(ApiPackage.eINSTANCE.getREModelElement_Description()) || ef.equals(ApiPackage.eINSTANCE.getRERelation_Multiplicity())) {
                this.checkString(rhpval);
                this.rhpModelElement.put(name, rhpval);
                this.eSetIfChanged(ef, val);
            } else if (ef.equals(ApiPackage.eINSTANCE.getREVariable_Type())) {
                if (val == null) {
                    throw new REOperationException("Invalid new value: " + val);
                }
                this.rhpModelElement.put(name, rhpval);
                this.eSetIfChanged(ef, val);
            } else if (ef.equals(ApiPackage.eINSTANCE.getRERelation_OtherClass())) {
                this.eSetRhpOtherClass(val, rhpval);
            } else if (ef.equals(ApiPackage.eINSTANCE.getRESysMLPort_Type())) {
                if (rhpval != null) {
                    this.rhpModelElement.put(name, rhpval);
                }
                this.eSetIfChanged(ef, val);
                this.loadFeature((EStructuralFeature)ApiPackage.eINSTANCE.getREModelElement_NestedElements());
            } else if (ef.equals(ApiPackage.eINSTANCE.getRETag_Value())) {
                this.rhpModelElement.put(name, rhpval);
                this.eSetIfChanged(ef, val);
                this.loadFeature((EStructuralFeature)ApiPackage.eINSTANCE.getREModelElement_NestedElements());
            } else if (ef.equals(ApiPackage.eINSTANCE.getREDependency_DependsOn())) {
                if (val == null) {
                    rsc = (RhpApiResourceImpl)this.eResource();
                    rsc.deleteEObject(this);
                } else {
                    this.rhpModelElement.put(name, rhpval);
                    this.eSetIfChanged(ef, val);
                    this.loadFeature((EStructuralFeature)ApiPackage.eINSTANCE.getREModelElement_Name());
                    this.loadFeature((EStructuralFeature)ApiPackage.eINSTANCE.getREModelElement_DisplayName());
                }
            } else if (ef.equals(ApiPackage.eINSTANCE.getRESysMLPort_PortDirection())) {
                this.eSetRhpSysMLPortDirection(val, rhpval);
            } else {
                this.rhpModelElement.put(name, rhpval);
                this.eSetIfChanged(ef, val);
            }
        }
        catch (DispatchException e) {
            REObjectImpl.logError(ef, "Failed to update feature value: ", this.rhpModelElement.getErrorMessage());
            throw new REObjectException("Failed to update a simple feature: " + ef, e);
        }
    }

    private void logFeatures(String title) {
        if (LOGGER.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer(title);
            sb.append("path=").append(this.rhpModelElement.getFullPathName());
            sb.append(", guid=").append(this.rhpModelElement.getGUID());
            sb.append(", eClass=").append(this.eClass().getName());
            LOGGER.debug((Object)sb.toString());
        }
    }

    protected void initsRhpAndLoadNestedElemenets(Map<EStructuralFeature, Object> inits) throws ModelAccessException {
        this.logFeatures("initsRhpAndLoadNestedElements: ");
        for (EStructuralFeature feature : this.eClass().getEAllStructuralFeatures()) {
            Object val;
            if (feature.equals(ApiPackage.eINSTANCE.getREModelElement_Owner()) || feature.equals(ApiPackage.eINSTANCE.getREModelElement_NestedElements()) || inits == null || feature.equals(ApiPackage.eINSTANCE.getREModelElement_Name()) || feature.equals(ApiPackage.eINSTANCE.getREModelElement_UserDefinedMetaClass()) || (val = inits.get(feature)) == null) continue;
            this.eSetToRhp(feature, val);
        }
        this.loadFeature((EStructuralFeature)ApiPackage.eINSTANCE.getREModelElement_NestedElements());
    }

    public void loadAllFeaturesForEMFCompareTest() throws REObjectException {
        for (EStructuralFeature feature : this.eClass().getEAllStructuralFeatures()) {
            if (this.eGet(feature) != null || feature.equals(ApiPackage.eINSTANCE.getREModelElement_Owner()) || feature.equals(ApiPackage.eINSTANCE.getREProject_IsModifiedRecursive()) || feature.isMany()) continue;
            this.loadFeature(feature);
        }
    }

    protected void loadAllFeatures() throws REObjectException {
        this.logFeatures("loadAllFeatures: ");
        for (EStructuralFeature feature : this.eClass().getEAllStructuralFeatures()) {
            if (feature.equals(ApiPackage.eINSTANCE.getREModelElement_Owner())) continue;
            this.loadFeature(feature);
        }
    }

    protected void reloadChangedElementFeatures(boolean includeNestedElements) throws REObjectException {
        this.logFeatures("reloadChangedElementFeatures: ");
        for (EStructuralFeature feature : this.eClass().getEAllStructuralFeatures()) {
            if (!includeNestedElements && REObjectImpl.isNestedElementsFeature(feature) || feature.equals(ApiPackage.eINSTANCE.getREModelElement_Owner()) || feature.equals(ApiPackage.eINSTANCE.getREModelElement_Project()) || !this.eIsSet(feature)) continue;
            this.loadFeature(feature);
        }
    }

    protected void loadFeatureWithoutEMFNotification(EStructuralFeature feature) throws REObjectException {
        boolean deliver = this.eDeliver();
        try {
            this.eSetDeliver(false);
            this.loadFeatureInternal(feature);
        }
        finally {
            this.eSetDeliver(deliver);
        }
    }

    protected void loadFeature(EStructuralFeature feature) throws REObjectException {
        this.loadFeatureInternal(feature);
    }

    private static boolean isNestedElementsFeature(EStructuralFeature feature) {
        return ApiPackage.eINSTANCE.getREModelElement_NestedElements().equals(feature);
    }

    private int addIndex(EStructuralFeature feature, EList<Object> list, int arrayIndex, Object item) throws REObjectException {
        Object itemValue = this.getWrappedValue(item, feature);
        if (item != null && itemValue == null) {
            StringBuffer sb = new StringBuffer();
            sb.append("Conversion failed:");
            sb.append(" feature=").append(feature.getName());
            sb.append(",value=").append(item);
            LOGGER.warn((Object)sb.toString());
            return arrayIndex;
        }
        int oldIndex = list.indexOf(itemValue);
        if (oldIndex >= 0) {
            if (oldIndex >= arrayIndex) {
                if (oldIndex == arrayIndex) {
                    ++arrayIndex;
                } else {
                    list.move(arrayIndex, oldIndex);
                    ++arrayIndex;
                }
            }
            return arrayIndex;
        }
        list.add(arrayIndex, itemValue);
        return ++arrayIndex;
    }

    private int syncCopyRhpCollectionToEList(RhpCollection collection, EStructuralFeature feature, EList<Object> list, int arrayIndex) throws REObjectException {
        if (collection != null) {
            Object[] objs;
            for (Object item : objs = collection.getItems()) {
                arrayIndex = this.addIndex(feature, list, arrayIndex, item);
            }
        }
        return arrayIndex;
    }

    private void removeTheRest(EList<Object> list, int arrayIndex) {
        for (int k = list.size() - 1; k >= arrayIndex; --k) {
            list.remove(k);
        }
    }

    private void loadStateVertex(RhpModelElement state, EStructuralFeature feature, EList<Object> list) throws REObjectException {
        RhpCollection collection;
        int arrayIndex = 0;
        if (RhpModelElement.Type.IRPState.isRhpModelElement(state)) {
            collection = state.getCol("subStateVertices");
            arrayIndex = this.syncCopyRhpCollectionToEList(collection, feature, list, arrayIndex);
        }
        collection = state.invokeCol("getOutTransitions", new Object[0]);
        arrayIndex = this.syncCopyRhpCollectionToEList(collection, feature, list, arrayIndex);
        this.removeTheRest(list, arrayIndex);
    }

    private void loadStatechart(RhpModelElement sc, EStructuralFeature feature, EList<Object> list) throws REObjectException {
        int arrayIndex = 0;
        RhpModelElement root = (RhpModelElement)sc.get("rootState");
        if (root != null) {
            arrayIndex = this.addIndex(feature, list, arrayIndex, root);
        }
        this.removeTheRest(list, arrayIndex);
    }

    private RhpCollection addTopLevel(RhpCollection collection) {
        Object[] slots;
        RhpModelElement tlc = this.rhpModelElement.invokeRhp("findNestedElement", "TopLevel", "Class");
        if (tlc == null) {
            return collection;
        }
        for (Object o : slots = collection.getItems()) {
            String csName;
            if (!RhpModelElement.Type.IRPClass.isRhpModelElement(o) || !"TopLevel".equals(csName = ((RhpModelElement)o).getName())) continue;
            return collection;
        }
        return collection.addItem(tlc);
    }

    protected void loadFeatureInternal(EStructuralFeature feature) throws REObjectException {
        if (this.rhpModelElement == null) {
            return;
        }
        if (!this.isValid()) {
            throw new REObjectException("Invalid object: " + this.toString() + " when accessing to " + REObjectImpl.formatFeature(feature));
        }
        if (REObjectImpl.isIgnore(feature)) {
            return;
        }
        this.logFeatures("loadFeatureInternal: ");
        boolean changable = feature.isChangeable();
        try {
            feature.setChangeable(true);
            this.isNowLoading = true;
            Object rhpValue = this.readRhpValue(feature);
            if (!feature.isMany()) {
                Object eValue = this.getWrappedValue(rhpValue, feature);
                this.eSetIfChanged(feature, eValue);
                return;
            }
            RhpCollection collection = (RhpCollection)rhpValue;
            EList list = (EList)super.eGet(feature.getFeatureID(), false, true);
            if (REObjectImpl.isNestedElementsFeature(feature)) {
                if (RhpModelElement.Type.IRPPackage.isRhpModelElement(this.rhpModelElement)) {
                    collection = this.addTopLevel(collection);
                } else {
                    if (RhpModelElement.Type.IRPStateVertex.isRhpModelElement(this.rhpModelElement)) {
                        this.loadStateVertex(this.rhpModelElement, feature, (EList<Object>)list);
                        return;
                    }
                    if (RhpModelElement.Type.IRPStatechart.isRhpModelElement(this.rhpModelElement)) {
                        this.loadStatechart(this.rhpModelElement, feature, (EList<Object>)list);
                        return;
                    }
                }
            }
            int arrayIndex = this.syncCopyRhpCollectionToEList(collection, feature, (EList<Object>)list, 0);
            this.removeTheRest((EList<Object>)list, arrayIndex);
        }
        catch (Exception e) {
            Throwable t = e;
            while (t.getCause() != null) {
                t = t.getCause();
            }
            StringBuffer sb = new StringBuffer();
            sb.append("Failed to read field: ");
            sb.append("path=").append(this.rhpModelElement.getFullPathName());
            sb.append(", feature=").append(REObjectImpl.formatFeature(feature));
            sb.append(", root cause=").append(t.getMessage());
            LOGGER.error((Object)sb.toString());
            throw new REObjectException("Error in reading Rhapsody model", e);
        }
        finally {
            feature.setChangeable(changable);
            this.isNowLoading = false;
        }
    }

    private Object readRhpValue(EStructuralFeature eFeature) throws REObjectException {
        try {
            Object result = REObjectImpl.isNestedElementsFeature(eFeature) ? this.rhpModelElement.getNestedElements() : this.rhpModelElement.get(eFeature.getName());
            if (LOGGER.isDebugEnabled()) {
                StringBuffer sb = new StringBuffer();
                sb.append("getFeatureValue: guid=").append(this.rhpModelElement.getGUID());
                sb.append(", eContainingClass=").append(eFeature.getEContainingClass().getName());
                sb.append(", eFeature=").append(eFeature.getName());
                sb.append(", value=").append(result);
                LOGGER.debug((Object)sb.toString());
            }
            return result;
        }
        catch (Exception e) {
            throw new REObjectException("Failed to get value for: " + REObjectImpl.formatFeature(eFeature), e);
        }
    }

    public Object getUnwrappedValue(Object value, EStructuralFeature targetFeature) {
        if (targetFeature instanceof EAttribute) {
            return value;
        }
        if (value instanceof REObjectImpl) {
            return ((REObjectImpl)((Object)value)).getRhpModelElement();
        }
        return value;
    }

    public Object getWrappedValue(Object value, EStructuralFeature eFeature) throws REObjectException {
        if (eFeature instanceof EAttribute) {
            return this.getAttributeValue(value, (EAttribute)eFeature);
        }
        if (eFeature instanceof EReference) {
            return this.getReferenceTarget(value, (EReference)eFeature);
        }
        throw new REObjectException("Unexpected feature: " + eFeature);
    }

    protected Object getReferenceTarget(Object value, EReference ref) {
        if (!(value instanceof RhpModelElement)) {
            return null;
        }
        Resource rsc = this.eResource();
        REObjectImpl reo = this;
        while (rsc == null) {
            if ((reo = (REObjectImpl)reo.eContainer()) == null) {
                LOGGER.warn((Object)"Resource not found");
                return null;
            }
            rsc = reo.eResource();
        }
        RhpModelElement rme = (RhpModelElement)value;
        RhpApiResourceImpl rari = (RhpApiResourceImpl)rsc;
        return rari.getEObjectFromRhpModelElement(rme);
    }

    protected Object getAttributeValue(Object value, EAttribute attr) {
        if (value == null) {
            return attr.getDefaultValue();
        }
        if (attr.getEType().isInstance(value)) {
            return value;
        }
        if (attr.getEType().equals(EcorePackage.eINSTANCE.getEBoolean())) {
            return (Integer)value != 0;
        }
        return EcoreUtil.createFromString((EDataType)attr.getEAttributeType(), (String)value.toString());
    }

    public String addNewAggrCls() {
        String strType = this.eClass().getName().substring(2);
        if (strType.equals("Instance")) {
            return "Object";
        }
        return strType;
    }

    public boolean eqRhp(REObjectImpl reo) {
        if (this.eIsProxy() || reo.eIsProxy()) {
            RhpModelElement rme1 = this.rhpModelElement;
            RhpModelElement rme2 = reo.rhpModelElement;
            if (rme1 == null) {
                return rme2 == null;
            }
            return rme1.equals(rme2);
        }
        return ((Object)((Object)this)).equals((Object)reo);
    }

    public String toString() {
        String baseName = ((Object)((Object)this)).getClass().getSimpleName();
        StringBuilder sb = new StringBuilder(baseName);
        if (this.eIsProxy()) {
            sb.append('#');
        } else {
            sb.append('@');
        }
        sb.append(Integer.toHexString(((Object)((Object)this)).hashCode()));
        RhpModelElement rhpElem = this.getRhpModelElement();
        if (rhpElem != null) {
            sb.append(" (");
            try {
                sb.append(rhpElem.getFullPathName());
            }
            catch (DispatchException dispatchException) {
                // empty catch block
            }
            sb.append(')');
        }
        return sb.toString();
    }
}

