/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.trinity.rhapsody.ecore.impl;

import java.util.EnumMap;
import org.eclipse.emf.common.util.URI;

public enum DMParams {
    username,
    password,
    projectAreaName,
    streamName,
    modelName;


    public static class Options
    extends EnumMap<DMParams, String> {
        private static final long serialVersionUID = 3672778818063957251L;

        private String parse(String query) {
            String[] params = query.split("\\&");
            StringBuilder rest = new StringBuilder();
            for (String param : params) {
                String[] keyValue = param.split("=");
                if (keyValue.length != 2) {
                    throw new IllegalArgumentException("Invalid URI Query:" + param);
                }
                try {
                    DMParams p = DMParams.valueOf(keyValue[0]);
                    this.put(p, URI.decode((String)keyValue[1]));
                }
                catch (IllegalArgumentException e) {
                    if (rest.length() > 0) {
                        rest.append('&');
                    }
                    rest.append(param);
                }
            }
            return rest.toString().trim();
        }

        public boolean isValid() {
            for (DMParams dp : DMParams.values()) {
                if (this.get((Object)dp) != null) continue;
                return false;
            }
            return true;
        }

        public URI processDMURI(URI uri) {
            String query = uri.query();
            if (query == null) {
                return null;
            }
            String rest = this.parse(query);
            if (!this.isValid()) {
                return null;
            }
            uri = uri.trimQuery();
            if (rest.length() > 0) {
                uri = uri.appendQuery(rest);
            }
            return uri;
        }

        public Options() {
            super(DMParams.class);
        }
    }
}

