/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.trinity.rhapsody.ecore.adapter;

import com.ibm.accessibility.com.win32.DispatchException;
import com.ibm.trinity.rhapsody.ecore.REObjectException;
import com.ibm.trinity.rhapsody.ecore.REOperationException;
import com.ibm.trinity.rhapsody.ecore.impl.REObjectImpl;
import com.ibm.trinity.rhapsody.ecore.impl.RhpApiResourceFactoryImpl;
import com.ibm.trinity.rhapsody.ecore.impl.RhpApiResourceImpl;
import com.ibm.trinity.rhapsody.ecore.robj.RhpModelElement;
import com.ibm.trinity.rhapsody.rhp.api.ApiPackage;
import com.ibm.trinity.rhapsody.rhp.api.impl.REModelElementImpl;
import com.ibm.trinity.spi.DataSourceModelAccessException;
import com.ibm.trinity.spi.ModelAccessAdapter;
import com.ibm.trinity.spi.ModelAccessException;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalCommandStack;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.openmbee.mpspi.exceptions.MPDataLoadException;
import org.openmbee.mpspi.exceptions.MPException;

public class RhpModelAccessAdapter
extends ModelAccessAdapter {
    private static final Logger LOGGER = Logger.getLogger((String)RhpModelAccessAdapter.class.getName());
    private ResourceSet rset = null;
    private RhpApiResourceImpl rhpRsc = null;
    private static final ResourceFactoryRegistryImpl resourceFactoryRegistryImpl = new ResourceFactoryRegistryImpl();
    private TransactionalEditingDomain txDomain;
    private boolean isTxActive;
    private static final Set<EStructuralFeature> sInitFeatures = new HashSet<EStructuralFeature>();

    public static ResourceSetImpl createResourceSetImpl() {
        ResourceSetImpl rset = new ResourceSetImpl();
        rset.setResourceFactoryRegistry((Resource.Factory.Registry)resourceFactoryRegistryImpl);
        return rset;
    }

    private ModelAccessException convertToModelAccessException(WrappedException we) {
        Throwable t;
        Exception e = we.exception();
        if (e instanceof ModelAccessException) {
            return (ModelAccessException)e;
        }
        if (e instanceof IOException && (t = e.getCause()) instanceof ModelAccessException) {
            return (ModelAccessException)t;
        }
        return new DataSourceModelAccessException(e.getMessage(), (Throwable)e);
    }

    private void throwMPException(WrappedException we) throws MPException, ModelAccessException {
        Exception e = we.exception();
        if (e instanceof ModelAccessException) {
            throw (ModelAccessException)e;
        }
        if (e instanceof MPException) {
            throw (MPException)e;
        }
        if (e instanceof IOException) {
            Throwable t = e.getCause();
            if (t instanceof ModelAccessException) {
                throw (ModelAccessException)t;
            }
            if (t instanceof MPException) {
                throw (MPException)t;
            }
        }
        throw new MPDataLoadException(e.getMessage(), (Throwable)e);
    }

    public void mpLoad(URI uri) throws MPException, ModelAccessException {
        try {
            this.rset = RhpModelAccessAdapter.createResourceSetImpl();
            Resource rsc = this.rset.getResource(uri, true);
            if (rsc == null) {
                throw new DataSourceModelAccessException("Model not found: " + uri);
            }
            if (!(rsc instanceof RhpApiResourceImpl)) {
                throw new DataSourceModelAccessException("Unexpected resource class: " + rsc.getClass().getSimpleName() + "/" + uri);
            }
            this.rhpRsc = (RhpApiResourceImpl)rsc;
            this.rhpRsc.setRhpModelAccessAdapter(this);
        }
        catch (WrappedException we) {
            this.throwMPException(we);
        }
    }

    public Resource load(URI uri) throws ModelAccessException {
        try {
            this.rset = RhpModelAccessAdapter.createResourceSetImpl();
            Resource rsc = this.rset.getResource(uri, true);
            if (rsc == null) {
                throw new DataSourceModelAccessException("Model not found: " + uri);
            }
            if (!(rsc instanceof RhpApiResourceImpl)) {
                throw new DataSourceModelAccessException("Unexpected resource class: " + rsc.getClass().getSimpleName() + "/" + uri);
            }
            this.rhpRsc = (RhpApiResourceImpl)rsc;
            this.rhpRsc.setRhpModelAccessAdapter(this);
            return this.rhpRsc;
        }
        catch (WrappedException we) {
            throw this.convertToModelAccessException(we);
        }
    }

    public ModelAccessAdapter.ReloadResult reload() throws ModelAccessException {
        if (this.rhpRsc == null || this.rset == null) {
            throw new IllegalStateException("Not yet loaded.");
        }
        try {
            this.rhpRsc.unload();
            this.rhpRsc.load(this.rset.getLoadOptions());
            return ModelAccessAdapter.ReloadResult.NEED_REACTIVATE;
        }
        catch (IOException e) {
            throw new DataSourceModelAccessException(e.getMessage());
        }
    }

    public void setTransactionalEditingDomain(TransactionalEditingDomain txDomain) {
        this.txDomain = txDomain;
    }

    public void executeCommand(RhpRecordingCommand command) {
        if (this.isTxActive || this.txDomain == null) {
            command.rhpExecute();
        } else {
            TransactionalCommandStack stack = (TransactionalCommandStack)this.txDomain.getCommandStack();
            try {
                stack.execute((Command)command, Collections.EMPTY_MAP);
            }
            catch (RollbackException e) {
                LOGGER.error((Object)("RollbackException occurred: " + e));
            }
            catch (InterruptedException e) {
                LOGGER.error((Object)("InterruptedException occurred: " + e));
            }
        }
    }

    public Resource getResource() {
        return this.rhpRsc;
    }

    protected RhpApiResourceImpl getRhpApiResource() {
        if (this.rhpRsc == null) {
            throw new IllegalStateException();
        }
        return this.rhpRsc;
    }

    public Map<String, EObject[]> getPrimaryDataSources() {
        RhpApiResourceImpl rsc = this.getRhpApiResource();
        if (rsc.getContents().size() == 0) {
            return null;
        }
        HashMap<String, EObject[]> result = new HashMap<String, EObject[]>();
        EObject root = (EObject)rsc.getContents().get(0);
        EObject[] entry = new EObject[]{root};
        result.put("Root", entry);
        return result;
    }

    public void unload() {
        if (this.rhpRsc == null) {
            return;
        }
        this.rhpRsc.unload();
        this.rhpRsc = null;
    }

    public void save() throws ModelAccessException {
        RhpApiResourceImpl rsc = this.getRhpApiResource();
        try {
            rsc.save(null);
        }
        catch (IOException e) {
            throw new DataSourceModelAccessException("Failed to save model file: " + rsc.getURI().toString(), (Throwable)e);
        }
    }

    public void saveAs(URI uri, boolean saveCopyAs) throws ModelAccessException {
        RhpApiResourceImpl rsc = this.getRhpApiResource();
        URI origURI = rsc.getURI();
        if (!origURI.equals(uri)) {
            rsc.setURI(uri);
        }
        try {
            rsc.save(null);
        }
        catch (IOException e) {
            StringBuilder sb = new StringBuilder("SaveAs failed: ");
            sb.append("saveAs=").append(saveCopyAs);
            sb.append(", uri=").append(rsc.getURI());
            sb.append(", origUri=").append(origURI);
            String msg = sb.toString();
            throw new DataSourceModelAccessException(msg, (Throwable)e);
        }
        finally {
            if (saveCopyAs && !origURI.equals(uri)) {
                rsc.setURI(origURI);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(EObject owner, EStructuralFeature feature, EObject value, int index, Map<EStructuralFeature, Object> inits) throws ModelAccessException {
        if (this.rhpRsc == null) {
            throw new IllegalStateException();
        }
        if (!(owner instanceof REObjectImpl)) {
            throw new IllegalArgumentException();
        }
        this.checkObject(owner);
        try {
            this.isTxActive = true;
            if (inits != null) {
                super.initFeatures(value, inits);
            }
            this.rhpRsc.addChild((REObjectImpl)owner, feature, value, index, inits);
        }
        finally {
            this.isTxActive = false;
        }
    }

    public void dispose(EObject obj) throws ModelAccessException {
        if (this.rhpRsc == null) {
            throw new IllegalStateException();
        }
        if (!(obj instanceof REObjectImpl)) {
            throw new IllegalArgumentException();
        }
        this.checkObject(obj);
        try {
            this.isTxActive = true;
            this.rhpRsc.deleteEObject((REObjectImpl)obj);
        }
        finally {
            this.isTxActive = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(EObject obj, EStructuralFeature feature) throws ModelAccessException {
        if (!(obj instanceof REObjectImpl)) {
            throw new IllegalArgumentException();
        }
        if (feature == null) {
            throw new IllegalArgumentException();
        }
        try {
            this.isTxActive = true;
            Object object = ((REObjectImpl)obj).eGetWithLoad(feature);
            return object;
        }
        finally {
            this.isTxActive = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(EObject obj, EStructuralFeature feature, Object value) throws ModelAccessException {
        if (!(obj instanceof REObjectImpl)) {
            throw new IllegalArgumentException();
        }
        if (feature == null) {
            throw new IllegalArgumentException();
        }
        if (feature.equals(ApiPackage.eINSTANCE.getREModelElement_GUID())) {
            throw new REOperationException("Unsupported feature: " + feature.toString());
        }
        this.checkObject(obj);
        this.checkObject(value);
        try {
            this.isTxActive = true;
            ((REObjectImpl)obj).eSetToRhp(feature, value);
        }
        finally {
            this.isTxActive = false;
        }
    }

    public void add(EObject owner, EStructuralFeature feature, Object value, int index) throws ModelAccessException {
        this.checkNestedElementsFeatureAndValue(feature, value);
        this.checkObject(owner);
        this.checkObject(value);
        if (index >= 0) {
            throw new REOperationException("Feature: " + feature + " does not support index:" + index);
        }
        this.set((EObject)((REObjectImpl)((Object)value)), (EStructuralFeature)ApiPackage.eINSTANCE.getREModelElement_Owner(), owner);
    }

    public void remove(EObject owner, EStructuralFeature feature, Object value) throws ModelAccessException {
        this.checkNestedElementsFeatureAndValue(feature, value);
        this.checkObject(owner);
        this.checkObject(value);
        EList valueList = (EList)this.get(owner, feature);
        if (!valueList.contains(value)) {
            throw new REOperationException("Invalid value: " + value);
        }
        this.set((EObject)((REObjectImpl)((Object)value)), (EStructuralFeature)ApiPackage.eINSTANCE.getREModelElement_Owner(), null);
    }

    private void checkNestedElementsFeatureAndValue(EStructuralFeature feature, Object value) throws REOperationException {
        if (feature == null) {
            throw new IllegalArgumentException();
        }
        if (!feature.isMany()) {
            throw new REOperationException("Feature is simple: " + feature.toString());
        }
        if (!feature.equals(ApiPackage.eINSTANCE.getREModelElement_NestedElements())) {
            throw new REOperationException("Unsupported feature: " + feature.toString());
        }
        if (value == null || !(value instanceof REObjectImpl)) {
            throw new REOperationException("Invalid value: " + value);
        }
    }

    protected void checkObject(Object o) throws REObjectException {
        if (!(o instanceof REModelElementImpl)) {
            return;
        }
        REModelElementImpl ro = (REModelElementImpl)o;
        RhpModelElement mel = ro.getRhpModelElement();
        if (mel == null) {
            LOGGER.warn((Object)("Uninitialized REObject detected: " + o));
            return;
        }
        try {
            mel.getGUID();
        }
        catch (DispatchException exc) {
            LOGGER.error((Object)"Invalid REObject detected");
            throw new REObjectException("Invalid REObject detected", exc);
        }
    }

    static {
        sInitFeatures.add((EStructuralFeature)ApiPackage.eINSTANCE.getREModelElement_Name());
        sInitFeatures.add((EStructuralFeature)ApiPackage.eINSTANCE.getREModelElement_UserDefinedMetaClass());
    }

    private static class ResourceFactoryRegistryImpl
    implements Resource.Factory.Registry {
        private final Map<String, Object> map = new HashMap<String, Object>();

        private ResourceFactoryRegistryImpl() {
        }

        public Map<String, Object> getContentTypeToFactoryMap() {
            return this.map;
        }

        public Map<String, Object> getExtensionToFactoryMap() {
            return this.map;
        }

        public Resource.Factory getFactory(URI uri) {
            return new RhpApiResourceFactoryImpl();
        }

        public Resource.Factory getFactory(URI uri, String contentType) {
            return new RhpApiResourceFactoryImpl();
        }

        public Map<String, Object> getProtocolToFactoryMap() {
            return this.map;
        }
    }

    public static abstract class RhpRecordingCommand
    extends RecordingCommand {
        public void rhpExecute() {
            this.doExecute();
        }

        public RhpRecordingCommand(RhpModelAccessAdapter adapter) {
            super(adapter.txDomain);
        }
    }
}

