/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.trinity.rhapsody.ecore;

import com.ibm.trinity.rhapsody.ecore.Activator;
import com.ibm.trinity.rhapsody.ecore.MPREObjectException;
import com.ibm.trinity.rhapsody.ecore.MPREOperationException;
import com.ibm.trinity.rhapsody.ecore.REObjectException;
import com.ibm.trinity.rhapsody.ecore.REOperationException;
import com.ibm.trinity.rhapsody.ecore.adapter.RhpModelAccessAdapter;
import com.ibm.trinity.rhapsody.ecore.impl.REObjectImpl;
import com.ibm.trinity.rhapsody.ecore.robj.RhpApplication;
import com.ibm.trinity.spi.DataSourceModelAccessException;
import com.ibm.trinity.spi.DisconnectedModelAccessException;
import com.ibm.trinity.spi.InvalidModelAccessException;
import com.ibm.trinity.spi.LockModelAccessException;
import com.ibm.trinity.spi.UnsupportedModelAccessException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.openmbee.mpspi.MPAdapter;
import org.openmbee.mpspi.exceptions.MPAccessException;
import org.openmbee.mpspi.exceptions.MPDataLoadException;
import org.openmbee.mpspi.exceptions.MPDisconnectionException;
import org.openmbee.mpspi.exceptions.MPException;
import org.openmbee.mpspi.exceptions.MPInvalidException;
import org.openmbee.mpspi.exceptions.MPLockException;
import org.openmbee.mpspi.exceptions.MPUnsupportedOperationException;
import org.openmbee.mpspi.svc.MPAbstractAdapter;

public class MPRhpAdapter
extends MPAbstractAdapter {
    private final RhpModelAccessAdapter maa = new RhpModelAccessAdapter();

    public Serializable getInformation(MPAdapter.InformationOption option) throws MPException {
        switch (option) {
            case NAME: {
                return "Rhaspsody MPAdapter";
            }
            case SPECIFICATIONS: {
                try {
                    RhpApplication rapp = Activator.getDefault().getRhpApplication();
                    if (rapp != null && rapp.isRhpV2()) {
                        return MPRhpAdapter.specifications((String[])new String[]{"false,,rpy?,Rhapsody Model File"});
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return MPRhpAdapter.specifications((String[])new String[]{"false,,rpy,Rhapsody Model File"});
            }
        }
        return super.getInformation(option);
    }

    public EPackage.Registry getPackageRegistry() {
        return super.getPackageRegistry();
    }

    private void convertException(Exception mae) throws MPException {
        if (mae instanceof WrappedException) {
            WrappedException we = (WrappedException)((Object)mae);
            mae = we.exception();
        }
        if (mae instanceof REObjectException) {
            throw new MPREObjectException(mae.getMessage(), mae.getCause());
        }
        if (mae instanceof REOperationException) {
            throw new MPREOperationException(mae.getMessage(), mae.getCause());
        }
        if (mae instanceof DataSourceModelAccessException) {
            throw new MPDataLoadException(mae.getMessage(), mae.getCause());
        }
        if (mae instanceof DisconnectedModelAccessException) {
            throw new MPDisconnectionException(mae.getMessage(), mae.getCause());
        }
        if (mae instanceof InvalidModelAccessException) {
            throw new MPInvalidException(mae.getMessage(), mae.getCause());
        }
        if (mae instanceof LockModelAccessException) {
            throw new MPLockException(mae.getMessage(), mae.getCause());
        }
        if (mae instanceof UnsupportedModelAccessException) {
            throw new MPUnsupportedOperationException(mae.getMessage(), mae.getCause());
        }
        if (mae instanceof RuntimeException) {
            throw (RuntimeException)mae;
        }
        throw new MPAccessException(mae.getMessage(), (Throwable)mae);
    }

    public void load(URI uri, Map<MPAdapter.LoadOption, Object> option) throws MPException {
        try {
            this.maa.mpLoad(uri);
        }
        catch (Exception mae) {
            this.convertException(mae);
        }
    }

    public MPAdapter.ReloadResult reload() throws MPException {
        try {
            switch (this.maa.reload()) {
                case DONE: {
                    return MPAdapter.ReloadResult.DONE;
                }
                case NEED_REACTIVATE: {
                    return MPAdapter.ReloadResult.NEED_REACTIVATE;
                }
            }
        }
        catch (Exception mae) {
            this.convertException(mae);
        }
        return MPAdapter.ReloadResult.UNSUPPORTED;
    }

    public MPAdapter.UndoResult undo() throws MPException {
        return null;
    }

    public Resource getResource() {
        return this.maa.getResource();
    }

    public void save(Map<MPAdapter.SaveOption, Object> option) throws MPException {
        URI uri = MPRhpAdapter.checkSaveAs(option);
        boolean saveCopyAs = MPRhpAdapter.checkSaveCopyAs(option);
        try {
            if (uri == null) {
                this.maa.save();
            } else {
                this.maa.saveAs(uri, saveCopyAs);
            }
        }
        catch (Exception mae) {
            this.convertException(mae);
        }
    }

    public void unload() throws MPException {
        this.maa.unload();
    }

    protected MPAbstractAdapter.TranslateInitializersResult translateInitializers(EObject value, Map<EStructuralFeature, Object> inits) throws MPException {
        if (value instanceof REObjectImpl) {
            REObjectImpl reo = (REObjectImpl)value;
            if (inits == null) {
                inits = Collections.emptyMap();
            }
            reo.setInits(inits);
        }
        return null;
    }

    public void delete(EObject eObj) throws MPException {
        try {
            this.maa.dispose(eObj);
        }
        catch (Exception mae) {
            this.convertException(mae);
        }
    }

    public Object get(EObject eObj, EStructuralFeature eStructuralFeature) throws MPException {
        try {
            return this.maa.get(eObj, eStructuralFeature);
        }
        catch (Exception mae) {
            this.convertException(mae);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(EObject eObj, EStructuralFeature feature, Object value, int index) throws MPException {
        REObjectImpl reo;
        Map<EStructuralFeature, Object> inits;
        if (value instanceof REObjectImpl && (inits = (reo = (REObjectImpl)((Object)value)).getInits()) != null) {
            try {
                this.maa.add(eObj, feature, (EObject)reo, index, inits);
            }
            catch (Exception mae) {
                this.convertException(mae);
            }
            finally {
                reo.setInits(null);
            }
            return;
        }
        try {
            this.maa.add(eObj, feature, value, index);
        }
        catch (Exception mae) {
            this.convertException(mae);
        }
    }

    public void remove(EObject eObjOwner, EStructuralFeature feature, Object obj) throws MPException {
        try {
            this.maa.set(eObjOwner, feature, obj);
        }
        catch (Exception mae) {
            this.convertException(mae);
        }
    }

    public void removeByIdx(EObject eObjOwner, EStructuralFeature feature, int index) throws MPException {
        throw new MPAccessException("Rhapsody Adapter does not support index access [" + eObjOwner + "]: " + index + " : " + feature);
    }

    public void set(EObject eObjOwner, EStructuralFeature feature, Object value) throws MPException {
        try {
            this.maa.set(eObjOwner, feature, value);
        }
        catch (Exception mae) {
            this.convertException(mae);
        }
    }

    public void unset(EObject eObjOwner, EStructuralFeature feature, Object value) throws MPException {
        try {
            this.maa.set(eObjOwner, feature, null);
        }
        catch (Exception mae) {
            this.convertException(mae);
        }
    }

    public void storeTransaction() throws MPException {
    }

    public MPAdapter.RedoResult redo() throws MPException {
        return null;
    }
}

