/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.trinity.rhapsody.ecore;

import com.ibm.trinity.rhapsody.ecore.IntegrationMode;
import com.ibm.trinity.rhapsody.ecore.RhpAccessFailureException;
import com.ibm.trinity.rhapsody.ecore.robj.RhpApplication;
import java.io.IOException;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator
implements BundleActivator {
    public static final String PLUGIN_ID = "com.ibm.trinity.rhapsody.ecore";
    public static final String SYSTEM_PROPERTY_INTEGRATION_MODE = "com.ibm.trinity.rhapsody.ecore.IntegrationMode";
    public static final String SYSTEM_PROPERTY_RHPAPIVERSION = "com.ibm.trinity.rhapsody.ecore.RhpAPIVersion";
    public static final String SYSTEM_PROPERTY_RECYCLE_APPLICATION = "com.ibm.trinity.rhapsody.ecore.RecycleApplication";
    private static Activator plugin;
    private IntegrationMode integrationMode = IntegrationMode.DLL_SERVER;
    private boolean recycleApplication;
    private RhpApplication rhpApp;

    public IntegrationMode getIntegrationMode() {
        return this.integrationMode;
    }

    public RhpApplication getRhpApplication() {
        if (this.rhpApp == null) {
            try {
                this.rhpApp = new RhpApplication(this.integrationMode);
            }
            catch (RhpAccessFailureException e) {
                throw e;
            }
            catch (IOException e) {
                return null;
            }
        }
        return this.rhpApp;
    }

    public void disposeRhpApplication(RhpApplication app) {
        this.stopRhapsodyApplication();
    }

    private void stopRhapsodyApplication() {
        if (this.recycleApplication) {
            return;
        }
        try {
            this.rhpApp.quit();
        }
        finally {
            this.rhpApp = null;
        }
    }

    public void start(BundleContext context) throws Exception {
        plugin = this;
        String prop = System.getProperty(SYSTEM_PROPERTY_INTEGRATION_MODE);
        this.integrationMode = IntegrationMode.ACTIVE_APPLICATION.name().equals(prop) ? IntegrationMode.ACTIVE_APPLICATION : (IntegrationMode.SPY_ACTIVE_APPLICATION.name().equals(prop) ? IntegrationMode.SPY_ACTIVE_APPLICATION : (IntegrationMode.DLL_SERVER.name().equals(prop) ? IntegrationMode.DLL_SERVER : (IntegrationMode.LOCAL_SERVER.name().equals(prop) ? IntegrationMode.LOCAL_SERVER : IntegrationMode.DLL_SERVER)));
        String rhpVersion = System.getProperty(SYSTEM_PROPERTY_RHPAPIVERSION);
        try {
            int version = Integer.parseInt(rhpVersion);
            this.integrationMode.setRhpAPIVersion(version);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        prop = System.getProperty(SYSTEM_PROPERTY_RECYCLE_APPLICATION);
        this.recycleApplication = prop == null ? false : Boolean.parseBoolean(prop);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.rhpApp != null) {
            this.stopRhapsodyApplication();
        }
        plugin = null;
    }

    public static Activator getDefault() {
        return plugin;
    }
}

