/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.commandline.core.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.polarsys.capella.core.commandline.core.CommandLineException;
import org.polarsys.capella.core.commandline.core.DefaultCommandLine;
import org.polarsys.capella.core.platform.sirius.ui.app.CapellaWorkbenchAdvisor;

public abstract class AbstractWorkbenchCommandLine
extends DefaultCommandLine {
    private boolean openWindows;
    private IStatus status = Status.OK_STATUS;

    public AbstractWorkbenchCommandLine() {
        this(false);
    }

    public AbstractWorkbenchCommandLine(boolean openWindows) {
        this.openWindows = openWindows;
    }

    public void setStatus(IStatus status) {
        if (this.status.isOK()) {
            this.status = status == null ? Status.OK_STATUS : status;
        }
    }

    public boolean execute(IApplicationContext context) throws CommandLineException {
        this.startWorkbench(this.openWindows);
        if (!this.status.isOK()) {
            throw new CommandLineException(this.status.getMessage());
        }
        return true;
    }

    protected abstract IStatus executeWithinWorkbench();

    protected void registerCommandLine() {
        IEclipseContext context = (IEclipseContext)PlatformUI.getWorkbench().getService(IEclipseContext.class);
        context.set(AbstractWorkbenchCommandLine.class, (Object)this);
    }

    protected void startWorkbench(boolean openWindows) {
        Display display;
        block13: {
            if (PlatformUI.isWorkbenchRunning()) {
                IStatus status = this.executeWithinWorkbench();
                this.setStatus(status);
                return;
            }
            display = PlatformUI.createDisplay();
            try {
                if (openWindows) {
                    PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)new CapellaWorkbenchAdvisor(){

                        public void postStartup() {
                            super.postStartup();
                            AbstractWorkbenchCommandLine.this.registerCommandLine();
                        }
                    });
                } else {
                    PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)new WorkbenchAdvisor(){

                        public boolean openWindows() {
                            return false;
                        }

                        public String getInitialWindowPerspectiveId() {
                            return null;
                        }
                    });
                    IStatus status = this.executeWithinWorkbench();
                    this.setStatus(status);
                }
                break block13;
            }
            catch (Throwable throwable) {
                try {
                    display.update();
                    while (display.readAndDispatch()) {
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (display != null) {
                display.dispose();
            }
            throw throwable;
        }
        try {
            display.update();
            while (display.readAndDispatch()) {
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (display != null) {
            display.dispose();
        }
    }
}

