/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.maplembse.eclipse.uml.adapter;

import com.maplesoft.maplembse.eclipse.uml.adapter.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.openmbee.mpspi.exceptions.MPException;

public class UMLDialogBox
extends Thread {
    private Display display;
    private Dialog targetDialog = null;

    public UMLDialogBox() {
        super("FormualDialogBox");
        this.start();
    }

    public Display getDisplay() {
        if (this.display != null) {
            return this.display;
        }
        Thread th = Thread.currentThread();
        this.display = Display.findDisplay((Thread)th);
        if (this.display == null) {
            this.display = new Display();
        }
        return this.display;
    }

    public Dialog getTargetDialog() {
        return this.targetDialog;
    }

    public int messageBox(String title, String message, int style) {
        MBox mbox = new MBox(title, message, style);
        this.open(mbox);
        return mbox.getResult();
    }

    public int messageBox(String message, int style) {
        MBox mbox = new MBox(message, style);
        this.open(mbox);
        return mbox.getResult();
    }

    public boolean messageBoxAsk(String message) {
        return this.messageBox(message, 292) == 32;
    }

    public boolean messageBoxErr(String message) {
        return this.messageBox(message, 289) == 32;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(Dialog dialog) {
        UMLDialogBox uMLDialogBox = this;
        synchronized (uMLDialogBox) {
            while (this.targetDialog != null) {
                this.waitInternal();
            }
            this.targetDialog = dialog;
            this.notify();
            while (this.targetDialog == dialog) {
                this.waitInternal();
            }
        }
    }

    @Override
    public void run() {
        UMLDialogBox uMLDialogBox = this;
        synchronized (uMLDialogBox) {
            while (true) {
                if (this.targetDialog != null) {
                    try {
                        this.openDialog(this.targetDialog);
                    }
                    catch (Throwable th) {
                        this.targetDialog = null;
                        this.display.close();
                    }
                    this.notifyAll();
                    continue;
                }
                this.waitInternal();
            }
        }
    }

    private void openDialog(Dialog dialog) throws MPException {
        Display d = this.getDisplay();
        Shell shell = dialog.open(d);
        while (!shell.isDisposed()) {
            if (d.readAndDispatch()) continue;
            d.sleep();
        }
        this.targetDialog = null;
    }

    private void waitInternal() {
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static class MBox
    implements Dialog {
        private final String message;
        private int result;
        private final int style;
        private String title = "";

        public MBox(String message, int style) {
            this.message = message;
            this.style = style;
        }

        public MBox(String title, String message, int style) {
            this.title = title;
            this.message = message;
            this.style = style;
        }

        public int getResult() {
            return this.result;
        }

        @Override
        public Shell open(Display display) {
            Shell shell = new Shell(display, 147488);
            shell.setText("MapleMBSE Formula Evaluation");
            MessageBox mbox = new MessageBox(shell, this.style);
            mbox.setText(this.title);
            mbox.setMessage(this.message);
            this.result = mbox.open();
            shell.close();
            return shell;
        }
    }
}

