/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.esi.core.msg.info.impl;

import java.util.Arrays;
import java.util.LinkedList;

public class ValueHolder {
    private static final Object[] NO_VALUES = new Object[0];
    private static final byte[] BITS_WITH_VALUE1 = new byte[256];
    private Object[] mValues = NO_VALUES;
    private final byte[] mIndexes;

    static {
        int n = 0;
        while (n < BITS_WITH_VALUE1.length) {
            ValueHolder.BITS_WITH_VALUE1[n] = ValueHolder.countBitsWithValue1(n, 8);
            ++n;
        }
    }

    public int getObjectLength() {
        return this.mValues.length;
    }

    public ValueHolder(int n) {
        this.mIndexes = new byte[(n >> 3) + 1];
    }

    public Object getValue(int n) {
        return ValueHolder.getValue(this.mIndexes, this.mValues, n);
    }

    public void setValue(int n, Object object) {
        this.mValues = ValueHolder.setValue(this.mIndexes, this.mValues, n, object);
    }

    public boolean isSetValue(int n) {
        return ValueHolder.isSetValue(this.mIndexes, n);
    }

    private static boolean isSetValue(byte[] byArray, int n) {
        byte by = byArray[n >> 3];
        return (1 << (n & 7) & by) != 0;
    }

    private static Object[] setValue(byte[] byArray, Object[] objectArray, int n, Object object) {
        boolean bl = ValueHolder.isSetValue(byArray, n);
        if (object == null && !bl) {
            return objectArray;
        }
        byte by = ValueHolder.countBitsWithValue1(byArray, n);
        if (!bl) {
            int n2 = n >> 3;
            byte by2 = byArray[n2];
            byArray[n2] = (byte)(by2 | 1 << (n & 7));
            Object[] objectArray2 = new Object[objectArray.length + 1];
            if (by > 0) {
                System.arraycopy(objectArray, 0, objectArray2, 0, by);
            }
            System.arraycopy(objectArray, by, objectArray2, by + 1, objectArray.length - by);
            objectArray2[by] = object;
            return objectArray2;
        }
        objectArray[by] = object;
        return objectArray;
    }

    private static byte countBitsWithValue1(byte[] byArray, int n) {
        byte by;
        byte by2 = 0;
        int n2 = n >> 3;
        int n3 = 0;
        while (n3 < n2) {
            by = byArray[n3];
            by2 = (byte)(by2 + BITS_WITH_VALUE1[by & 0xFF]);
            ++n3;
        }
        n3 = (1 << (n & 7)) - 1;
        by = BITS_WITH_VALUE1[byArray[n2] & n3];
        by2 = (byte)(by2 + by);
        return by2;
    }

    private static byte countBitsWithValue1(byte[] byArray) {
        byte by = 0;
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            byte by2 = byArray[n2];
            by = (byte)(by + BITS_WITH_VALUE1[by2 & 0xFF]);
            ++n2;
        }
        return by;
    }

    private static byte countBitsWithValue1(int n, int n2) {
        byte by = 0;
        int n3 = n2;
        while (n3 > 0) {
            by = (byte)(by + (n & 1));
            n >>= 1;
            --n3;
        }
        return by;
    }

    private static Object getValue(byte[] byArray, Object[] objectArray, int n) {
        if (!ValueHolder.isSetValue(byArray, n)) {
            return null;
        }
        byte by = ValueHolder.countBitsWithValue1(byArray, n);
        return objectArray[by];
    }

    public int[] getSetFeatureIDs() {
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        int n = 0;
        int n2 = 0;
        while (n2 < this.mIndexes.length) {
            byte by = this.mIndexes[n2];
            if ((by & 1) != 0) {
                linkedList.add(n);
            }
            if ((by & 2) != 0) {
                linkedList.add(n + 1);
            }
            if ((by & 4) != 0) {
                linkedList.add(n + 2);
            }
            if ((by & 8) != 0) {
                linkedList.add(n + 3);
            }
            if ((by & 0x10) != 0) {
                linkedList.add(n + 4);
            }
            if ((by & 0x20) != 0) {
                linkedList.add(n + 5);
            }
            if ((by & 0x40) != 0) {
                linkedList.add(n + 6);
            }
            if ((by & 0x80) != 0) {
                linkedList.add(n + 7);
            }
            n += 8;
            ++n2;
        }
        return linkedList.stream().mapToInt(Integer::intValue).toArray();
    }

    public boolean isEmpty() {
        byte by = ValueHolder.countBitsWithValue1(this.mIndexes);
        return by == 0;
    }

    public void removeValue(int n) {
        this.setValue(n, null);
    }

    public int hashCode() {
        int[] nArray;
        int n = 1;
        int[] nArray2 = nArray = this.getSetFeatureIDs();
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = nArray2[n3];
            Object object = this.getValue(n4);
            n = 31 * n + (object == null ? 0 : object.hashCode());
            ++n3;
        }
        return n;
    }

    public boolean equals(Object object) {
        int[] nArray;
        if (!(object instanceof ValueHolder)) {
            return false;
        }
        ValueHolder valueHolder = (ValueHolder)object;
        if (this.getObjectLength() != valueHolder.getObjectLength()) {
            return false;
        }
        int[] nArray2 = nArray = this.getSetFeatureIDs();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray2[n2];
            Object object2 = this.getValue(n3);
            if (object2 == null) {
                if (valueHolder.getValue(n3) != null) {
                    return false;
                }
            } else {
                Object object3 = valueHolder.getValue(n3);
                if (object2.getClass().isArray() && object3.getClass().isArray()) {
                    return this.compareArray(object2, object3);
                }
                if (!object2.equals(object3)) {
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }

    private boolean compareArray(Object object, Object object2) {
        if (object instanceof boolean[] && object2 instanceof boolean[]) {
            return Arrays.equals((boolean[])object, (boolean[])object2);
        }
        if (object instanceof byte[] && object2 instanceof byte[]) {
            return Arrays.equals((byte[])object, (byte[])object2);
        }
        if (object instanceof char[] && object2 instanceof char[]) {
            return Arrays.equals((char[])object, (char[])object2);
        }
        if (object instanceof double[] && object2 instanceof double[]) {
            return Arrays.equals((double[])object, (double[])object2);
        }
        if (object instanceof float[] && object2 instanceof float[]) {
            return Arrays.equals((float[])object, (float[])object2);
        }
        if (object instanceof int[] && object2 instanceof int[]) {
            return Arrays.equals((int[])object, (int[])object2);
        }
        if (object instanceof long[] && object2 instanceof long[]) {
            return Arrays.equals((long[])object, (long[])object2);
        }
        if (object instanceof short[] && object2 instanceof short[]) {
            return Arrays.equals((short[])object, (short[])object2);
        }
        return Arrays.equals((Object[])object, (Object[])object2);
    }
}

