/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.esi.core.msg.info.impl;

import com.nomagic.esi.api.info.UserInfo;
import com.nomagic.esi.api.messages.info.RoleAssignmentInfo;
import com.nomagic.esi.helper.annotation.Since;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;

public class UserInfoImpl
implements UserInfo {
    private static final String REAM_KEY = "realmid";
    private transient String realm;
    private final String userName;
    private String password;
    private final boolean isEnabled;
    private final Date lastLoginDate;
    @Since(value="19.0.3")
    private final Date modifiedDate;
    @Since(value="19.0.3")
    private final Date createdDate;
    private final HashMap<String, String> otherAttributes;
    private final HashSet<UUID> userGroupIDs;
    private HashSet<RoleAssignmentInfo> roleAssignments;
    private final UUID userID;
    @Since(value="19.0.3")
    private final boolean isRemoved;

    public int hashCode() {
        int n = 1;
        int n2 = 37 * n;
        int n3 = this.realm == null ? 0 : this.realm.hashCode();
        n = n2 + n3;
        int n4 = 37 * n;
        int n5 = this.userName == null ? 0 : this.userName.hashCode();
        n = n4 + n5;
        int n6 = 37 * n;
        int n7 = this.password == null ? 0 : this.password.hashCode();
        n = n6 + n7;
        int n8 = 37 * n;
        int n9 = this.otherAttributes == null ? 0 : this.otherAttributes.hashCode();
        n = n8 + n9;
        int n10 = 37 * n;
        int n11 = this.userGroupIDs == null ? 0 : this.userGroupIDs.hashCode();
        n = n10 + n11;
        int n12 = 37 * n;
        int n13 = this.roleAssignments == null ? 0 : this.roleAssignments.hashCode();
        n = n12 + n13;
        int n14 = 37 * n;
        int n15 = this.userID == null ? 0 : this.userID.hashCode();
        n = n14 + n15;
        int n16 = 37 * n;
        int n17 = this.isEnabled ? 0 : 1;
        n = n16 + n17;
        int n18 = 37 * n;
        int n19 = this.lastLoginDate == null ? 0 : this.lastLoginDate.hashCode();
        n = n18 + n19;
        int n20 = 37 * n;
        int n21 = this.createdDate == null ? 0 : this.createdDate.hashCode();
        n = n20 + n21;
        int n22 = 37 * n;
        int n23 = this.modifiedDate == null ? 0 : this.modifiedDate.hashCode();
        n = n22 + n23;
        int n24 = 37 * n;
        int n25 = this.isRemoved ? 0 : 1;
        n = n24 + n25;
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof UserInfoImpl)) {
            return false;
        }
        UserInfoImpl userInfoImpl = (UserInfoImpl)object;
        boolean bl = Objects.equals(this.userID, userInfoImpl.getUserID());
        if (!bl) {
            return false;
        }
        boolean bl2 = Objects.equals(this.userName, userInfoImpl.getUserName());
        if (!bl2) {
            return false;
        }
        boolean bl3 = Objects.equals(this.createdDate, userInfoImpl.getCreatedDate());
        if (!bl3) {
            return false;
        }
        boolean bl4 = Objects.equals(this.realm, userInfoImpl.getRealm());
        if (!bl4) {
            return false;
        }
        boolean bl5 = Objects.equals(this.password, userInfoImpl.getPassword());
        if (!bl5) {
            return false;
        }
        boolean bl6 = this.isEnabled == userInfoImpl.isEnabled();
        boolean bl7 = bl6;
        if (!bl7) {
            return false;
        }
        boolean bl8 = Objects.equals(this.lastLoginDate, userInfoImpl.getLastLoginDate());
        if (!bl8) {
            return false;
        }
        boolean bl9 = Objects.equals(this.modifiedDate, userInfoImpl.getModifiedDate());
        if (!bl9) {
            return false;
        }
        boolean bl10 = Objects.equals(this.otherAttributes, userInfoImpl.getOtherAttributes());
        if (!bl10) {
            return false;
        }
        boolean bl11 = Objects.equals(this.userGroupIDs, userInfoImpl.getUserGroupIDs());
        if (!bl11) {
            return false;
        }
        boolean bl12 = Objects.equals(this.roleAssignments, userInfoImpl.getRoleAssignments());
        if (!bl12) {
            return false;
        }
        boolean bl13 = this.isRemoved == userInfoImpl.isRemoved();
        boolean bl14 = bl13;
        if (!bl14) {
            return false;
        }
        return true;
    }

    public UserInfoImpl(String string, UUID uUID, Date date, Date date2) {
        this(string, uUID, null, false, null, date, date2, null, null, null, true);
    }

    public UserInfoImpl(String string, UUID uUID, String string2, boolean bl, Date date, Date date2, HashMap<String, String> hashMap, HashSet<UUID> hashSet) {
        this(string, uUID, string2, bl, null, date, date2, null, hashMap, hashSet, false);
    }

    public UserInfoImpl(String string, UUID uUID, String string2, boolean bl, Date date, Date date2, String string3, HashMap<String, String> hashMap, HashSet<UUID> hashSet) {
        this(string, uUID, string2, bl, null, date, date2, string3, hashMap, hashSet, false);
    }

    public UserInfoImpl(String string, UUID uUID, String string2, boolean bl, Date date, Date date2, Date date3, String string3, HashMap<String, String> hashMap, HashSet<UUID> hashSet, boolean bl2) {
        this.userName = string;
        this.password = string2;
        this.isEnabled = bl;
        this.userID = uUID;
        this.otherAttributes = hashMap == null ? new HashMap() : new HashMap<String, String>(hashMap);
        this.userGroupIDs = hashSet == null ? new HashSet() : new HashSet<UUID>(hashSet);
        this.lastLoginDate = date;
        this.modifiedDate = date2;
        this.createdDate = date3;
        if (string3 != null) {
            this.otherAttributes.put(REAM_KEY, string3);
        }
        this.isRemoved = bl2;
    }

    public void setRoleAssignments(List<RoleAssignmentInfo> list) {
        if (this.roleAssignments != null) {
            throw new IllegalStateException("role assignment had been set already");
        }
        this.roleAssignments = list == null ? new HashSet() : new HashSet<RoleAssignmentInfo>(list);
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public Set<UUID> getUserGroupIDs() {
        return this.userGroupIDs;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public Map<String, String> getOtherAttributes() {
        HashMap<String, String> hashMap = new HashMap<String, String>(this.otherAttributes);
        hashMap.remove(REAM_KEY);
        return hashMap;
    }

    public Set<RoleAssignmentInfo> getRoleAssignments() {
        Set<RoleAssignmentInfo> set = this.roleAssignments == null ? Collections.emptySet() : Collections.unmodifiableSet(this.roleAssignments);
        return set;
    }

    public RoleAssignmentInfo getRoleAssignment(UUID uUID) {
        for (RoleAssignmentInfo roleAssignmentInfo : this.getRoleAssignments()) {
            if (!roleAssignmentInfo.getRoleID().equals(uUID)) continue;
            return roleAssignmentInfo;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<UUID> getRoleIDs() {
        HashSet<UUID> hashSet = new HashSet<UUID>();
        for (RoleAssignmentInfo roleAssignmentInfo : this.getRoleAssignments()) {
            hashSet.add(roleAssignmentInfo.getRoleID());
        }
        return new ArrayList<UUID>(hashSet);
    }

    public Date getLastLoginDate() {
        return this.lastLoginDate;
    }

    public boolean isExternal() {
        if (this.getRealm() != null) {
            return true;
        }
        return false;
    }

    public String getRealm() {
        if (this.realm == null) {
            this.realm = this.otherAttributes.get(REAM_KEY);
        }
        return this.realm;
    }

    public UUID getUserID() {
        return this.userID;
    }

    public Date getModifiedDate() {
        return this.modifiedDate;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public boolean isRemoved() {
        return this.isRemoved;
    }
}

