/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.esi.core.msg.info.impl;

import com.nomagic.esi.api.constants.RbacConstants;
import com.nomagic.esi.api.info.PermissionInfo;
import com.nomagic.esi.api.info.RoleInfo;
import com.nomagic.esi.api.messages.info.ProtectedObjectInfo;
import com.nomagic.esi.core.msg.info.impl.PermissionInfoImpl;
import com.nomagic.esi.core.msg.info.impl.ProtectedObjectInfoImpl;
import com.nomagic.esi.core.msg.info.impl.RoleAssignmentInfoImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class RoleInfoImpl
implements RoleInfo {
    private final UUID id;
    private final String name;
    private final String description;
    private final List<PermissionInfoImpl> permissions;

    public RoleInfoImpl(UUID uUID, String string, String string2, List<PermissionInfoImpl> list) {
        this.id = uUID;
        this.name = string;
        this.description = string2;
        this.permissions = list == null ? new ArrayList<PermissionInfoImpl>() : new ArrayList<PermissionInfoImpl>(list);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.id == null ? 0 : this.id.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RoleInfoImpl roleInfoImpl = (RoleInfoImpl)object;
        return !(this.id == null ? roleInfoImpl.id != null : !this.id.equals(roleInfoImpl.id));
    }

    public UUID getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<PermissionInfo> getPermissions() {
        ArrayList<PermissionInfo> arrayList = new ArrayList<PermissionInfo>();
        arrayList.addAll(this.permissions);
        return arrayList;
    }

    public List<PermissionInfoImpl> getPermissionsImpl() {
        return new ArrayList<PermissionInfoImpl>(this.permissions);
    }

    public String toString() {
        return "RoleInfo(" + this.id + ", " + this.name + ")";
    }

    public Set<String> getProtectedTypes() {
        HashSet<String> hashSet = new HashSet<String>();
        for (PermissionInfoImpl permissionInfoImpl : this.permissions) {
            hashSet.add(permissionInfoImpl.getProtectedType());
        }
        return hashSet;
    }

    public Set<String> getProtectedTypesForNonGlobalOperations() {
        HashSet<String> hashSet = new HashSet<String>();
        for (PermissionInfoImpl permissionInfoImpl : this.permissions) {
            RbacConstants.AccessScope accessScope = permissionInfoImpl.getOperationAssignableAccessScope();
            if (RbacConstants.AccessScope.GLOBAL_ONLY.equals((Object)accessScope)) continue;
            hashSet.add(permissionInfoImpl.getProtectedType());
        }
        return hashSet;
    }

    public List<ProtectedObjectInfoImpl> getInvalidProtectedObjects(List<? extends ProtectedObjectInfo> list) {
        if (list == null) {
            return new ArrayList<ProtectedObjectInfoImpl>();
        }
        Set<String> set = this.getProtectedTypes();
        ArrayList<ProtectedObjectInfoImpl> arrayList = new ArrayList<ProtectedObjectInfoImpl>();
        for (ProtectedObjectInfo protectedObjectInfo : list) {
            if (set.contains(protectedObjectInfo.getProtectedType())) continue;
            arrayList.add((ProtectedObjectInfoImpl)protectedObjectInfo);
        }
        return arrayList;
    }

    public List<ProtectedObjectInfoImpl> getInvalidProtectedObjectsForNotGlobalOperations(List<? extends ProtectedObjectInfo> list) {
        if (list == null) {
            return new ArrayList<ProtectedObjectInfoImpl>();
        }
        Set<String> set = this.getProtectedTypesForNonGlobalOperations();
        ArrayList<ProtectedObjectInfoImpl> arrayList = new ArrayList<ProtectedObjectInfoImpl>();
        for (ProtectedObjectInfo protectedObjectInfo : list) {
            if (set.contains(protectedObjectInfo.getProtectedType())) continue;
            arrayList.add((ProtectedObjectInfoImpl)protectedObjectInfo);
        }
        return arrayList;
    }

    public boolean containGlobalOperationsOnly() {
        for (PermissionInfoImpl permissionInfoImpl : this.permissions) {
            RbacConstants.AccessScope accessScope = permissionInfoImpl.getOperationAssignableAccessScope();
            if (RbacConstants.AccessScope.GLOBAL_ONLY.equals((Object)accessScope)) continue;
            return false;
        }
        return true;
    }

    public Map<PermissionInfo, Set<ProtectedObjectInfo>> groupProtectedObjectsByPermission(List<RoleAssignmentInfoImpl> list) {
        HashMap<PermissionInfo, Set<ProtectedObjectInfo>> hashMap = new HashMap<PermissionInfo, Set<ProtectedObjectInfo>>();
        if (list != null) {
            Collection<Object> collection;
            Object object;
            HashMap<String, HashSet<ProtectedObjectInfo>> hashMap2 = new HashMap<String, HashSet<ProtectedObjectInfo>>();
            for (RoleAssignmentInfoImpl roleAssignmentInfoImpl : list) {
                if (!roleAssignmentInfoImpl.getRoleID().equals(this.id)) continue;
                object = roleAssignmentInfoImpl.groupProtectedObjectsByClass();
                for (Map.Entry<String, List<ProtectedObjectInfo>> entry : object.entrySet()) {
                    collection = entry.getValue();
                    if (collection == null || collection.isEmpty()) continue;
                    String string = entry.getKey();
                    HashSet<ProtectedObjectInfo> hashSet = (HashSet<ProtectedObjectInfo>)hashMap2.get(string);
                    if (hashSet == null) {
                        hashSet = new HashSet<ProtectedObjectInfo>();
                        hashMap2.put(string, hashSet);
                    }
                    hashSet.addAll(collection);
                }
            }
            for (PermissionInfo permissionInfo : this.permissions) {
                Object object2;
                object = permissionInfo.getProtectedType();
                RbacConstants.AccessScope accessScope = permissionInfo.getOperationAssignableAccessScope();
                if (RbacConstants.AccessScope.GLOBAL_ONLY.equals((Object)accessScope)) {
                    object2 = new HashSet();
                    object2.add(new ProtectedObjectInfoImpl((String)object, RbacConstants.ANY_PROTECTED_OBJECT));
                    hashMap.put(permissionInfo, (Set<ProtectedObjectInfo>)object2);
                    continue;
                }
                object2 = (Set)hashMap2.get(object);
                if (object2 == null || object2.isEmpty()) continue;
                collection = new HashSet(object2);
                hashMap.put(permissionInfo, (Set<ProtectedObjectInfo>)collection);
            }
        }
        return hashMap;
    }

    public List<UUID> getPermissionIDs() {
        ArrayList<UUID> arrayList = new ArrayList<UUID>(this.permissions.size());
        for (PermissionInfo permissionInfo : this.permissions) {
            arrayList.add(permissionInfo.getID());
        }
        return arrayList;
    }
}

