/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.esi.core.msg.info.impl;

import com.nomagic.esi.api.messages.info.ProtectedObjectInfo;
import com.nomagic.esi.api.messages.info.RoleAssignmentInfo;
import com.nomagic.esi.core.msg.info.impl.ProtectedObjectInfoImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class RoleAssignmentInfoImpl
implements RoleAssignmentInfo {
    private UUID id;
    private UUID roleID;
    private List<ProtectedObjectInfoImpl> protectedObjects;

    public RoleAssignmentInfoImpl(UUID uUID, UUID uUID2, List<ProtectedObjectInfoImpl> list) {
        this.id = uUID;
        this.roleID = uUID2;
        this.protectedObjects = list != null ? new ArrayList<ProtectedObjectInfoImpl>(list) : new ArrayList<ProtectedObjectInfoImpl>();
    }

    public Map<String, List<ProtectedObjectInfo>> groupProtectedObjectsByClass() {
        HashMap<String, List<ProtectedObjectInfo>> hashMap = new HashMap<String, List<ProtectedObjectInfo>>();
        for (ProtectedObjectInfo protectedObjectInfo : this.protectedObjects) {
            String string = protectedObjectInfo.getProtectedType();
            LinkedList<ProtectedObjectInfo> linkedList = (LinkedList<ProtectedObjectInfo>)hashMap.get(string);
            if (linkedList == null) {
                linkedList = new LinkedList<ProtectedObjectInfo>();
                hashMap.put(string, linkedList);
            }
            linkedList.add(protectedObjectInfo);
        }
        return hashMap;
    }

    public UUID getID() {
        return this.id;
    }

    public UUID getRoleID() {
        return this.roleID;
    }

    public List<ProtectedObjectInfo> getProtectedObjects() {
        return Collections.unmodifiableList(this.protectedObjects);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.id == null ? 0 : this.id.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RoleAssignmentInfoImpl roleAssignmentInfoImpl = (RoleAssignmentInfoImpl)object;
        return !(this.id == null ? roleAssignmentInfoImpl.id != null : !this.id.equals(roleAssignmentInfoImpl.id));
    }

    public String toString() {
        return "RoleAssignment(" + this.getID() + ", " + this.getRoleID() + ", " + this.getProtectedObjects() + ")";
    }
}

