/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.esi.core.msg.info.impl;

import com.nomagic.esi.api.CommitType;
import com.nomagic.esi.api.messages.info.MergeInfo;
import com.nomagic.esi.core.msg.info.CommonAncestorAlgorithmInfo;
import com.nomagic.esi.helper.a.b;
import java.util.UUID;

public class RevisionTypeAndInfo {
    private UUID resourceID;
    private UUID branchID;
    private long commitRevision;
    private CommitType commitType;
    private long directParent;
    private long commitAsLatestRevision;
    private MergeInfo mergeInfo;
    private transient int hashCode;

    public static RevisionTypeAndInfo getCommitAsLatestCommitType(UUID uUID, UUID uUID2, long l, long l2, long l3) {
        b.a((String)"resource id", (Object)uUID);
        b.a((String)"branch id", (Object)uUID2);
        b.a((String)"commit revision", (long)l);
        b.a((String)"direct parent's revision", (long)l2);
        b.a((String)"picked revision", (long)l3);
        RevisionTypeAndInfo revisionTypeAndInfo = new RevisionTypeAndInfo();
        revisionTypeAndInfo.resourceID = uUID;
        revisionTypeAndInfo.branchID = uUID2;
        revisionTypeAndInfo.commitRevision = l;
        revisionTypeAndInfo.directParent = l2;
        revisionTypeAndInfo.commitAsLatestRevision = l3;
        revisionTypeAndInfo.commitType = CommitType.COMMIT_AS_LATEST;
        return revisionTypeAndInfo;
    }

    public static RevisionTypeAndInfo getMergedCommitType(UUID uUID, UUID uUID2, long l, long l2, UUID uUID3, long l3, CommonAncestorAlgorithmInfo commonAncestorAlgorithmInfo) {
        MergeInfo mergeInfo;
        b.a((String)"resource id", (Object)uUID);
        b.a((String)"branch id", (Object)uUID2);
        b.a((String)"commit revision", (long)l);
        b.a((String)"direct parent's revision", (long)l2);
        b.a((String)"merged parent's revision", (long)l3);
        b.a((String)"merged from branch", (Object)uUID3);
        RevisionTypeAndInfo revisionTypeAndInfo = new RevisionTypeAndInfo();
        revisionTypeAndInfo.resourceID = uUID;
        revisionTypeAndInfo.branchID = uUID2;
        revisionTypeAndInfo.commitRevision = l;
        revisionTypeAndInfo.directParent = l2;
        revisionTypeAndInfo.mergeInfo = mergeInfo = new MergeInfo(uUID3, l3, l2, commonAncestorAlgorithmInfo.getAlgorithm().ordinal(), commonAncestorAlgorithmInfo.isJumpCommitAsLatest(), commonAncestorAlgorithmInfo.getSelectedCommonAncestor());
        revisionTypeAndInfo.commitAsLatestRevision = -1L;
        revisionTypeAndInfo.commitType = CommitType.MERGED;
        return revisionTypeAndInfo;
    }

    public static RevisionTypeAndInfo getNormalCommitType(UUID uUID, UUID uUID2, long l, long l2) {
        b.a((String)"resource id", (Object)uUID);
        b.a((String)"branch id", (Object)uUID2);
        b.a((String)"commit revision", (long)l);
        if (l != 1L) {
            b.a((String)"direct parent's revision", (long)l2);
        } else {
            b.a((Object)-1L, (Object)l2);
        }
        RevisionTypeAndInfo revisionTypeAndInfo = new RevisionTypeAndInfo();
        revisionTypeAndInfo.resourceID = uUID;
        revisionTypeAndInfo.branchID = uUID2;
        revisionTypeAndInfo.commitRevision = l;
        revisionTypeAndInfo.directParent = l2;
        revisionTypeAndInfo.commitAsLatestRevision = -1L;
        revisionTypeAndInfo.commitType = CommitType.NORMAL;
        return revisionTypeAndInfo;
    }

    public static RevisionTypeAndInfo getUncommittedType(UUID uUID, UUID uUID2, long l) {
        b.a((String)"resource id", (Object)uUID);
        b.a((String)"branch id", (Object)uUID2);
        RevisionTypeAndInfo revisionTypeAndInfo = new RevisionTypeAndInfo();
        revisionTypeAndInfo.resourceID = uUID;
        revisionTypeAndInfo.branchID = uUID2;
        revisionTypeAndInfo.commitRevision = l;
        revisionTypeAndInfo.directParent = -1L;
        revisionTypeAndInfo.commitAsLatestRevision = -1L;
        return revisionTypeAndInfo;
    }

    public static RevisionTypeAndInfo getUnsureNormalOrCommitAsLatestCommitType(UUID uUID, UUID uUID2, long l, long l2) {
        b.a((String)"resource id", (Object)uUID);
        b.a((String)"branch id", (Object)uUID2);
        b.a((String)"commit revision", (long)l);
        if (l != 1L) {
            b.a((String)"direct parent's revision", (long)l2);
        } else {
            b.a((Object)-1L, (Object)l2);
        }
        RevisionTypeAndInfo revisionTypeAndInfo = new RevisionTypeAndInfo();
        revisionTypeAndInfo.resourceID = uUID;
        revisionTypeAndInfo.branchID = uUID2;
        revisionTypeAndInfo.commitRevision = l;
        revisionTypeAndInfo.directParent = l2;
        revisionTypeAndInfo.commitAsLatestRevision = 0L;
        revisionTypeAndInfo.commitType = CommitType.NORMAL;
        return revisionTypeAndInfo;
    }

    private RevisionTypeAndInfo() {
    }

    public UUID getResourceID() {
        return this.resourceID;
    }

    public UUID getBranchID() {
        return this.branchID;
    }

    public long getCommitRevision() {
        return this.commitRevision;
    }

    public CommitType getCommitType() {
        return this.commitType;
    }

    public long getDirectParent() {
        return this.directParent;
    }

    public long getCommitAsLatestRevision() {
        return this.commitAsLatestRevision;
    }

    public MergeInfo getMergeInfo() {
        return this.mergeInfo;
    }

    public boolean equals(Object object) {
        if (!(object instanceof RevisionTypeAndInfo)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        RevisionTypeAndInfo revisionTypeAndInfo = (RevisionTypeAndInfo)object;
        if (this.resourceID == null ? revisionTypeAndInfo.resourceID != null : !this.resourceID.equals(revisionTypeAndInfo.resourceID)) {
            return false;
        }
        if (this.branchID == null ? revisionTypeAndInfo.branchID != null : !this.branchID.equals(revisionTypeAndInfo.branchID)) {
            return false;
        }
        if (this.commitRevision != revisionTypeAndInfo.commitRevision || this.commitType != revisionTypeAndInfo.commitType || this.directParent != revisionTypeAndInfo.directParent || this.commitAsLatestRevision != revisionTypeAndInfo.commitAsLatestRevision) {
            return false;
        }
        return !(this.mergeInfo == null ? revisionTypeAndInfo.mergeInfo != null : !this.mergeInfo.equals((Object)revisionTypeAndInfo.mergeInfo));
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int n = 1;
            n = 31 * n + (this.resourceID == null ? 0 : this.resourceID.hashCode());
            n = 31 * n + (this.branchID == null ? 0 : this.branchID.hashCode());
            n = 31 * n + (int)(this.commitRevision ^ this.commitRevision >>> 32);
            n = 31 * n + (this.commitType == null ? 0 : this.commitType.getType().hashCode());
            n = 31 * n + (int)(this.directParent ^ this.directParent >>> 32);
            n = 31 * n + (int)(this.commitAsLatestRevision ^ this.commitAsLatestRevision >>> 32);
            this.hashCode = n = 31 * n + (this.mergeInfo == null ? 0 : this.mergeInfo.hashCode());
        }
        return this.hashCode;
    }

    public String toString() {
        if (this.commitType == CommitType.NORMAL) {
            return String.format("resource=%s, branch=%s, commit revision=%s, commit type=%s, direct parent revision=%s", this.resourceID.toString(), this.branchID.toString(), String.valueOf(this.commitRevision), this.commitType.getType(), String.valueOf(this.directParent));
        }
        if (this.commitType == CommitType.COMMIT_AS_LATEST) {
            return String.format("resource=%s, branch=%s, commit revision=%s, commit type=%s, direct parent revision=%s, jump from revision=%s", this.resourceID.toString(), this.branchID.toString(), String.valueOf(this.commitRevision), this.commitType.getType(), String.valueOf(this.directParent), String.valueOf(this.commitAsLatestRevision));
        }
        if (this.commitType == CommitType.MERGED) {
            return String.format("resource=%s, branch=%s, commit revision=%s, commit type=%s, direct parent revision=%s, %s", this.resourceID.toString(), this.branchID.toString(), String.valueOf(this.commitRevision), this.commitType.getType(), String.valueOf(this.directParent), this.mergeInfo.toString());
        }
        return null;
    }
}

