/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.esi.core.msg.info.impl;

import com.nomagic.esi.api.info.ResourceInfo;
import com.nomagic.esi.helper.annotation.Since;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public class ResourceInfoImpl
implements ResourceInfo {
    private final UUID resourceID;
    private boolean removed;
    private final UUID trunkID;
    private final Map<String, Object> metadata;
    private final UUID categoryID;
    @Since(value="19.0.3")
    private final Date createdDate;
    @Since(value="19.0.3")
    private final Date modifiedDate;

    public ResourceInfoImpl(UUID uUID, Map<String, ?> map, boolean bl, UUID uUID2, UUID uUID3) {
        this.resourceID = uUID;
        this.removed = bl;
        this.trunkID = uUID2;
        this.metadata = new HashMap<String, Object>();
        if (map != null) {
            this.metadata.putAll(map);
        }
        this.categoryID = uUID3;
        this.modifiedDate = null;
        this.createdDate = null;
    }

    public ResourceInfoImpl(UUID uUID, Map<String, ?> map, boolean bl, UUID uUID2, UUID uUID3, Date date, Date date2) {
        this.resourceID = uUID;
        this.removed = bl;
        this.trunkID = uUID2;
        this.metadata = new HashMap<String, Object>();
        if (map != null) {
            this.metadata.putAll(map);
        }
        this.categoryID = uUID3;
        this.modifiedDate = date;
        this.createdDate = date2;
    }

    public UUID getID() {
        return this.resourceID;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public String getName() {
        return (String)this.metadata.get("name");
    }

    public String getDescription() {
        return (String)this.metadata.get("description");
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public UUID getTrunkID() {
        return this.trunkID;
    }

    public UUID getCategoryID() {
        return this.categoryID;
    }

    public void setRemoved(boolean bl) {
        this.removed = bl;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.trunkID == null ? 0 : this.trunkID.hashCode());
        n = 31 * n + (this.metadata == null ? 0 : this.metadata.hashCode());
        n = 31 * n + (this.removed ? 1231 : 1237);
        n = 31 * n + (this.resourceID == null ? 0 : this.resourceID.hashCode());
        n = 31 * n + (this.categoryID == null ? 0 : this.categoryID.hashCode());
        n = 31 * n + (this.createdDate == null ? 0 : this.createdDate.hashCode());
        n = 31 * n + (this.modifiedDate == null ? 0 : this.modifiedDate.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof ResourceInfoImpl)) {
            return false;
        }
        ResourceInfoImpl resourceInfoImpl = (ResourceInfoImpl)object;
        if (!Objects.equals(this.createdDate, resourceInfoImpl.createdDate)) {
            return false;
        }
        if (!Objects.equals(this.trunkID, resourceInfoImpl.trunkID)) {
            return false;
        }
        if (!Objects.equals(this.metadata, resourceInfoImpl.metadata)) {
            return false;
        }
        if (this.removed != resourceInfoImpl.removed) {
            return false;
        }
        if (!Objects.equals(this.resourceID, resourceInfoImpl.resourceID)) {
            return false;
        }
        if (!Objects.equals(this.categoryID, resourceInfoImpl.categoryID)) {
            return false;
        }
        return Objects.equals(this.modifiedDate, resourceInfoImpl.modifiedDate);
    }

    public Date getModifiedDate() {
        return this.modifiedDate;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }
}

