/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.esi.core.msg.info.impl;

import com.nomagic.esi.core.msg.a.a;
import com.nomagic.esi.core.msg.info.Ref;
import com.nomagic.esi.core.msg.info.impl.EFeatureDelta;
import com.nomagic.esi.core.msg.info.impl.EObjectData;
import com.nomagic.esi.core.msg.info.impl.EObjectDelta;
import com.nomagic.esi.core.msg.info.impl.EPackageID;
import com.nomagic.esi.core.msg.info.impl.ValueHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EObjectDataImpl
extends EObjectData {
    private static Logger LOG = LoggerFactory.getLogger(EObjectDataImpl.class);
    private final ValueHolder featureValues;
    private final short featureCount;
    private transient List<FeatureIDandValue> originalValues;

    public EObjectDataImpl(UUID uUID, int n, String string, int n2) {
        super(uUID, n, string);
        this.featureValues = new ValueHolder(n2);
        this.featureCount = (short)n2;
    }

    public EObjectDataImpl(UUID uUID, EPackageID ePackageID, String string, int n) {
        super(uUID, ePackageID, string);
        this.featureValues = new ValueHolder(n);
        this.featureCount = (short)n;
    }

    public EObjectDataImpl(UUID uUID, EPackageID ePackageID, String string, int n, ValueHolder valueHolder) {
        super(uUID, ePackageID, string);
        this.featureValues = valueHolder;
        this.featureCount = (short)n;
    }

    @Override
    public int getFeatureNumber() {
        return this.featureValues.getObjectLength();
    }

    @Override
    public Object getFeatureValue(int n) {
        return this.featureValues.getValue(n);
    }

    @Override
    public Object setFeatureValue(int n, Object object, boolean bl) {
        if (a.c && LOG.isWarnEnabled()) {
            this.checkSize(object);
        }
        if (bl) {
            this.keepOriginalValue(n);
        }
        Object object2 = this.featureValues.getValue(n);
        this.featureValues.setValue(n, object);
        return object2;
    }

    private void checkSize(Object object) {
        Collection collection;
        if (object instanceof String) {
            String string = (String)object;
            if (string.length() > a.b) {
                LOG.warn("inserting large String (length={}) into EObjectDataImpl (ID={})", (Object)string.length(), (Object)this.id);
            }
        } else if (object instanceof Collection && !(collection = (Collection)object).isEmpty() && collection.iterator().next() instanceof String) {
            for (Object e : collection) {
                this.checkSize(e);
            }
        }
    }

    private void keepOriginalValue(int n) {
        FeatureIDandValue featureIDandValue;
        if (this.originalValues == null) {
            this.originalValues = this.createValueStore();
        }
        if ((featureIDandValue = this.findOriginalValue(n)) == null) {
            List list;
            Object object = this.featureValues.getValue(n);
            FeatureIDandValue featureIDandValue2 = new FeatureIDandValue(n, object);
            List list2 = list = featureIDandValue2 == null ? null : featureIDandValue2.value;
            if (list instanceof List) {
                ArrayList arrayList = new ArrayList(list);
                list = Collections.unmodifiableList(arrayList);
            }
            featureIDandValue = new FeatureIDandValue(n, list);
            this.originalValues.add(featureIDandValue);
        }
    }

    private FeatureIDandValue findOriginalValue(int n) {
        for (FeatureIDandValue featureIDandValue : this.originalValues) {
            if (featureIDandValue.featureID != n) continue;
            return featureIDandValue;
        }
        return null;
    }

    private List<FeatureIDandValue> createValueStore() {
        return new LinkedList<FeatureIDandValue>();
    }

    @Override
    public int getFeatureCount() {
        return this.featureCount;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("%.7s", this.id));
        stringBuilder.append('[');
        int n = 0;
        while (n < this.featureCount) {
            stringBuilder.append(n);
            stringBuilder.append('=');
            Object object = this.featureValues.getValue(n);
            stringBuilder.append(object);
            stringBuilder.append(',');
            ++n;
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.getEClassName() == null ? 0 : this.getEClassName().hashCode());
        n = 31 * n + (this.getEPackageID() == null ? 0 : this.getEPackageID().hashCode());
        n = 31 * n + (this.featureValues == null ? 0 : this.featureValues.hashCode());
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof EObjectDataImpl)) {
            return false;
        }
        EObjectDataImpl eObjectDataImpl = (EObjectDataImpl)object;
        if (this.getEPackageID() == null ? eObjectDataImpl.getEPackageID() != null : !this.getEPackageID().equals(eObjectDataImpl.getEPackageID())) {
            return false;
        }
        if (this.getEClassName() == null ? eObjectDataImpl.getEClassName() != null : !this.getEClassName().equals(eObjectDataImpl.getEClassName())) {
            return false;
        }
        return !(this.featureValues == null ? eObjectDataImpl.featureValues != null : !this.featureValues.equals(eObjectDataImpl.featureValues));
    }

    @Override
    public EObjectDelta computeDelta() {
        EObjectDelta eObjectDelta = super.computeDelta();
        if (this.originalValues != null) {
            for (FeatureIDandValue featureIDandValue : this.originalValues) {
                Object object = this.featureValues.getValue(featureIDandValue.featureID);
                EFeatureDelta eFeatureDelta = new EFeatureDelta(featureIDandValue.featureID, object);
                eObjectDelta.addFeatureDelta(eFeatureDelta);
            }
        }
        return eObjectDelta;
    }

    public EObjectDelta computeDelta(EObjectDataImpl eObjectDataImpl) {
        int n;
        EObjectDelta eObjectDelta = super.computeDelta(eObjectDataImpl);
        int[] nArray = this.featureValues.getSetFeatureIDs();
        int[] nArray2 = eObjectDataImpl.featureValues.getSetFeatureIDs();
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        Object object = nArray;
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            n = object[n3];
            treeSet.add(n);
            ++n3;
        }
        object = nArray2;
        n2 = nArray2.length;
        n3 = 0;
        while (n3 < n2) {
            n = object[n3];
            treeSet.add(n);
            ++n3;
        }
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            n = (Integer)iterator.next();
            Object object2 = this.featureValues.getValue(n);
            object = eObjectDataImpl.featureValues.getValue(n);
            if (object2 == null && object == null) continue;
            if (object2 != null && object == null) {
                eObjectDelta.addFeatureDelta(new EFeatureDelta(n, null));
                continue;
            }
            if (object2 == null && object != null) {
                eObjectDelta.addFeatureDelta(new EFeatureDelta(n, object));
                continue;
            }
            if (object2.equals(object)) continue;
            eObjectDelta.addFeatureDelta(new EFeatureDelta(n, object));
        }
        return eObjectDelta;
    }

    @Override
    public void applyDelta(EObjectDelta eObjectDelta, boolean bl) {
        super.applyDelta(eObjectDelta, bl);
        for (EFeatureDelta eFeatureDelta : eObjectDelta.getFeatureDeltas()) {
            int n = eFeatureDelta.getFeatureID();
            Object object = eFeatureDelta.getNewValue();
            this.setFeatureValue(n, object, true);
        }
    }

    @Override
    public void reset() {
        super.reset();
        if (this.originalValues != null) {
            for (FeatureIDandValue featureIDandValue : this.originalValues) {
                Object object = featureIDandValue.value;
                if (object instanceof List) {
                    List list = this.createList((List)object);
                    object = list;
                }
                this.featureValues.setValue(featureIDandValue.featureID, object);
            }
            this.originalValues = null;
        }
    }

    @Override
    public boolean isClean() {
        return this.originalValues == null ? super.isClean() : false;
    }

    public List createList(Collection<?> collection) {
        if (collection != null) {
            return new ArrayList(collection);
        }
        return new ArrayList();
    }

    @Override
    public Object getOriginalValue(int n) {
        FeatureIDandValue featureIDandValue = this.findOriginalValue(n);
        if (featureIDandValue != null) {
            return featureIDandValue.value;
        }
        return this.featureValues.getValue(n);
    }

    @Override
    public void loopOverRefs(EObjectData.RefProcessor refProcessor) {
        int[] nArray;
        super.loopOverRefs(refProcessor);
        int[] nArray2 = nArray = this.featureValues.getSetFeatureIDs();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray2[n2];
            Object object = this.featureValues.getValue(n3);
            if (object instanceof Ref) {
                refProcessor.processRef((Ref)object, n3);
            } else if (object instanceof List) {
                List list = (List)object;
                for (Object e : list) {
                    if (!(e instanceof Ref)) break;
                    refProcessor.processRef((Ref)e, n3);
                }
            }
            ++n2;
        }
    }

    @Override
    public void clearOriginalValues() {
        super.clearOriginalValues();
        this.originalValues = null;
    }

    public ValueHolder getValueHolder() {
        return this.featureValues;
    }

    public static class FeatureIDandValue {
        final int featureID;
        Object value;

        public FeatureIDandValue(int n, Object object) {
            this.featureID = n;
            this.value = object;
        }
    }
}

