/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.esi.core.msg.info.impl;

import com.nomagic.esi.core.msg.info.Ref;
import com.nomagic.esi.core.msg.info.impl.EFeatureDelta;
import com.nomagic.esi.core.msg.info.impl.EObjectDelta;
import com.nomagic.esi.core.msg.info.impl.EPackageID;
import com.nomagic.esi.helper.a.b;
import java.util.Collection;
import java.util.List;
import java.util.UUID;

public abstract class EObjectData {
    static final Ref REF_UNSET = new Ref(UUID.randomUUID(), UUID.randomUUID());
    static final int FEATURE_ID_UNSET = Integer.MIN_VALUE;
    protected UUID id;
    private final String eClassName;
    private EPackageID ePackageID;
    private Ref container;
    private int containerFeatureID = Integer.MIN_VALUE;
    private transient Ref originalContainer = REF_UNSET;
    private transient int originalContainerFeatureID = Integer.MIN_VALUE;
    private int pkgIDFor18_3;

    EObjectData(UUID uUID, int n, String string) {
        b.a((String)"id", (Object)uUID);
        b.a((String)"eClassName", (Object)string);
        this.id = uUID;
        this.eClassName = string;
        this.pkgIDFor18_3 = n;
    }

    public int getPkgIDFor18_3() {
        return this.pkgIDFor18_3;
    }

    EObjectData(UUID uUID, EPackageID ePackageID, String string) {
        b.a((String)"id", (Object)uUID);
        b.a((String)"ePackageID", (Object)ePackageID);
        b.a((String)"eClassName", (Object)string);
        this.id = uUID;
        this.eClassName = string;
        this.ePackageID = ePackageID;
    }

    public UUID getID() {
        return this.id;
    }

    public String getEClassName() {
        return this.eClassName;
    }

    public EPackageID getEPackageID() {
        return this.ePackageID;
    }

    public void setEPackageID(EPackageID ePackageID) {
        this.ePackageID = ePackageID;
    }

    public Ref getContainer() {
        return this.container;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setContainer(Ref ref, int n, boolean bl) {
        if (bl) {
            if (this.originalContainer == REF_UNSET) {
                this.originalContainer = this.container;
            }
            if (this.originalContainerFeatureID == Integer.MIN_VALUE) {
                this.originalContainerFeatureID = this.containerFeatureID;
            }
        }
        if (this.containerFeatureID >= 0 && n != this.containerFeatureID) {
            this.setFeatureValue(this.containerFeatureID, null, bl);
        }
        this.container = ref;
        this.containerFeatureID = ref != null ? n : Integer.MIN_VALUE;
        if (n < 0) return;
        this.setFeatureValue(n, ref, bl);
    }

    public void unsetContainer(boolean bl) {
        this.setContainer(null, Integer.MIN_VALUE, bl);
    }

    public int getContainerFeatureID() {
        return this.containerFeatureID;
    }

    public EObjectDelta computeDelta() {
        EObjectDelta eObjectDelta = new EObjectDelta(this.id);
        if (this.originalContainer != REF_UNSET) {
            EFeatureDelta eFeatureDelta = new EFeatureDelta(this.containerFeatureID, this.container);
            eObjectDelta.setContainerDelta(eFeatureDelta);
        }
        return eObjectDelta;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected EObjectDelta computeDelta(EObjectData eObjectData) {
        if (!this.eClassName.equals(eObjectData.eClassName)) throw new IllegalArgumentException("eClasses/ePackages of EObjectDatas being compared, do not match");
        if (!this.ePackageID.equals(eObjectData.ePackageID)) {
            throw new IllegalArgumentException("eClasses/ePackages of EObjectDatas being compared, do not match");
        }
        EObjectDelta eObjectDelta = new EObjectDelta(this.id);
        if (this.container == null) {
            if (eObjectData.container == null) return eObjectDelta;
        }
        if (this.container != null && eObjectData.container == null) {
            EFeatureDelta eFeatureDelta = new EFeatureDelta(this.containerFeatureID, null);
            eObjectDelta.setContainerDelta(eFeatureDelta);
            return eObjectDelta;
        }
        if (this.container == null && eObjectData.container != null) {
            EFeatureDelta eFeatureDelta = new EFeatureDelta(eObjectData.containerFeatureID, eObjectData.container);
            eObjectDelta.setContainerDelta(eFeatureDelta);
            return eObjectDelta;
        }
        if (this.container.equals(eObjectData.container)) return eObjectDelta;
        EFeatureDelta eFeatureDelta = new EFeatureDelta(eObjectData.containerFeatureID, eObjectData.container);
        eObjectDelta.setContainerDelta(eFeatureDelta);
        return eObjectDelta;
    }

    protected void applyDelta(EObjectDelta eObjectDelta, boolean bl) {
        EFeatureDelta eFeatureDelta = eObjectDelta.getContainerDelta();
        if (eFeatureDelta != null) {
            Ref ref = (Ref)eFeatureDelta.getNewValue();
            int n = eFeatureDelta.getFeatureID();
            this.setContainer(ref, n, bl);
        }
    }

    public Ref getOriginalContainer() {
        if (this.originalContainer == REF_UNSET) {
            return this.container;
        }
        return this.originalContainer;
    }

    public void reset() {
        if (this.originalContainer != REF_UNSET) {
            this.container = this.originalContainer;
            this.originalContainer = REF_UNSET;
        }
        if (this.originalContainerFeatureID != Integer.MIN_VALUE) {
            this.containerFeatureID = this.originalContainerFeatureID;
            this.originalContainerFeatureID = Integer.MIN_VALUE;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isClean() {
        return this.originalContainer == REF_UNSET && this.originalContainerFeatureID == Integer.MIN_VALUE;
    }

    public void clearOriginalValues() {
        this.originalContainer = REF_UNSET;
        this.originalContainerFeatureID = Integer.MIN_VALUE;
    }

    public void loopOverRefs(RefProcessor refProcessor) {
        if (this.container != null) {
            refProcessor.processRef(this.container, this.containerFeatureID);
        }
    }

    public int hashCode() {
        int n = 1;
        int n2 = 31 * n;
        int n3 = this.container == null ? 0 : this.container.hashCode();
        n = n2 + n3;
        n = 31 * n + this.containerFeatureID;
        int n4 = 31 * n;
        int n5 = this.id == null ? 0 : this.id.hashCode();
        n = n4 + n5;
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof EObjectData)) {
            return false;
        }
        EObjectData eObjectData = (EObjectData)object;
        if (this.container == null ? eObjectData.container != null : !this.container.equals(eObjectData.container)) {
            return false;
        }
        if (this.containerFeatureID != eObjectData.containerFeatureID) {
            return false;
        }
        return !(this.id == null ? eObjectData.id != null : !this.id.equals(eObjectData.id));
    }

    public void setOwner(Object object) {
    }

    public Object getOwner() {
        return null;
    }

    public abstract Object getFeatureValue(int var1);

    public abstract Object setFeatureValue(int var1, Object var2, boolean var3);

    public abstract int getFeatureCount();

    public abstract Object getOriginalValue(int var1);

    public abstract List<?> createList(Collection<?> var1);

    public abstract int getFeatureNumber();

    public static interface RefProcessor {
        public void processRef(Ref var1, int var2);
    }
}

