/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.esi.core.msg.info.impl;

import com.nomagic.esi.api.CommitType;
import com.nomagic.esi.api.ResourceRef;
import com.nomagic.esi.api.info.AuthorInfo;
import com.nomagic.esi.api.info.CommitInfo;
import com.nomagic.esi.api.messages.CommonAncestorFindingAlgorithm;
import com.nomagic.esi.api.messages.info.MergeInfo;
import com.nomagic.esi.common.ResBranchRev;
import com.nomagic.esi.core.msg.info.CommonAncestorAlgorithmInfo;
import com.nomagic.esi.core.msg.info.ResourceRefImpl;
import com.nomagic.esi.core.msg.info.impl.RevisionTypeAndInfo;
import com.nomagic.esi.helper.a.b;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.UUID;

public class CommitInfoImpl
implements CommitInfo {
    private final RevisionTypeAndInfo revisionTypeAndInfo;
    private final String description;
    private final AuthorInfo author;
    private final List<UUID> rootObjectIDs;
    private final List<ResourceRefImpl> dependencies;
    private final long commitDate;
    private final List<UUID> ePackageIDs;
    private transient int hashCode;

    public CommitInfoImpl(ResBranchRev resBranchRev, String string, AuthorInfo authorInfo, long l, List<UUID> list, List<ResourceRefImpl> list2, List<UUID> list3, long l2, long l3, long l4) {
        if (l4 > 0L) {
            this.revisionTypeAndInfo = RevisionTypeAndInfo.getCommitAsLatestCommitType(resBranchRev.resourceID, resBranchRev.branchID, resBranchRev.revision, l2, l4);
        } else if (l3 > 0L) {
            UUID uUID = UUID.randomUUID();
            CommonAncestorAlgorithmInfo commonAncestorAlgorithmInfo = new CommonAncestorAlgorithmInfo(CommonAncestorFindingAlgorithm.A0_OLD_STYLE_LOWEST_COMMON_ANCESTOR, false);
            this.revisionTypeAndInfo = RevisionTypeAndInfo.getMergedCommitType(resBranchRev.resourceID, resBranchRev.branchID, resBranchRev.revision, l2, uUID, l3, commonAncestorAlgorithmInfo);
        } else {
            this.revisionTypeAndInfo = RevisionTypeAndInfo.getNormalCommitType(resBranchRev.resourceID, resBranchRev.branchID, resBranchRev.revision, l2);
        }
        this.description = string;
        this.author = authorInfo;
        this.commitDate = l;
        this.rootObjectIDs = list != null ? new ArrayList<UUID>(list) : new ArrayList();
        this.dependencies = list2 != null ? new ArrayList<ResourceRefImpl>(list2) : new ArrayList();
        this.ePackageIDs = list3 != null ? new ArrayList<UUID>(list3) : new ArrayList();
    }

    public CommitInfoImpl(RevisionTypeAndInfo revisionTypeAndInfo, String string, AuthorInfo authorInfo, long l, List<UUID> list, List<ResourceRefImpl> list2, List<UUID> list3) {
        b.a((String)"revision info", (Object)revisionTypeAndInfo);
        this.revisionTypeAndInfo = revisionTypeAndInfo;
        this.description = string;
        this.author = authorInfo;
        this.commitDate = l;
        this.rootObjectIDs = list != null ? new ArrayList<UUID>(list) : new ArrayList();
        this.dependencies = list2 != null ? new ArrayList<ResourceRefImpl>(list2) : new ArrayList();
        this.ePackageIDs = list3 != null ? new ArrayList<UUID>(list3) : new ArrayList();
    }

    public Date getCreatedDate() {
        return new Date(this.commitDate);
    }

    public long getCommitDate() {
        return this.commitDate;
    }

    public long getID() {
        return this.revisionTypeAndInfo.getCommitRevision();
    }

    public String getDescription() {
        return this.description;
    }

    public AuthorInfo getAuthor() {
        return this.author;
    }

    public UUID getResourceID() {
        return this.revisionTypeAndInfo.getResourceID();
    }

    public UUID getBranchID() {
        return this.revisionTypeAndInfo.getBranchID();
    }

    public List<UUID> getRootObjectIDs() {
        return Collections.unmodifiableList(this.rootObjectIDs);
    }

    public List<ResourceRef> getDependencies() {
        if (this.dependencies != null) {
            ArrayList<ResourceRefImpl> arrayList = new ArrayList<ResourceRefImpl>(this.dependencies);
            return Collections.unmodifiableList(arrayList);
        }
        return Collections.emptyList();
    }

    public List<ResourceRefImpl> getDependencyImpls() {
        if (this.dependencies != null) {
            return this.dependencies;
        }
        return Collections.emptyList();
    }

    public long getDirectParent() {
        return this.revisionTypeAndInfo.getDirectParent();
    }

    public long getPickedRevision() {
        return this.revisionTypeAndInfo.getCommitAsLatestRevision();
    }

    public List<UUID> getEPackageIDs() {
        return this.ePackageIDs;
    }

    public MergeInfo getMergeInfo() {
        return this.revisionTypeAndInfo.getMergeInfo();
    }

    public CommitType getCommitType() {
        return this.revisionTypeAndInfo.getCommitType();
    }

    public RevisionTypeAndInfo getRevisionTypeAndInfo() {
        return this.revisionTypeAndInfo;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int n = 1;
            n = 31 * n + (this.revisionTypeAndInfo == null ? 0 : this.revisionTypeAndInfo.hashCode());
            n = 31 * n + (this.author == null ? 0 : this.author.hashCode());
            n = 31 * n + (int)(this.commitDate ^ this.commitDate >>> 32);
            n = 31 * n + (this.dependencies == null ? 0 : this.dependencies.hashCode());
            n = 31 * n + (this.description == null ? 0 : this.description.hashCode());
            n = 31 * n + (this.rootObjectIDs == null ? 0 : this.rootObjectIDs.hashCode());
            this.hashCode = n = 31 * n + (this.ePackageIDs == null ? 0 : this.ePackageIDs.hashCode());
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof CommitInfoImpl)) {
            return false;
        }
        CommitInfoImpl commitInfoImpl = (CommitInfoImpl)object;
        if (this.revisionTypeAndInfo == null ? commitInfoImpl.revisionTypeAndInfo != null : !this.revisionTypeAndInfo.equals(commitInfoImpl.revisionTypeAndInfo)) {
            return false;
        }
        if (this.author == null ? commitInfoImpl.author != null : !this.author.equals(commitInfoImpl.author)) {
            return false;
        }
        if (this.description == null ? commitInfoImpl.description != null : !this.description.equals(commitInfoImpl.description)) {
            return false;
        }
        if (this.commitDate != commitInfoImpl.commitDate) {
            return false;
        }
        if (this.dependencies == null ? commitInfoImpl.dependencies != null : !this.dependencies.equals(commitInfoImpl.dependencies)) {
            return false;
        }
        if (this.rootObjectIDs == null ? commitInfoImpl.rootObjectIDs != null : !this.rootObjectIDs.equals(commitInfoImpl.rootObjectIDs)) {
            return false;
        }
        return !(this.ePackageIDs == null ? commitInfoImpl.ePackageIDs != null : !this.ePackageIDs.equals(commitInfoImpl.ePackageIDs));
    }

    public String toString() {
        return String.format("commit-information %s, author=%s, description=%s, commit date=%s, dependencies=%s, root ids=%s, ePackage ids=%s", this.revisionTypeAndInfo, this.author, this.description, new Date(this.commitDate), this.dependencies, this.rootObjectIDs, this.ePackageIDs);
    }
}

