/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.esi.core.msg.info;

import com.nomagic.esi.api.EsiObject;
import com.nomagic.esi.api.constants.ResourceConstants;
import com.nomagic.esi.common.a.x;
import com.nomagic.esi.helper.a.b;
import java.util.UUID;

public class Ref
implements x {
    private UUID resourceID;
    private final UUID objectID;
    private transient EsiObject target;
    private transient int strongRefUseCount;

    public Ref(UUID uUID, UUID uUID2) {
        b.a((String)"resourceID", (Object)uUID);
        b.a((String)"referencedElementId", (Object)uUID2);
        this.resourceID = uUID;
        this.objectID = uUID2;
    }

    public UUID getResourceID() {
        return this.resourceID;
    }

    public UUID getObjectID() {
        return this.objectID;
    }

    public int hashCode() {
        int n = 1;
        int n2 = 31 * n;
        int n3 = this.objectID == null ? 0 : this.objectID.hashCode();
        n = n2 + n3;
        int n4 = 31 * n;
        int n5 = this.resourceID == null ? 0 : this.resourceID.hashCode();
        n = n4 + n5;
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof Ref)) {
            return false;
        }
        Ref ref = (Ref)object;
        if (this.objectID == null ? ref.objectID != null : !this.objectID.equals(ref.objectID)) {
            return false;
        }
        return !(this.resourceID == null ? ref.resourceID != null : !this.resourceID.equals(ref.resourceID));
    }

    public String toString() {
        String string = this.resourceID.equals(ResourceConstants.THIS_RESOURCE) ? "THIS" : (this.resourceID.equals(ResourceConstants.RESOURCE_UNSPECIFIED) ? "UNSPC" : this.resourceID.toString());
        return String.format("(res=%s:obj=%s)", string, this.objectID);
    }

    public EsiObject getTarget() {
        return this.target;
    }

    public void setTarget(EsiObject esiObject) {
        if (!esiObject.esiID().equals(this.objectID)) {
            throw new IllegalArgumentException("target's own object ID is different from Ref's object ID");
        }
        this.target = esiObject;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unrefTarget() {
        if (this.target == null) return;
        if (this.target.esiState().isFreeOrNew()) return;
        this.target = null;
    }

    public void setResourceID(UUID uUID) {
        this.resourceID = uUID;
    }

    public void incrStrongRefUseCount() {
        ++this.strongRefUseCount;
    }

    public void decrStrongRefUseCount() {
        --this.strongRefUseCount;
    }

    public boolean isUsedAsStrongRef() {
        if (this.strongRefUseCount > 0) {
            return true;
        }
        return false;
    }
}

