/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.esi.client.core.a;

import akka.actor.ActorRef;
import akka.actor.Status;
import com.nomagic.esi.api.AccessManager;
import com.nomagic.esi.api.CacheManager;
import com.nomagic.esi.api.ConnectionEvent;
import com.nomagic.esi.api.ConnectionListener;
import com.nomagic.esi.api.EsiResourceSet;
import com.nomagic.esi.api.RawEsiCommander;
import com.nomagic.esi.api.RawSession;
import com.nomagic.esi.api.RepositoryManager;
import com.nomagic.esi.api.Session;
import com.nomagic.esi.api.SessionConfigurator;
import com.nomagic.esi.api.SessionState;
import com.nomagic.esi.api.SslConfigManager;
import com.nomagic.esi.api.UserManager;
import com.nomagic.esi.api.VersionControlManager;
import com.nomagic.esi.api.config.SslClientConfig;
import com.nomagic.esi.api.constants.LicenseMode;
import com.nomagic.esi.api.debug.DebugStats;
import com.nomagic.esi.api.health.ClusterHealth;
import com.nomagic.esi.api.info.HostInfo;
import com.nomagic.esi.api.license.LicenseManager;
import com.nomagic.esi.api.locking.LockManager;
import com.nomagic.esi.api.messages.exceptions.ClosedSessionException;
import com.nomagic.esi.api.messages.exceptions.CommunicationException;
import com.nomagic.esi.api.messages.exceptions.EsiException;
import com.nomagic.esi.api.messages.exceptions.IncompatibleVersionException;
import com.nomagic.esi.api.messages.exceptions.LoginException;
import com.nomagic.esi.api.messages.exceptions.SessionException;
import com.nomagic.esi.api.messages.exceptions.UnknownMessageException;
import com.nomagic.esi.api.preload.PreloadingPolicy;
import com.nomagic.esi.client.core.EsiImpl;
import com.nomagic.esi.client.core.a.c.d;
import com.nomagic.esi.client.core.a.c.h;
import com.nomagic.esi.client.core.a.c.l;
import com.nomagic.esi.client.core.a.p;
import com.nomagic.esi.client.core.a.q;
import com.nomagic.esi.client.core.a.s;
import com.nomagic.esi.client.core.a.t;
import com.nomagic.esi.client.core.a.u;
import com.nomagic.esi.client.core.a.x;
import com.nomagic.esi.client.core.a.y;
import com.nomagic.esi.common.a.A;
import com.nomagic.esi.common.a.C;
import com.nomagic.esi.common.a.F;
import com.nomagic.esi.common.a.G;
import com.nomagic.esi.core.msg.ActiveHostsMsg;
import com.nomagic.esi.core.msg.ActiveHostsReply;
import com.nomagic.esi.core.msg.AuthenticationRequest;
import com.nomagic.esi.core.msg.BaseLoginMessage;
import com.nomagic.esi.core.msg.Failure;
import com.nomagic.esi.core.msg.FirstMsg;
import com.nomagic.esi.core.msg.FirstReply;
import com.nomagic.esi.core.msg.GetLogContentMsg;
import com.nomagic.esi.core.msg.GetLogContentReply;
import com.nomagic.esi.core.msg.GetTokenUsernameMsg;
import com.nomagic.esi.core.msg.GetTokenUsernameReply;
import com.nomagic.esi.core.msg.GetVersionInfoMsg;
import com.nomagic.esi.core.msg.GetVersionInfoReply;
import com.nomagic.esi.core.msg.LastMsg;
import com.nomagic.esi.core.msg.LoginAppMsg;
import com.nomagic.esi.core.msg.LoginReply;
import com.nomagic.esi.core.msg.LoginTokenMsg;
import com.nomagic.esi.core.msg.LoginTokenReply;
import com.nomagic.esi.core.msg.NegotiateVersionReply;
import com.nomagic.esi.core.msg.NegotiateVersionRequest;
import com.nomagic.esi.core.msg.RegisterSenderAsClusterListenerMsg;
import com.nomagic.esi.core.msg.VersionInfoMsg;
import com.nomagic.esi.core.msg.VersionInfoReply;
import com.nomagic.esi.core.msg.health.NodeHealthReportReply;
import com.nomagic.esi.core.msg.health.NodeHealthReportRequest;
import com.nomagic.esi.core.msg.preload.PreloadingPolicyImpl;
import com.nomagic.esi.emf.EsiResourceSetImpl;
import com.nomagic.esi.emf.a.c.i;
import com.nomagic.esi.helper.a.g;
import com.nomagic.esi.net.INetworking;
import com.nomagic.esi.net.Networking;
import com.nomagic.esi.net.a.g;
import com.nomagic.esi.net.a.m;
import com.typesafe.config.Config;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import org.eclipse.emf.common.util.EList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class w
implements Session,
DebugStats,
RawSession {
    public static final String a = "/user/esi/LoginActor";
    public static final String b = "com.nomagic.esi.core.msg.VersionInfoMsg";
    private static final int c = 500;
    private final Map<Object, Object> d;
    private final Config e = EsiImpl.getInstance().getConfig();
    private static final String f = "/user/esi/FirstContactActor";
    private static final Logger g = LoggerFactory.getLogger(w.class);
    private volatile Set<ConnectionListener> h = Collections.newSetFromMap(new ConcurrentHashMap());
    private volatile Set<x> i = new LinkedHashSet<x>();
    private LicenseMode j;
    private UUID k;
    private String l;
    private String m;
    private int n;
    private volatile SessionState o;
    private PreloadingPolicy p;
    private KeyStore q;
    private com.nomagic.esi.net.a.g r;
    private p s;
    private UUID t;
    private RawEsiCommander u;
    private volatile boolean v;
    private final Map<Class<?>, Object> w;
    private boolean x;
    private Set<String> y;

    public w(LicenseMode licenseMode, UUID uUID) {
        this.a(SessionState.OFFLINE);
        this.w = new HashMap();
        this.d = new HashMap<Object, Object>();
        this.t = uUID;
        this.j = licenseMode;
    }

    private int j() {
        return EsiImpl.getInstance().getNetworking().getPort();
    }

    public boolean open(String string, String string2, String string3) {
        return this.open(string, string2, string3, null);
    }

    public boolean open(SessionConfigurator sessionConfigurator) {
        String string;
        AuthenticationRequest authenticationRequest;
        this.q = sessionConfigurator.getKeystore();
        this.j = sessionConfigurator.getMode();
        this.x = sessionConfigurator.isTls();
        m m2 = new m(sessionConfigurator.getHost(), sessionConfigurator.getPort());
        String string2 = m2.j().getHostAddress();
        switch (sessionConfigurator.getMechanism()) {
            case GENERIC: {
                authenticationRequest = new AuthenticationRequest(sessionConfigurator.getScheme(), sessionConfigurator.getUsername(), sessionConfigurator.getPassword());
                string = null;
                break;
            }
            case TOKEN: {
                this.e(sessionConfigurator.getToken());
                authenticationRequest = new LoginTokenMsg(sessionConfigurator.getToken(), this.j, string2);
                string = null;
                break;
            }
            case USER_PASSWORD: {
                this.a(sessionConfigurator.getUsername(), sessionConfigurator.getPassword());
                authenticationRequest = this.a(sessionConfigurator.getUsername(), sessionConfigurator.getPassword(), string2);
                string = sessionConfigurator.getUsername();
                break;
            }
            default: {
                throw new RuntimeException("Invalid authentication mechanism: " + sessionConfigurator.getMechanism());
            }
        }
        this.a(m2, (BaseLoginMessage)authenticationRequest, string);
        return true;
    }

    public boolean open(String string, String string2) {
        return this.open(string, string2, (SslClientConfig)null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private LoginReply a(m m2, BaseLoginMessage baseLoginMessage) {
        Object object;
        INetworking iNetworking = EsiImpl.getInstance().getNetworking();
        if (iNetworking == null) {
            throw new IllegalStateException("Unable to get INetworking service.");
        }
        int n2 = 1;
        int n3 = this.e.getInt("esi.client.login-retry-backoff-in-ms");
        if (n3 <= 0) {
            n3 = 500;
        }
        String string = String.format("Unable to connect to %s. Please make sure you use the correct ip:port and the ssl/plain option to connect to the TWC server.", m2);
        Object object2 = null;
        while (true) {
            object = null;
            try {
                object = iNetworking.connect(m2, this.x, this.q);
                ActorRef actorRef = object.c(a);
                this.a((com.nomagic.esi.net.a.g)object, actorRef, F.c((boolean)true));
                if (actorRef instanceof com.nomagic.esi.net.a.i) {
                    ((com.nomagic.esi.net.a.i)actorRef).k();
                }
                long l2 = this.e.getLong("esi.client.login-timeout");
                object2 = com.nomagic.esi.net.a.b.b.a((ActorRef)actorRef, (Object)baseLoginMessage, (long)l2);
            }
            catch (ConnectException | UnknownHostException | TimeoutException exception) {
                if (n2 > 0 && exception instanceof TimeoutException) {
                    --n2;
                    com.nomagic.esi.common.a.C.a((long)n3);
                    continue;
                }
                throw new LoginException(string, (Throwable)exception);
            }
            catch (Exception exception) {
                if (exception instanceof UnknownMessageException && b.equals(exception.getMessage())) {
                    throw new IncompatibleVersionException("The client version is incompatible with the TWCloud server version.", "unknown", "unknown", "unknown", "unknown");
                }
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new LoginException(string, (Throwable)exception);
            }
            finally {
                boolean bl;
                if (object == null) continue;
                if (object2 instanceof LoginReply && (bl = com.nomagic.esi.client.core.a.w.a(baseLoginMessage, (LoginReply)object2))) {
                    this.r = object;
                    break;
                }
                object.close();
                continue;
            }
            break;
        }
        if (object2 instanceof Status.Failure) {
            object = ((Status.Failure)object2).cause();
            throw new LoginException(string, (Throwable)object);
        }
        if (object2 instanceof Failure) {
            object = ((Failure)object2).getCause();
            throw new LoginException(string, (Throwable)object);
        }
        if (!(object2 instanceof LoginReply)) {
            throw new LoginException("Reply message has unexpected type: " + object2.getClass() + ".");
        }
        object = (LoginReply)object2;
        if (!object.isSuccess()) {
            throw object.getException();
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean a(BaseLoginMessage baseLoginMessage, LoginReply loginReply) {
        Object object;
        if (!loginReply.isSuccess()) {
            return false;
        }
        if (loginReply.getHosts().size() != 1) {
            return false;
        }
        String string = (String)loginReply.getHosts().get(0);
        String string2 = baseLoginMessage.getServerIP();
        if (string2.equals(string)) {
            return true;
        }
        boolean bl = false;
        boolean bl2 = false;
        try {
            object = InetAddress.getByName(string2);
            InetAddress inetAddress = InetAddress.getByName(string);
            bl = object != null && (((InetAddress)object).isAnyLocalAddress() || ((InetAddress)object).isLoopbackAddress());
            bl2 = inetAddress != null && (inetAddress.isAnyLocalAddress() || inetAddress.isLoopbackAddress());
        }
        catch (Exception exception) {
            g.warn(exception.getMessage(), (Throwable)exception);
        }
        if (bl && bl2) {
            return true;
        }
        object = com.nomagic.esi.common.a.A.k();
        boolean bl3 = false;
        boolean bl4 = false;
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            if (string3.equals(string2)) {
                bl3 = true;
                continue;
            }
            if (!string3.equalsIgnoreCase(string)) continue;
            bl4 = true;
        }
        return bl3 && bl4;
    }

    private LoginAppMsg a(String string, String string2, String string3) {
        String string4 = com.nomagic.esi.common.a.s.e((String)string);
        String string5 = com.nomagic.esi.common.a.s.e((String)string2);
        LoginAppMsg loginAppMsg = new LoginAppMsg(string4, string5, this.j, string3);
        return loginAppMsg;
    }

    private void a(m m2, BaseLoginMessage baseLoginMessage, String string) {
        LoginReply loginReply = this.a(m2, baseLoginMessage);
        if (g.isDebugEnabled()) {
            g.debug("Available host: {}", (Object)loginReply.getHosts());
        }
        if (!loginReply.isSuccess()) {
            throw loginReply.getException();
        }
        UUID uUID = loginReply.getClusterId();
        List list = loginReply.getHosts();
        long l2 = loginReply.getReconnectTimeout();
        long l3 = loginReply.getRetryWaitingTime();
        com.nomagic.esi.client.core.a.q.j().a(uUID, list, l2, l3);
        this.a(new p(uUID, list, l2, l3));
        if (loginReply instanceof LoginTokenReply) {
            string = ((LoginTokenReply)loginReply).getUsername();
        } else {
            if (!(baseLoginMessage instanceof LoginAppMsg)) {
                throw new RuntimeException(String.format("Unmatch request %s and response %s", baseLoginMessage.getClass().toString(), loginReply.getClass().getName()));
            }
        }
        this.a(baseLoginMessage, loginReply, string, m2.l());
    }

    private void a(String string, String string2) {
        if (g.isDebugEnabled()) {
            g.debug(String.format("Login Info : user name=%s", string));
        }
        this.c(string);
        this.d(string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void c(String string) {
        if (string != null && !string.isEmpty()) {
            return;
        }
        throw new IllegalArgumentException("Invalid username (" + string + ").");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void d(String string) {
        if (string != null && !string.isEmpty()) {
            return;
        }
        throw new IllegalArgumentException("Invalid password (" + string + ").");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void e(String string) {
        if (string != null && !string.isEmpty()) {
            return;
        }
        throw new IllegalArgumentException("Invalid token (" + string + ").");
    }

    private void a(BaseLoginMessage baseLoginMessage, LoginReply loginReply, String string, int n2) {
        block13: {
            UUID uUID;
            List list;
            UUID uUID2;
            block12: {
                uUID2 = loginReply.getSessionId();
                UUID uUID3 = loginReply.getClusterId();
                list = loginReply.getHosts();
                for (Session object : com.nomagic.esi.client.core.a.y.j().k()) {
                    uUID = object.getClusterID();
                    if (uUID == null || uUID.equals(uUID3)) continue;
                    throw this.a(uUID3, list);
                }
                if (!com.nomagic.esi.client.core.a.w.a(baseLoginMessage, loginReply)) break block12;
                this.a(uUID2, null, string);
                break block13;
            }
            for (String string2 : list) {
                try {
                    if (g.isDebugEnabled()) {
                        g.debug("Try to create session on host : " + string2);
                    }
                    uUID = new m(string2, n2);
                    this.a(uUID2, (m)uUID, string);
                    break;
                }
                catch (Exception exception) {
                    g.error("exception during login", (Throwable)exception);
                }
            }
        }
        if (!this.B()) {
            throw new LoginException("Unable to create session on any hosts.");
        }
        this.k();
        com.nomagic.esi.client.core.a.y.j().a(this);
    }

    private void k() {
        Map<String, String> map = this.getVersionInfo();
        if (map.containsKey("capabilities.txt")) {
            String string = F.d(null);
            NegotiateVersionRequest negotiateVersionRequest = new NegotiateVersionRequest(this.C().l(), string);
            NegotiateVersionReply negotiateVersionReply = (NegotiateVersionReply)this.C().a(negotiateVersionRequest);
            com.nomagic.esi.common.a.c.a a2 = new com.nomagic.esi.common.a.c.a(string, negotiateVersionReply.getCapability());
            try {
                ActorRef actorRef = this.r.c("");
                if (actorRef instanceof com.nomagic.esi.net.a.i) {
                    ((com.nomagic.esi.net.a.i)actorRef).a(a2);
                }
            }
            catch (ConnectException connectException) {
                throw new RuntimeException(connectException);
            }
            this.y = a2.j();
        } else {
            this.y = com.nomagic.esi.common.a.c.a.b.j();
        }
    }

    private IllegalStateException a(UUID uUID, List<String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("cannot create session to cluster ");
        stringBuilder.append(uUID);
        stringBuilder.append('(');
        com.nomagic.esi.helper.a.g.a((StringBuilder)stringBuilder, list);
        stringBuilder.append(')');
        stringBuilder.append(" while other sessions are open to what appears to be a different cluster (");
        com.nomagic.esi.helper.a.g.a((StringBuilder)stringBuilder, com.nomagic.esi.client.core.a.y.j().l());
        stringBuilder.append(").");
        return new IllegalStateException(stringBuilder.toString());
    }

    public EsiResourceSet getResourceSet() {
        return this.getService(EsiResourceSet.class);
    }

    public UUID getSessionID() {
        return this.k;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getConnectedHost() {
        SessionState sessionState = this.getState();
        if (sessionState != SessionState.CLOSED && sessionState != SessionState.OFFLINE) {
            return this.l();
        }
        return null;
    }

    private String l() {
        String string = this.m == null ? null : String.valueOf(this.m) + ":" + this.n;
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String m() {
        SessionState sessionState = this.getState();
        if (sessionState != SessionState.CLOSED && sessionState != SessionState.OFFLINE) {
            return this.m;
        }
        return null;
    }

    public List<HostInfo> getActiveHosts() {
        ActiveHostsMsg activeHostsMsg = new ActiveHostsMsg(this.C().l());
        ActiveHostsReply activeHostsReply = (ActiveHostsReply)this.C().a(activeHostsMsg);
        return activeHostsReply.getHosts();
    }

    public ClusterHealth getClusterHealth() {
        NodeHealthReportRequest nodeHealthReportRequest = new NodeHealthReportRequest(this.C().l());
        NodeHealthReportReply nodeHealthReportReply = (NodeHealthReportReply)this.C().a(nodeHealthReportRequest);
        return new ClusterHealth((List)nodeHealthReportReply.getHealths(), nodeHealthReportReply.getCassandraClusterHealth());
    }

    public InputStream getLogStream(String string) {
        try {
            byte[] byArray = this.f(string);
            return G.a((byte[])byArray);
        }
        catch (IOException iOException) {
            throw new EsiException((Throwable)iOException);
        }
    }

    private byte[] f(String string) {
        String string2 = com.nomagic.esi.common.a.A.j();
        GetLogContentMsg getLogContentMsg = new GetLogContentMsg(this.C().l(), string2, string);
        GetLogContentReply getLogContentReply = (GetLogContentReply)this.C().a(getLogContentMsg);
        return getLogContentReply.getLogContent();
    }

    public Map<String, String> getVersionInfo() {
        GetVersionInfoMsg getVersionInfoMsg = new GetVersionInfoMsg(this.C().l());
        GetVersionInfoReply getVersionInfoReply = (GetVersionInfoReply)this.C().a(getVersionInfoMsg);
        return getVersionInfoReply.getVersionInfo();
    }

    public String getUsername() {
        return this.l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isUsernameMatchesTokenUsername(String string) {
        GetTokenUsernameMsg getTokenUsernameMsg = new GetTokenUsernameMsg(this.k, string);
        try {
            ActorRef actorRef = this.r.c(a);
            GetTokenUsernameReply getTokenUsernameReply = (GetTokenUsernameReply)this.r.a(actorRef, (Object)getTokenUsernameMsg);
            return string.equals(getTokenUsernameReply.getToken()) && this.l.equals(getTokenUsernameReply.getUsername());
        }
        catch (Exception exception) {
            g.error("Error when retrieving token username with session ID : " + this.k, (Throwable)exception);
            return false;
        }
    }

    public RepositoryManager getRepositoryManager() {
        return this.getService(RepositoryManager.class);
    }

    public LicenseManager getLicenseManager() {
        return this.getService(LicenseManager.class);
    }

    public LockManager getLockManager() {
        return this.getService(LockManager.class);
    }

    private void n() {
        EList eList = this.getResourceSet().getResources();
        eList.clear();
        ((EsiResourceSetImpl)this.getResourceSet()).dispose();
    }

    private void a(u.a a2) {
        if (this.k != null) {
            try {
                try {
                    if (a2 != u.a.EXPIRED) {
                        this.o();
                    }
                }
                catch (Exception exception) {
                    g.error("Error when close ClientHandler for session ID : " + this.k, (Throwable)exception);
                    this.C().j();
                }
            }
            finally {
                this.C().j();
            }
        }
    }

    private void o() {
        LastMsg lastMsg = new LastMsg(this.k);
        try {
            this.C().a(lastMsg);
        }
        catch (CommunicationException communicationException) {
            g.error("Unable to connect to client handler for disconnect.");
        }
    }

    private synchronized boolean p() {
        if (this.getState() == SessionState.CLOSED) {
            return false;
        }
        this.a(SessionState.CLOSED);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void q() {
        switch (this.getState()) {
            case DISCONNECTED: {
                this.a(SessionState.RECONNECTING);
            }
            case RECONNECTING: {
                return;
            }
            case OPEN: 
            case CLOSED: 
            case OFFLINE: {
                throw new IllegalStateException("Session cannot be reconnected in state:" + this.getState() + ".");
            }
        }
    }

    private synchronized void r() {
        switch (this.getState()) {
            case OPEN: 
            case RECONNECTING: {
                this.a(SessionState.DISCONNECTED);
                break;
            }
            default: {
                return;
            }
        }
    }

    private synchronized boolean s() {
        if (this.getState() == SessionState.OFFLINE) {
            return false;
        }
        this.a(SessionState.OFFLINE);
        return true;
    }

    public void t() {
        g.info(this + " is expired.");
        this.setAutoReconnectEnabled(false);
        this.b(u.a.EXPIRED);
    }

    public void close() {
        if (g.isDebugEnabled()) {
            g.debug("begin SessionImpl.close() is called for session ID : " + this.k + ", session state is " + this.getState());
        }
        this.b(u.a.CLOSED);
        if (g.isDebugEnabled()) {
            g.debug("end SessionImpl.close() is called for session ID : " + this.k + ", session state is " + this.getState());
        }
    }

    private void b(u.a a2) {
        if (this.p()) {
            com.nomagic.esi.client.core.a.y.j().b(this.k);
            this.e(a2);
            this.c(a2);
        }
    }

    private void c(u.a a2) {
        this.n();
        this.d(a2);
    }

    private void d(u.a a2) {
        this.getService(com.nomagic.esi.stream.a.l.class).a((Exception)new ClosedSessionException());
        this.a(a2);
        if (this.r != null) {
            this.r.close();
        }
        this.r = null;
    }

    public UserManager getUserManager() {
        return this.getService(UserManager.class);
    }

    private synchronized void a(UUID uUID, m m2, String string) {
        if (this.getState() != SessionState.OFFLINE) {
            String string2 = "not allowed: SessionImpl.connect called when session is in state %s; (session cannot be re-opened).";
            throw new EsiException(String.format(string2, this.o.name()));
        }
        try {
            com.nomagic.esi.net.a.g g2 = this.r == null || this.r.l() != null ? EsiImpl.getInstance().getNetworking().connect(m2, this.x, this.q) : this.r;
            this.a(uUID);
            this.l = string;
            this.p = new PreloadingPolicyImpl(1, null, Integer.MAX_VALUE, Integer.MAX_VALUE);
            this.a(g2);
        }
        catch (Exception exception) {
            throw new EsiException((Throwable)exception);
        }
    }

    private void a(com.nomagic.esi.net.a.g g2) throws ConnectException, Exception {
        this.r = g2;
        m m2 = g2.k().n();
        this.m = m2.j().getHostAddress();
        this.n = m2.l();
        ActorRef actorRef = g2.c(f);
        FirstMsg firstMsg = new FirstMsg(this.k);
        try {
            FirstReply firstReply = (FirstReply)g2.a(actorRef, (Object)firstMsg);
            if (actorRef instanceof com.nomagic.esi.net.a.i) {
                ((com.nomagic.esi.net.a.i)actorRef).k();
            }
            String string = firstReply.getClientHandlerPath();
            String string2 = this.h(string);
            this.b(this.r);
            ActorRef actorRef2 = g2.c(string2);
            this.C().a(actorRef2);
            this.getService(l.class).m();
            this.r.a(this::a);
            this.a(SessionState.OPEN);
        }
        catch (SessionException sessionException) {
            g.error(sessionException.getMessage());
            this.r();
            this.v();
            this.r.close();
            this.r = null;
            throw sessionException;
        }
    }

    private void a(com.nomagic.esi.net.a.g g2, ActorRef actorRef, Map<String, String> map) throws ConnectException, Exception {
        VersionInfoMsg versionInfoMsg = new VersionInfoMsg(null, map);
        VersionInfoReply versionInfoReply = (VersionInfoReply)g2.a(actorRef, (Object)versionInfoMsg);
        if (!versionInfoReply.isCompatible()) {
            Map map2 = versionInfoReply.getVersionInfo();
            String string = (String)map2.get("TWCLOUD_VERSION");
            String string2 = (String)map2.get("BUILD_ID");
            String string3 = (String)map2.get("Compatible-ID");
            String string4 = (String)map2.get("protocol_version");
            throw new IncompatibleVersionException(versionInfoReply.getErrorDetail(), string, string2, string3, string4);
        }
    }

    private void g(String string) throws ConnectException, Exception {
        g.info(this + " trying to connect to host " + string);
        m m2 = new m(string, this.n);
        com.nomagic.esi.net.a.g g2 = EsiImpl.getInstance().getNetworking().connect(m2, this.x, this.q);
        this.a(g2);
        boolean bl = this.getState() == SessionState.OPEN;
        boolean bl2 = bl;
        Logger logger = g;
        StringBuilder stringBuilder = new StringBuilder().append(this).append(": reconnecting to ").append(string);
        String string2 = bl2 ? " succeeds" : " does not succeed.";
        logger.info(stringBuilder.append(string2).toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a(g.a a2) {
        if (g.isDebugEnabled()) {
            g.debug(String.format("session ID %s got event %s, session state is %s.%n", this.getSessionID(), a2.k(), this.getState()));
        }
        switch (a2.k()) {
            case EXPIRED: {
                if (SessionState.OFFLINE.equals((Object)this.getState())) return;
                this.t();
                return;
            }
            case DISCONNECTED: {
                if (SessionState.OFFLINE.equals((Object)this.getState())) return;
                this.r();
                this.w();
                if (a2.j().l() == null) {
                    if (!SessionState.CLOSED.equals((Object)this.getState()) && this.v) {
                        this.x();
                        return;
                    }
                    this.v();
                    return;
                }
                this.offline();
                return;
            }
        }
    }

    private void a(UUID uUID) {
        this.k = uUID;
    }

    private String h(String string) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < 3) {
            n2 = string.indexOf(47, n2 + 1);
            ++n3;
        }
        String string2 = string.substring(n2);
        return string2;
    }

    public UUID getClusterID() {
        SessionState sessionState = this.getState();
        if (sessionState == SessionState.CLOSED) {
            return null;
        }
        return this.t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionListener(ConnectionListener connectionListener) {
        Set<ConnectionListener> set = this.h;
        synchronized (set) {
            this.h.add(connectionListener);
            if (g.isTraceEnabled()) {
                g.trace(this + " Add connection listener, listeners.size after add : " + this.h.size());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionListener(ConnectionListener connectionListener) {
        Set<ConnectionListener> set = this.h;
        synchronized (set) {
            this.h.remove(connectionListener);
            if (g.isTraceEnabled()) {
                g.trace(this + " Remove connection listener, listeners.size after remove : " + this.h.size());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllConnectionListeners() {
        Set<ConnectionListener> set = this.h;
        synchronized (set) {
            this.h.clear();
            if (g.isTraceEnabled()) {
                g.trace(this + " Remove all connection listeners, listeners.size after remove all : " + this.h.size());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(x x2) {
        Set<x> set = this.i;
        synchronized (set) {
            this.i.add(x2);
            if (g.isTraceEnabled()) {
                g.trace(this + " Add session listener, listeners.size after add : " + this.i.size());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void b(x x2) {
        Set<x> set = this.i;
        synchronized (set) {
            this.i.remove(x2);
            if (g.isTraceEnabled()) {
                g.trace(this + " Remove session listener, listeners.size after remove : " + this.i.size());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void u() {
        Set<x> set = this.i;
        synchronized (set) {
            this.i.clear();
            if (g.isTraceEnabled()) {
                g.trace(this + " Remove all session listeners, listeners.size after remove all : " + this.i.size());
            }
        }
    }

    private synchronized void a(SessionState sessionState) {
        if (g.isDebugEnabled()) {
            g.debug(String.format("Session %s transition: %s -> %s", this.k, this.o, sessionState));
        }
        this.o = sessionState;
    }

    public synchronized SessionState getState() {
        return this.o;
    }

    public String toString() {
        return "Session(User=" + this.l + ", ID=" + this.k + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void e(u.a a2) {
        Set<x> set = this.i;
        synchronized (set) {
            block9: for (x x2 : this.i) {
                try {
                    switch (a2) {
                        case CLOSED: {
                            x2.notifySessionEvent(new c(this, u.a.CLOSED));
                            continue block9;
                        }
                        case EXPIRED: {
                            x2.notifySessionEvent(new c(this, u.a.EXPIRED));
                            continue block9;
                        }
                        default: {
                            throw new IllegalArgumentException("event=" + (Object)((Object)a2) + ".");
                        }
                    }
                }
                catch (Exception exception) {
                    g.error(this + " Error while notify session event", (Throwable)exception);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void v() {
        g.info(this + " Notify connection lost event(host=" + this.m + ") to " + this.h.size() + " listener(s)");
        for (ConnectionListener connectionListener : this.h) {
            try {
                connectionListener.notifyConnectionEvent((ConnectionEvent)new a(this, this.m, ConnectionEvent.ConnectionEventType.CONNECTION_LOST));
            }
            catch (Exception exception) {
                g.error(this + " Error while notify connection lost", (Throwable)exception);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void w() {
        g.info(this + " Notify disconnect event(host=" + this.m + ") to " + this.h.size() + " listener(s)");
        for (ConnectionListener connectionListener : this.h) {
            try {
                connectionListener.notifyConnectionEvent((ConnectionEvent)new a(this, this.m, ConnectionEvent.ConnectionEventType.DISCONNECTED));
            }
            catch (Exception exception) {
                g.error(this + " Error while notify disconnect", (Throwable)exception);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void i(String string) {
        if (this.getState() != SessionState.OPEN) {
            g.error("Notify reconnect fail since session state = " + this.getState().toString());
            return;
        }
        g.info(this + " Notify reconnect success event(host=" + this.m + ") to " + this.h.size() + " listener(s)");
        for (ConnectionListener connectionListener : this.h) {
            try {
                connectionListener.notifyConnectionEvent((ConnectionEvent)new a(this, string, ConnectionEvent.ConnectionEventType.RECONNECTED));
            }
            catch (Exception exception) {
                g.error(this + " Error while notify reconnect", (Throwable)exception);
            }
        }
    }

    public void reconnect() {
        if (this.getState() == SessionState.OFFLINE) {
            String string = "not allowed: SessionImpl.reconnect called when session is in state %s.";
            throw new IllegalStateException(String.format(string, this.o.name()));
        }
        this.q();
        List<String> list = this.s.k();
        Random random = new Random();
        int n2 = 0;
        if (list.size() > 1) {
            n2 = random.nextInt(list.size() - 1);
        }
        String string = list.get(n2);
        try {
            this.j(string);
        }
        catch (Exception exception) {
            this.r();
            this.v();
            g.warn("{} try to reconnect session host {} fail with error : {}", new Object[]{this, string, exception.getMessage()});
            throw new CommunicationException(this + " try to reconnect session host " + string + ".", (Throwable)exception);
        }
        String string2 = this.getConnectedHost();
        this.i(string2);
    }

    private void x() {
        this.q();
        b b2 = new b();
        CompletableFuture<Boolean> completableFuture = com.nomagic.esi.client.core.a.t.a(b2, (int)this.s.m(), this.s.l());
        completableFuture.whenComplete((bl, throwable) -> {
            block6: {
                block5: {
                    block4: {
                        if (bl == null || !bl.booleanValue()) break block4;
                        String string = this.getConnectedHost();
                        this.i(string);
                        break block6;
                    }
                    this.r();
                    if (throwable == null) break block5;
                    completableFuture.obtrudeValue(Boolean.FALSE);
                    g.warn("Error while try to reconnect session manually.", throwable);
                    break block6;
                }
                this.v();
                g.warn("Connection lost while try to reconnect session manually.");
            }
        });
    }

    synchronized void j(String string) throws ConnectException, Exception {
        block3: {
            block2: {
                if (this.getState() != SessionState.RECONNECTING) break block2;
                this.g(string);
                break block3;
            }
            throw new IllegalStateException(String.format("Attempting to reconnect session without being in RECONNECTING state: " + this.getState() + ".", new Object[0]));
        }
    }

    i y() {
        return this.getService(i.class);
    }

    public AccessManager getAccessManager() {
        return this.getService(AccessManager.class);
    }

    public SslConfigManager getSslConfigManager() {
        return this.getService(SslConfigManager.class);
    }

    public PreloadingPolicy getPreloadingPolicy() {
        return this.p;
    }

    public CacheManager getCacheManager() {
        return this.getService(CacheManager.class);
    }

    public com.nomagic.esi.net.a.g z() {
        return this.r;
    }

    public VersionControlManager getVersionControlManager() {
        return this.getService(VersionControlManager.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getInt(String string) {
        switch (string) {
            case "comms.messages.sent": {
                return ((h)this.getService(i.class)).q();
            }
            case "comms.loadresult.count": {
                return ((h)this.getService(i.class)).o();
            }
        }
        throw new IllegalArgumentException("unknown statistic: " + string + ".");
    }

    public void reset(String string) {
        throw new UnsupportedOperationException("not supported: reset " + string + ".");
    }

    public void resetAll() {
        ((h)this.getService(i.class)).p();
    }

    public void a(p p2) {
        block2: {
            com.nomagic.esi.helper.a.b.a((String)"clusterInfo", (Object)p2);
            if (this.t == null || this.t.equals(p2.j())) break block2;
            String string = "session is connecting to cluster %s; expected cluster %s.";
            throw new IllegalStateException(String.format(string, p2.j(), this.t));
        }
        this.s = p2;
        this.t = p2.j();
    }

    public p A() {
        return this.s;
    }

    public void setAutoReconnectEnabled(boolean bl) {
        this.v = bl;
    }

    public KeyStore getKeyStore() {
        return this.q;
    }

    public SslClientConfig getSslConfig() {
        String string = SslClientConfig.class.getSimpleName();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (this.q == null) {
            return null;
        }
        try {
            this.q.store(byteArrayOutputStream, string.toCharArray());
            byteArrayOutputStream.close();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return new SslClientConfig(byteArrayOutputStream.toByteArray(), string);
    }

    private void b(com.nomagic.esi.net.a.g g2) {
        if (this.l() != null) {
            try {
                ActorRef actorRef = g2.c(a);
                if (g.isTraceEnabled()) {
                    g.trace("Send register cluster listener for session ID " + this.k);
                }
                g2.a(actorRef, (Object)new RegisterSenderAsClusterListenerMsg(this.k, this.r.j(), g2.k().j().getAddress().getHostAddress()));
            }
            catch (Exception exception) {
                g.error("Error when try to register for cluster listener", (Throwable)exception);
                throw new LoginException(this + " Exception while register cluster listener.", (Throwable)exception);
            }
        }
        g.error("Cannot send register cluster listener for session ID " + this.k + ", host=" + this.m);
    }

    public boolean B() {
        return SessionState.OPEN.equals((Object)this.getState());
    }

    public RawEsiCommander getCommander() {
        if (this.u == null) {
            this.u = new s(this.getService(i.class));
        }
        return this.u;
    }

    public void offline() {
        if (this.getState() == SessionState.CLOSED) {
            throw new IllegalStateException("Session was already closed");
        }
        if (this.s()) {
            g.info(this + " is set to offline");
            com.nomagic.esi.client.core.a.y.j().b(this.k);
            this.d((u.a)null);
            this.k = null;
            this.l = null;
            this.q = null;
            this.s = null;
        }
    }

    public <T> T getService(Class<T> clazz) {
        return (T)this.w.get(clazz);
    }

    public Object getServiceByName(String string) {
        Object object = this.w.get(string);
        if (object == null) {
            object = this.w.entrySet().stream().filter(entry -> ((Class)entry.getKey()).getName().equals(string)).findFirst().map(entry -> entry.getValue()).orElse(null);
        }
        return object;
    }

    public <T, U extends T> Object a(Class<T> clazz, U u2) {
        return this.w.put(clazz, u2);
    }

    public <T> Object a(Class<T> clazz) {
        return this.w.remove(clazz);
    }

    public d C() {
        return this.getService(d.class);
    }

    public LicenseMode getLicenseMode() {
        return this.j;
    }

    public Map<Object, Object> getProperties() {
        return this.d;
    }

    public boolean open(String string, String string2, String string3, SslClientConfig sslClientConfig) {
        SessionConfigurator sessionConfigurator = new SessionConfigurator();
        sessionConfigurator.username(string2, string3);
        return this.a(sessionConfigurator, string, sslClientConfig);
    }

    public boolean open(String string, String string2, SslClientConfig sslClientConfig) {
        SessionConfigurator sessionConfigurator = new SessionConfigurator();
        sessionConfigurator.token(string2);
        return this.a(sessionConfigurator, string, sslClientConfig);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean a(SessionConfigurator sessionConfigurator, String string, SslClientConfig sslClientConfig) {
        String[] stringArray = string.split(":");
        String string2 = stringArray[0];
        int n3 = stringArray.length > 1 ? Integer.parseInt(stringArray[1]) : this.j();
        sessionConfigurator.host(string2);
        sessionConfigurator.port(n3);
        if (sslClientConfig == null) {
            sessionConfigurator.tls(false);
        } else {
            KeyStore keyStore;
            if (Networking.getInstance().getEsiConfigService().isServer() && (sslClientConfig.getClientKeystore() == null || sslClientConfig.getClientKeystore().length == 0)) {
                keyStore = Networking.getInstance().getTlsManager().k();
            } else {
                try {
                    keyStore = com.nomagic.esi.helper.a.d.a((byte[])sslClientConfig.getClientKeystore(), (char[])sslClientConfig.getClientPass().toCharArray());
                }
                catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException exception) {
                    throw new EsiException(exception.getMessage(), (Throwable)exception);
                }
            }
            sessionConfigurator.keystore(keyStore);
            sessionConfigurator.tls(true);
        }
        sessionConfigurator.mode(this.j);
        return this.open(sessionConfigurator);
    }

    public Set<String> getCapabilities() {
        return this.y;
    }

    private final class a
    implements ConnectionEvent {
        private final Session a;
        private final String b;
        private final ConnectionEvent.ConnectionEventType c;

        private a(Session session, String string, ConnectionEvent.ConnectionEventType connectionEventType) {
            com.nomagic.esi.helper.a.b.a((String)"session", (Object)session);
            com.nomagic.esi.helper.a.b.a((String)"oldHost", (Object)string);
            com.nomagic.esi.helper.a.b.a((String)"type", (Object)connectionEventType);
            this.a = session;
            this.b = string;
            this.c = connectionEventType;
        }

        public ConnectionEvent.ConnectionEventType getType() {
            return this.c;
        }

        public String getOldHost() {
            return this.b;
        }

        public Session getSession() {
            return this.a;
        }
    }

    private final class b
    implements Callable<Boolean> {
        int a;
        final List<String> b;

        private b() {
            this.b = w.this.s.k();
        }

        public Boolean j() throws Exception {
            this.a %= this.b.size();
            String string = this.b.get(this.a);
            boolean bl = true;
            try {
                w.this.j(string);
            }
            catch (SessionException sessionException) {
                throw new InterruptedException(sessionException.getMessage());
            }
            catch (Exception exception) {
                g.warn("try to reconnect session host {} fail with error : {}", (Object)string, (Object)exception.getMessage());
                bl = false;
            }
            ++this.a;
            return bl;
        }
    }

    private final class c
    implements u {
        private final Session a;
        private final u.a b;

        private c(Session session, u.a a2) {
            com.nomagic.esi.helper.a.b.a((String)"session", (Object)session);
            com.nomagic.esi.helper.a.b.a((String)"type", (Object)((Object)a2));
            this.a = session;
            this.b = a2;
        }

        @Override
        public u.a j() {
            return this.b;
        }

        @Override
        public Session k() {
            return this.a;
        }
    }
}

