/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.esi.client.core;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.PoisonPill;
import akka.actor.Props;
import com.nomagic.esi.api.ESI;
import com.nomagic.esi.api.SessionFactory;
import com.nomagic.esi.api.UriFactory;
import com.nomagic.esi.api.config.ServerServices;
import com.nomagic.esi.api.config.SslClientConfig;
import com.nomagic.esi.api.messages.exceptions.EsiException;
import com.nomagic.esi.client.core.a.a.a;
import com.nomagic.esi.client.core.a.c.j;
import com.nomagic.esi.client.core.a.v;
import com.nomagic.esi.config.EsiConfigService;
import com.nomagic.esi.emf.a.H;
import com.nomagic.esi.helper.a.d;
import com.nomagic.esi.net.INetworking;
import com.nomagic.esi.service.IActorSystemFactory;
import com.nomagic.esi.supervisor.ISupervisorFactory;
import com.typesafe.config.Config;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EsiImpl
implements ESI {
    private static final Logger LOG = LoggerFactory.getLogger(EsiImpl.class);
    private final SessionFactory sessionFactory = new v();
    private UriFactory uriFactory;
    private volatile ActorSystem actorSystem;
    private static volatile EsiImpl instance = null;
    private volatile ActorRef clientListenerActor;
    private volatile ISupervisorFactory supervisorFactory;
    private volatile INetworking networking;
    private EsiConfigService configService;

    public void setSupervisorFactory(ISupervisorFactory iSupervisorFactory) {
        this.supervisorFactory = iSupervisorFactory;
    }

    public void unsetSupervisorFactory(ISupervisorFactory iSupervisorFactory) {
        this.supervisorFactory = null;
    }

    public void setNetworking(INetworking iNetworking) {
        this.networking = iNetworking;
    }

    public void unsetNetworking(INetworking iNetworking) {
        this.networking = null;
    }

    public INetworking getNetworking() {
        return this.networking;
    }

    public static EsiImpl getInstance() {
        return instance;
    }

    public void setActorSystemFactory(IActorSystemFactory iActorSystemFactory) {
        this.actorSystem = iActorSystemFactory.getActorSystem();
    }

    public void unsetActorSystemFactory(IActorSystemFactory iActorSystemFactory) {
        this.actorSystem = null;
    }

    public void activate(BundleContext bundleContext) {
        instance = this;
        Props props = Props.create(a.class, (Object[])new Object[0]);
        this.clientListenerActor = this.supervisorFactory.createEsiRootActor(props, "ClientListenerActor");
        LOG.info(String.valueOf(EsiImpl.class.getSimpleName()) + " activated");
    }

    public void deactivate(BundleContext bundleContext) {
        if (this.clientListenerActor != null) {
            this.actorSystem.stop(this.clientListenerActor);
            this.clientListenerActor.tell((Object)PoisonPill.getInstance(), null);
        }
        LOG.info(String.valueOf(EsiImpl.class.getSimpleName()) + " deactivated");
    }

    public ActorRef getClientListenerActorRef() {
        return this.clientListenerActor;
    }

    public ISupervisorFactory getSupervisorFactory() {
        return this.supervisorFactory;
    }

    public ActorSystem getActorSystem() {
        return this.actorSystem;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public UriFactory getUriFactory() {
        if (this.uriFactory == null) {
            this.uriFactory = new H();
        }
        return this.uriFactory;
    }

    public ServerServices getServerServices(String string, SslClientConfig sslClientConfig) {
        boolean bl;
        KeyStore keyStore = null;
        if (sslClientConfig == null) {
            bl = false;
        } else {
            try {
                keyStore = d.a((byte[])sslClientConfig.getClientKeystore(), (char[])sslClientConfig.getClientPass().toCharArray());
                bl = true;
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException exception) {
                throw new EsiException(exception.getMessage(), (Throwable)exception);
            }
        }
        return this.getServerServices(string, bl, keyStore);
    }

    public void setEsiConfigService(EsiConfigService esiConfigService) {
        this.configService = esiConfigService;
    }

    public Config getConfig() {
        return this.configService.getConfig();
    }

    public ServerServices getServerServices(String string, boolean bl, KeyStore keyStore) {
        j j2 = new j(string, bl, keyStore);
        return j2;
    }
}

