/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.maplembse.analytical.engine;

import com.maplesoft.maplembse.analytical.engine.exceptions.AEException;
import com.maplesoft.maplembse.analytical.engine.exceptions.AESyntaxException;
import java.util.Map;
import java.util.Objects;
import org.eclipse.emf.ecore.EObject;

public interface FormulaBundle {
    public EObject getFormulaInstance();

    public String getFormulaString();

    public Map<EObject, String> getVariables();

    public static class FormulaBuilder {
        public static FormulaBundle newInstance(EObject element, String formula, Map<EObject, String> map) throws AEException {
            Objects.requireNonNull(element);
            Objects.requireNonNull(formula);
            Objects.requireNonNull(map);
            if (formula.isEmpty()) {
                throw new AESyntaxException(element + " has not formula.");
            }
            if (map.entrySet().isEmpty()) {
                throw new AESyntaxException(element + " has not variables elements.");
            }
            return new FormulaImpl(element, formula, map);
        }
    }

    public static class FormulaImpl
    implements FormulaBundle {
        private EObject formulaInstance;
        private String formula;
        private Map<EObject, String> variableMap;

        private FormulaImpl(EObject element, String formula, Map<EObject, String> variableMap) {
            this.formulaInstance = element;
            this.formula = formula;
            this.variableMap = variableMap;
        }

        @Override
        public EObject getFormulaInstance() {
            return this.formulaInstance;
        }

        @Override
        public String getFormulaString() {
            return this.formula;
        }

        @Override
        public Map<EObject, String> getVariables() {
            return this.variableMap;
        }
    }
}

