/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.maplembse.analytical.engine;

import com.ibm.trinity.spreadsheet.excel.Range;
import com.ibm.trinity.spreadsheet.excel.Worksheet;
import com.maplesoft.maplembse.analytical.engine.AnalyticalEngineMessages;
import com.maplesoft.maplembse.analytical.engine.FormulaBundle;
import com.maplesoft.maplembse.analytical.engine.FormulaHandler;
import com.maplesoft.maplembse.analytical.engine.exceptions.AEArithmeticException;
import com.maplesoft.maplembse.analytical.engine.exceptions.AECircularDependencyException;
import com.maplesoft.maplembse.analytical.engine.exceptions.AEException;
import com.maplesoft.maplembse.analytical.engine.exceptions.AEFormulaVariableException;
import com.maplesoft.maplembse.analytical.engine.exceptions.AEIllegalStateException;
import com.maplesoft.maplembse.analytical.engine.exceptions.AESyntaxException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;

public class DefaultFormulaHandlerImpl
implements FormulaHandler {
    public static final Logger LOGGER = Logger.getLogger(DefaultFormulaHandlerImpl.class);
    private static final int REFERENCE_COL = 10;
    private static final int OFFSET_ERROR_FLAGS = 0;
    private static final int OFFSET_FORMULA = 1;
    private static final int OFFSET_OUTPUT = 2;
    private static final int OFFSET_INPUT = 3;
    private static final int HEADER_ROW = 1;
    private static final int OUTPUT_SPLIT_INDEX = 0;
    private static final int FORMULA_SPLIT_INDEX = 1;
    private static final int MAX_FORMULA_SPLITS = 2;
    private static final String DELIMITER = "=";
    private int id;
    private FormulaBundle formulaBundle;
    private Worksheet worksheet;
    private LinkedHashMap<EObject, FormulaHandler> inputFormulaHandlers;
    private Object result;
    private String outputVariableName;
    private Range outputCell;
    private final Map<EObject, Range> cellMap = new HashMap<EObject, Range>();
    private static final Pattern pattern = Pattern.compile("[A-Za-z][A-Za-z0-9_.]*[\\(\\{\\[]?");

    public DefaultFormulaHandlerImpl(int id, FormulaBundle formulaBundle, Worksheet worksheet) throws AEException {
        if (id <= 1) {
            throw new IllegalArgumentException();
        }
        Objects.requireNonNull(formulaBundle);
        Objects.requireNonNull(worksheet);
        this.id = id;
        this.worksheet = worksheet;
        this.outputCell = worksheet.getCells(id, 12);
        this.formulaBundle = formulaBundle;
        this.inputFormulaHandlers = new LinkedHashMap();
        this.initFormulaInWorkSheet();
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public FormulaBundle getFormulaBundle() {
        return this.formulaBundle;
    }

    @Override
    public EObject getOutputVariable() throws AEException {
        if (this.outputVariableName == null || this.outputVariableName.isEmpty()) {
            throw new AEFormulaVariableException(this + " does not have an output yet");
        }
        Optional<Map.Entry> str = this.formulaBundle.getVariables().entrySet().stream().filter(entry -> ((String)entry.getValue()).equals(this.outputVariableName)).findFirst();
        return (EObject)str.get().getKey();
    }

    @Override
    public List<EObject> getOrderedRequiredInputVariables() throws AEException {
        EObject output = this.getOutputVariable();
        List<EObject> requiredInputs = this.getFormulaBundle().getVariables().keySet().stream().filter(v -> v != output).filter(v -> this.getInputFormulaHandler((EObject)v) == null).collect(Collectors.toList());
        requiredInputs.sort(Comparator.comparing(Object::toString));
        return requiredInputs;
    }

    @Override
    public Object getResult(Object ... inputs) throws AEException {
        if (inputs == null || this.getOrderedRequiredInputVariables().size() != inputs.length) {
            throw new AEFormulaVariableException("The inputs do not match what is expexted for " + this.getFormulaBundle().getFormulaString());
        }
        List<EObject> variables = this.getOrderedRequiredInputVariables();
        for (EObject variable : variables) {
            int index = variables.indexOf(variable);
            this.getCellMap().get(variable).setValue(inputs[index]);
        }
        this.checkErrors(this.outputCell, 0.0);
        this.result = this.outputCell.getValue();
        return this.result;
    }

    @Override
    public Object getResult() throws AEException {
        if (this.result == null) {
            throw new AEIllegalStateException("Result is null or the getResult with inputs has not being called before this one.");
        }
        return this.result;
    }

    private void initFormulaInWorkSheet() throws AEException {
        String formulaString = this.getFormulaBundle().getFormulaString();
        if (!formulaString.contains(DELIMITER)) {
            throw new AESyntaxException(AnalyticalEngineMessages.SYNTAX1.toString());
        }
        String[] splits = formulaString.split(DELIMITER, 2);
        this.outputVariableName = splits[0].trim();
        if (this.outputVariableName == null || this.outputVariableName.isEmpty() || !this.getFormulaBundle().getVariables().values().contains(this.outputVariableName)) {
            LOGGER.info((Object)("Unable to find the output variable for the formula " + this.getFormulaBundle().getFormulaString()));
            throw new AEFormulaVariableException(AnalyticalEngineMessages.SYNTAX1.toString());
        }
        formulaString = DefaultFormulaHandlerImpl.prepareFormulaString(splits[1]);
        Set<String> variableNames = DefaultFormulaHandlerImpl.tokenizer(formulaString);
        if (!this.getFormulaBundle().getVariables().values().containsAll(variableNames)) {
            LOGGER.info((Object)("Unable to find some of the input variable for the " + this.getFormulaBundle().getFormulaString()));
            throw new AEFormulaVariableException(AnalyticalEngineMessages.SYNTAX1.toString());
        }
        this.removeUnusedVariables(variableNames);
        for (EObject variable : this.getInputVariables()) {
            String variableName = this.getFormulaBundle().getVariables().get(variable);
            formulaString = formulaString.replaceAll("\\b" + variableName + "\\b", this.getCellMap().get(variable).getAddress().replaceAll("\\$", ""));
        }
        this.worksheet.getCells(this.id, 11).setValue((Object)splits[1]);
        try {
            this.outputCell.setValue((Object)formulaString);
            this.checkErrors(this.outputCell, 2.0);
        }
        catch (Exception e) {
            throw new AEIllegalStateException(AnalyticalEngineMessages.MSG2.toString(), e);
        }
    }

    private void checkErrors(Range cell, double state) throws AEException {
        Range ref = this.worksheet.getCells(2, 10);
        ref.setValue((Object)(DELIMITER + cell.getAddress()));
        Range isErrorCell = this.worksheet.getCells(3, 10);
        isErrorCell.setValue((Object)("=ISERROR(" + ref.getAddress() + ")"));
        Range errorTypeCell = this.worksheet.getCells(4, 10);
        errorTypeCell.setValue((Object)("=ERROR.TYPE(" + ref.getAddress() + ")"));
        Object errorType = errorTypeCell.getValue();
        boolean hasError = (Boolean)isErrorCell.getValue();
        if (hasError) {
            double error;
            double d = error = errorType instanceof Double ? (Double)errorType : 0.0;
            if (Double.compare(error, state) == 0) {
                return;
            }
            if (Double.compare(error, 2.0) == 0) {
                throw new AEArithmeticException("Arithmetic error happened in " + this.getFormulaBundle().getFormulaInstance());
            }
            throw new AEIllegalStateException(AnalyticalEngineMessages.MSG2.toString());
        }
    }

    @Override
    public boolean isThereCircularDependency() throws AEException {
        if (this.worksheet.getCircularReference() != null) {
            throw new AECircularDependencyException(AnalyticalEngineMessages.MSG2.toString());
        }
        return false;
    }

    private static final String prepareFormulaString(String formula) {
        String result = formula.replaceAll("\\[", "(").replaceAll("\\{", "(").replaceAll("\\]", ")").replaceAll("\\}", ")");
        return DELIMITER + result;
    }

    private Map<EObject, Range> getCellMap() throws AEException {
        if (!this.cellMap.isEmpty()) {
            return this.cellMap;
        }
        int col = 13;
        try {
            for (EObject variable : this.getInputVariables()) {
                Range a = this.worksheet.getCells(this.id, col);
                this.cellMap.put(variable, a);
                ++col;
            }
        }
        catch (Exception e) {
            throw new AEIllegalStateException(AnalyticalEngineMessages.MSG2.toString(), e);
        }
        return this.cellMap;
    }

    @Override
    public FormulaHandler getInputFormulaHandler(EObject variable) {
        return this.inputFormulaHandlers.get(variable);
    }

    @Override
    public void setInputFormulaHandler(EObject variable, FormulaHandler fh) {
        this.inputFormulaHandlers.put(variable, fh);
        try {
            this.getCellMap().get(variable).setValue((Object)(DELIMITER + this.worksheet.getCells(fh.getId(), 12)));
        }
        catch (Exception e) {
            LOGGER.info((Object)AnalyticalEngineMessages.MSG2.toString(), (Throwable)e);
        }
    }

    public static Set<String> tokenizer(String str) {
        HashSet<String> variables = new HashSet<String>();
        Matcher matcher = pattern.matcher(str);
        while (matcher.find()) {
            if (matcher.group().contains("(") || matcher.group().contains("{") || matcher.group().contains("[")) continue;
            variables.add(matcher.group());
        }
        return variables;
    }

    private void removeUnusedVariables(Set<String> variableNames) {
        HashSet<EObject> variables = new HashSet<EObject>(this.getFormulaBundle().getVariables().keySet());
        for (EObject var : variables) {
            String name = this.getFormulaBundle().getVariables().get(var);
            if (variableNames.contains(name) || name.equals(this.outputVariableName)) continue;
            this.getFormulaBundle().getVariables().remove(var);
        }
    }
}

