/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.maplembse.analytical.engine;

import com.ibm.trinity.spreadsheet.excel.Worksheet;
import com.maplesoft.maplembse.analytical.engine.AnalyticalEngine;
import com.maplesoft.maplembse.analytical.engine.DefaultFormulaHandlerImpl;
import com.maplesoft.maplembse.analytical.engine.FormulaBundle;
import com.maplesoft.maplembse.analytical.engine.FormulaHandler;
import com.maplesoft.maplembse.analytical.engine.exceptions.AEException;
import com.maplesoft.maplembse.analytical.engine.exceptions.AEIllegalStateException;
import java.util.concurrent.atomic.AtomicInteger;

public class DefaultAnalyticalEngineImpl
implements AnalyticalEngine {
    private Worksheet worksheet;
    private AtomicInteger idGenerator;

    @Override
    public FormulaHandler getFormulaHandler(FormulaBundle formulaBundle) throws AEException {
        if (this.worksheet == null) {
            throw new AEIllegalStateException("Worksheet not found.");
        }
        return new DefaultFormulaHandlerImpl(this.getId(), formulaBundle, this.worksheet);
    }

    @Override
    public void setMetadata(Object metadata) throws AEException {
        if (!(metadata instanceof Worksheet)) {
            throw new AEIllegalStateException("Worksheet not found.");
        }
        this.worksheet = (Worksheet)metadata;
        this.idGenerator = new AtomicInteger(1);
    }

    @Override
    public boolean checkLicense() throws AEException {
        return true;
    }

    private int getId() {
        assert (this.idGenerator != null);
        return this.idGenerator.incrementAndGet();
    }
}

