/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.maplembse.analytical.engine;

import com.maplesoft.maplembse.analytical.engine.AnalyticalEngine;
import com.maplesoft.maplembse.analytical.engine.AnalyticalFactory;
import com.maplesoft.maplembse.analytical.engine.DefaultAnalyticalEngineImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.log4j.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class AnalyticalRegistry
implements ServiceListener {
    public static final Logger LOGGER = Logger.getLogger(AnalyticalRegistry.class);
    private final BundleContext context;
    private static List<AnalyticalFactory> analyticalFactories = new ArrayList<AnalyticalFactory>();
    private static final String SERVICE_LISTENER_FILTER = "(objectClass=" + AnalyticalFactory.class.getName() + ")";
    private static Map<String, AnalyticalEngine> map = new HashMap<String, AnalyticalEngine>();

    private AnalyticalRegistry(BundleContext context) {
        this.context = context;
    }

    private void publishService() {
        try {
            Collection srs = this.context.getServiceReferences(AnalyticalFactory.class, null);
            for (ServiceReference sr : srs) {
                AnalyticalFactory mpf = (AnalyticalFactory)this.context.getService(sr);
                analyticalFactories.add(mpf);
            }
        }
        catch (InvalidSyntaxException e) {
            LOGGER.error((Object)e);
        }
        try {
            this.context.addServiceListener((ServiceListener)this, SERVICE_LISTENER_FILTER);
        }
        catch (InvalidSyntaxException e) {
            LOGGER.error((Object)e);
        }
    }

    public static AnalyticalRegistry newInstance(BundleContext context) {
        AnalyticalRegistry d = new AnalyticalRegistry(context);
        d.publishService();
        return d;
    }

    public void serviceChanged(ServiceEvent event) {
        ServiceReference sr = event.getServiceReference();
        Object o = this.context.getService(sr);
        if (!(o instanceof AnalyticalFactory)) {
            return;
        }
        AnalyticalFactory aF = (AnalyticalFactory)o;
        switch (event.getType()) {
            case 1: {
                analyticalFactories.add(aF);
                break;
            }
            case 4: {
                analyticalFactories.remove(aF);
            }
        }
    }

    public static AnalyticalEngine getEngine(String name) {
        if (map.containsKey(name)) {
            return map.get(name);
        }
        for (AnalyticalFactory af : analyticalFactories) {
            if (!Objects.equals(af.getTarget(), name)) continue;
            AnalyticalEngine e = af.create();
            assert (name != null || e instanceof DefaultAnalyticalEngineImpl);
            map.put(name, e);
            return e;
        }
        LOGGER.info((Object)("Unsupported engine " + name));
        return null;
    }
}

