/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.esi.net;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import com.nomagic.esi.config.EsiConfigService;
import com.nomagic.esi.helper.a.a.d;
import com.nomagic.esi.net.INetworking;
import com.nomagic.esi.net.a.d.e;
import com.nomagic.esi.net.a.f.f;
import com.nomagic.esi.net.a.g;
import com.nomagic.esi.net.a.j;
import com.nomagic.esi.net.a.k;
import com.nomagic.esi.net.a.l;
import com.nomagic.esi.net.a.m;
import com.nomagic.esi.serializer.ClassRegistrarSerializer;
import com.nomagic.esi.service.IActorSystemFactory;
import java.net.ConnectException;
import java.security.KeyStore;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Networking
implements INetworking {
    private static volatile Networking instance;
    private static final Logger LOG;
    private IActorSystemFactory actorSystemFactory;
    private EsiConfigService esiConfigService;
    private ClassRegistrarSerializer serializer;
    private e tlsManager;

    static {
        LOG = LoggerFactory.getLogger(Networking.class);
    }

    public static Networking getInstance() {
        return instance;
    }

    public void activate() {
        instance = this;
        LOG.info(String.valueOf(Networking.class.getSimpleName()) + " activated");
        f.b.c(true);
        this.tlsManager = new e(this);
    }

    @Override
    public void addConnectionInfoSubscriber(ActorRef actorRef) {
        k.a(actorRef);
    }

    @Override
    public g connect(m m2, boolean bl, KeyStore keyStore) throws ConnectException {
        return k.a(m2, bl, keyStore);
    }

    public void deactivate() {
        f.b.n();
        instance = null;
        LOG.info(String.valueOf(Networking.class.getSimpleName()) + " deactivated");
    }

    public ActorSystem getActorSystem() {
        return this.actorSystemFactory.getActorSystem();
    }

    @Override
    public String getActorSystemName(ActorSystem actorSystem) {
        return k.a(actorSystem);
    }

    @Override
    public String getBroadcastHost() {
        return k.j();
    }

    public EsiConfigService getEsiConfigService() {
        return this.esiConfigService;
    }

    @Override
    public String getHost() {
        return k.l();
    }

    @Override
    public int getNonSSLPort() {
        return k.n();
    }

    @Override
    public List<l> getOpenConnections() {
        return k.m();
    }

    @Override
    public int getPort() {
        int n = this.tlsManager.m() ? this.tlsManager.j().getPort() : k.n();
        return n;
    }

    public ClassRegistrarSerializer getSerializer() {
        return this.serializer;
    }

    @Override
    public int getSSLPort() {
        return this.tlsManager.j().getPort();
    }

    @Override
    public j getTlsManager() {
        return this.tlsManager;
    }

    @Override
    public boolean isSslEnabled() {
        return this.tlsManager.m();
    }

    public boolean isStarted(boolean bl) {
        return f.b.c(bl);
    }

    @Override
    public void listen() {
        block8: {
            if (this.actorSystemFactory.getActorSystem() != null) {
                try {
                    String string = this.getHost();
                    int n = k.n();
                    m m2 = new m(string, n);
                    if (this.shouldOpenRegularPort(n)) {
                        com.nomagic.esi.net.a.a.f.a(this.actorSystemFactory.getActorSystem(), true).a(m2, null);
                    }
                    if (this.tlsManager.m()) {
                        int n2 = this.tlsManager.j().getPort();
                        m m3 = new m(string, n2);
                        com.nomagic.esi.net.a.a.f.a(this.actorSystemFactory.getActorSystem(), true).a(m3, this.tlsManager.j());
                        LOG.info("SSL is enabled; listening for SSL connections on: {}:{}", (Object)string, (Object)Integer.toString(this.tlsManager.j().getPort()));
                        break block8;
                    }
                    LOG.info("SSL is disabled");
                }
                catch (Exception exception) {
                    LOG.error("Error while trying to activate " + Networking.class.getSimpleName(), (Throwable)exception);
                    this.shutdown();
                }
            } else {
                LOG.error("Could not start actors because the actorsystem was null");
                this.shutdown();
            }
        }
    }

    @Override
    public void removeConnectionInfoSubscriber(ActorRef actorRef) {
        k.b(actorRef);
    }

    public void setActorSystemFactory(IActorSystemFactory iActorSystemFactory) {
        this.actorSystemFactory = iActorSystemFactory;
    }

    public void setEsiConfigService(EsiConfigService esiConfigService) {
        this.esiConfigService = esiConfigService;
    }

    public void setSerializer(ClassRegistrarSerializer classRegistrarSerializer) {
        this.serializer = classRegistrarSerializer;
    }

    private boolean shouldOpenRegularPort(int n) {
        return !this.tlsManager.m() || n != this.tlsManager.j().getPort();
    }

    private void shutdown() {
        IActorSystemFactory iActorSystemFactory = (IActorSystemFactory)d.j().b(this.getClass(), IActorSystemFactory.class);
        if (iActorSystemFactory != null) {
            iActorSystemFactory.shutdown();
        }
    }

    public void unsetActorSystemFactory(IActorSystemFactory iActorSystemFactory) {
        this.actorSystemFactory = null;
    }

    public void unsetEsiConfigService(EsiConfigService esiConfigService) {
        if (this.esiConfigService == esiConfigService) {
            this.esiConfigService = null;
        }
    }
}

