/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.magicdraw;

import com.nomagic.magicdraw.MagicDrawApplicationLauncher;
import com.nomagic.magicdraw.MainMethodLauncher;
import com.nomagic.magicdraw.cookies.CloseCookie;
import com.nomagic.magicdraw.cookies.Cookie;
import com.nomagic.magicdraw.cookies.CookieSet;
import com.nomagic.magicdraw.core.Application;
import com.nomagic.magicdraw.core.ApplicationLauncher;
import com.nomagic.runtime.ApplicationExitedException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;

public class ApplicationGateway
implements IApplication {
    public static final String APPLICATION = "com.nomagic.magicdraw.launcher";
    private static final Integer EXIT_FATAL_FAILURE = 255;
    private volatile Integer exitCode = EXIT_OK;

    public Object start(IApplicationContext context) throws Exception {
        CountDownLatch latch = this.getCountDownLatch();
        ApplicationLauncher launcher = ApplicationGateway.createApplicationLauncher(APPLICATION);
        Map contextArguments = context.getArguments();
        Object argsAsObject = contextArguments.get("application.args");
        String[] args = argsAsObject instanceof String[] ? (String[])argsAsObject : new String[]{};
        try {
            try {
                launcher.launch(args);
            }
            catch (ApplicationExitedException e) {
                return (int)e.getApplicationExitCode();
            }
            this.waitForApplicationRunnableExit(latch);
        }
        catch (Throwable e) {
            if (e instanceof InstantiationException) {
                try {
                    return Integer.parseInt(e.getMessage());
                }
                catch (NumberFormatException numberFormatException) {}
            }
            System.err.println("FATAL failure:");
            e.printStackTrace();
            return EXIT_FATAL_FAILURE;
        }
        return this.exitCode;
    }

    private void waitForApplicationRunnableExit(CountDownLatch latch) {
        try {
            latch.await();
        }
        catch (InterruptedException interruptedException) {
            System.out.println("Application was interrupted");
        }
    }

    private CountDownLatch getCountDownLatch() {
        Application application = Application.getInstance();
        final CountDownLatch latch = new CountDownLatch(1);
        CookieSet cookieSet = application.getCookieSet();
        Cookie prevCookie = cookieSet.getCookie(CloseCookie.class);
        if (prevCookie != null) {
            cookieSet.remove(prevCookie);
        }
        cookieSet.add((Cookie)new CloseCookie(){

            public void close(byte closeStatus) {
                ApplicationGateway.this.exitCode = Integer.valueOf(closeStatus);
                latch.countDown();
            }
        });
        return latch;
    }

    public static ApplicationLauncher createApplicationLauncher(String launcherProperty) throws ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, SecurityException {
        String launcherClassName = System.getProperty(launcherProperty);
        if (launcherClassName != null) {
            Class<?> launcherClass = ApplicationGateway.class.getClassLoader().loadClass(launcherClassName);
            if (ApplicationLauncher.class.isAssignableFrom(launcherClass)) {
                return (ApplicationLauncher)launcherClass.newInstance();
            }
            ApplicationLauncher launcher = ApplicationGateway.tryConvertToLauncher(launcherClass);
            if (launcher == null) {
                throw new InstantiationException();
            }
            return launcher;
        }
        return new MagicDrawApplicationLauncher();
    }

    private static ApplicationLauncher tryConvertToLauncher(Class<?> launcherClass) throws NoSuchMethodException, SecurityException {
        Method mainMethod = launcherClass.getMethod("main", String[].class);
        int mainModifiers = mainMethod.getModifiers();
        if (!Modifier.isStatic(mainModifiers)) {
            return null;
        }
        if (!Modifier.isPublic(mainModifiers)) {
            return null;
        }
        return new MainMethodLauncher(mainMethod);
    }

    public void stop() {
    }
}

