/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis.queries;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.queries.AbstractQuery;
import org.polarsys.capella.common.queries.exceptions.QueryException;
import org.polarsys.capella.common.queries.queryContext.IQueryContext;
import org.polarsys.capella.core.data.capellacore.ModellingArchitecture;
import org.polarsys.capella.core.data.capellamodeller.CapellamodellerPackage;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.epbs.EPBSArchitecture;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.oa.OperationalAnalysis;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.sirius.analysis.CapellaServices;

public class GetAvailableArchitectures
extends AbstractQuery {
    public List<Object> execute(Object input, IQueryContext context) throws QueryException {
        ArrayList<Object> returnedArchitectures = new ArrayList<Object>();
        SystemEngineering rootSystemEngineering = (SystemEngineering)CapellaServices.getService().getAncestor((EObject)input, CapellamodellerPackage.Literals.SYSTEM_ENGINEERING);
        BlockArchitecture ownerBlockArchitecture = null;
        ownerBlockArchitecture = input instanceof BlockArchitecture ? (BlockArchitecture)input : (BlockArchitecture)CapellaServices.getService().getAncestor((EObject)input, CsPackage.Literals.BLOCK_ARCHITECTURE);
        EList ownedArchitectures = rootSystemEngineering.getOwnedArchitectures();
        for (ModellingArchitecture modellingArchitecture : ownedArchitectures) {
            if (modellingArchitecture instanceof OperationalAnalysis) {
                returnedArchitectures.add(modellingArchitecture);
            }
            if (modellingArchitecture instanceof SystemAnalysis && !(ownerBlockArchitecture instanceof OperationalAnalysis)) {
                returnedArchitectures.add(modellingArchitecture);
            }
            if (modellingArchitecture instanceof LogicalArchitecture && !(ownerBlockArchitecture instanceof OperationalAnalysis) && !(ownerBlockArchitecture instanceof SystemAnalysis)) {
                returnedArchitectures.add(modellingArchitecture);
            }
            if (modellingArchitecture instanceof PhysicalArchitecture && !(ownerBlockArchitecture instanceof OperationalAnalysis) && !(ownerBlockArchitecture instanceof SystemAnalysis) && !(ownerBlockArchitecture instanceof LogicalArchitecture)) {
                returnedArchitectures.add(modellingArchitecture);
            }
            if (!(modellingArchitecture instanceof EPBSArchitecture) || !(ownerBlockArchitecture instanceof EPBSArchitecture)) continue;
            returnedArchitectures.add(modellingArchitecture);
        }
        return returnedArchitectures;
    }
}

