/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sequencediag;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.description.filter.FilterDescription;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.common.data.modellingcore.AbstractExchangeItem;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.common.queries.filters.IQueryFilter;
import org.polarsys.capella.common.queries.interpretor.QueryInterpretor;
import org.polarsys.capella.common.queries.queryContext.IQueryContext;
import org.polarsys.capella.common.queries.queryContext.QueryContext;
import org.polarsys.capella.core.business.queries.IBusinessQuery;
import org.polarsys.capella.core.business.queries.capellacore.BusinessQueriesProvider;
import org.polarsys.capella.core.data.capellacommon.AbstractState;
import org.polarsys.capella.core.data.capellacore.Constraint;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ComponentPkg;
import org.polarsys.capella.core.data.cs.ExchangeItemAllocation;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentExchangeFunctionalExchangeAllocation;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.information.AbstractEventOperation;
import org.polarsys.capella.core.data.information.AbstractInstance;
import org.polarsys.capella.core.data.information.ElementKind;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.ExchangeItemElement;
import org.polarsys.capella.core.data.information.Operation;
import org.polarsys.capella.core.data.information.Parameter;
import org.polarsys.capella.core.data.information.ParameterDirection;
import org.polarsys.capella.core.data.interaction.AbstractEnd;
import org.polarsys.capella.core.data.interaction.AbstractFragment;
import org.polarsys.capella.core.data.interaction.CombinedFragment;
import org.polarsys.capella.core.data.interaction.Event;
import org.polarsys.capella.core.data.interaction.EventReceiptOperation;
import org.polarsys.capella.core.data.interaction.EventSentOperation;
import org.polarsys.capella.core.data.interaction.Execution;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.InteractionFragment;
import org.polarsys.capella.core.data.interaction.InteractionOperand;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.core.data.interaction.MessageEnd;
import org.polarsys.capella.core.data.interaction.MessageKind;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.interaction.ScenarioKind;
import org.polarsys.capella.core.data.interaction.SequenceMessage;
import org.polarsys.capella.core.data.interaction.StateFragment;
import org.polarsys.capella.core.data.interaction.properties.controllers.InterfaceHelper;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.data.oa.OperationalActivity;
import org.polarsys.capella.core.data.oa.Role;
import org.polarsys.capella.core.model.handler.helpers.CapellaProjectHelper;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.ScenarioExt;
import org.polarsys.capella.core.model.helpers.SequenceMessageExt;
import org.polarsys.capella.core.model.helpers.queries.QueryIdentifierConstants;
import org.polarsys.capella.core.model.helpers.queries.filters.OnlySharedDataOrEventOrUnsetFilter;
import org.polarsys.capella.core.sirius.analysis.CapellaServices;
import org.polarsys.capella.core.sirius.analysis.InformationServices;
import org.polarsys.capella.core.sirius.analysis.SequenceDiagramServices;
import org.polarsys.capella.core.sirius.analysis.cache.ScenarioCache;

public class ScenarioService {
    private static final String EMPTY_STRING = "";

    public EObject moveEndOnScenario(InteractionFragment toMove, InteractionFragment previousEnd) {
        return ScenarioExt.moveEndOnScenario((InteractionFragment)toMove, (InteractionFragment)previousEnd);
    }

    public List<ExchangeItem> getSharedDataEventForSD(DSemanticDecorator elementView) {
        OnlySharedDataOrEventOrUnsetFilter filter = new OnlySharedDataOrEventOrUnsetFilter();
        return QueryInterpretor.executeQuery((String)QueryIdentifierConstants.GET_ALL_EXCHANGE_ITEMS_FOR_LIB, (Object)elementView.getTarget(), (IQueryContext)new QueryContext(), (IQueryFilter)filter);
    }

    public EObject moveEndOnInstanceRole(InteractionFragment toMove, InteractionFragment previousEnd) {
        return toMove;
    }

    public EObject moveEndOnBeginingOfScenario(InteractionFragment toMove) {
        return ScenarioExt.moveEndOnBeginingOfScenario((InteractionFragment)toMove);
    }

    public EObject moveEndOnBeginingOfInstanceRole(InteractionFragment toMove) {
        if (toMove instanceof AbstractEnd) {
            ((InstanceRole)toMove.getCoveredInstanceRoles().get(0)).getAbstractEnds().move(0, (Object)((AbstractEnd)toMove));
        }
        return toMove;
    }

    public EObject moveMessage(SequenceMessage toMove, SequenceMessage previousMessage) {
        Scenario scenario = (Scenario)toMove.eContainer();
        scenario.getOwnedMessages().move(scenario.getOwnedMessages().size() - 1, (Object)toMove);
        int newIndex = scenario.getOwnedMessages().indexOf((Object)previousMessage) + 1;
        if (newIndex >= scenario.getOwnedMessages().size()) {
            newIndex = scenario.getOwnedMessages().size() - 1;
        }
        scenario.getOwnedMessages().move(newIndex, (Object)toMove);
        return toMove;
    }

    public EObject moveMessageOnBegining(SequenceMessage toMove) {
        Scenario scenario = (Scenario)toMove.eContainer();
        scenario.getOwnedMessages().move(0, (Object)toMove);
        return toMove;
    }

    private SequenceMessage getMessageOpposite(EObject context) {
        return SequenceMessageExt.getOppositeSequenceMessage((SequenceMessage)((SequenceMessage)context));
    }

    public String getInstanceRoleLabel(InstanceRole ir) {
        StringBuilder result = new StringBuilder();
        AbstractInstance representedInstance = ir.getRepresentedInstance();
        if (representedInstance == null) {
            return "[" + EObjectLabelProviderHelper.getMetaclassLabel((EObject)ir, (boolean)false) + "]";
        }
        AbstractType type = representedInstance.getAbstractType();
        if (type == null || CapellaProjectHelper.TriStateBoolean.True.equals((Object)CapellaProjectHelper.isReusableComponentsDriven((EObject)type))) {
            result.append(EObjectExt.getText((EObject)representedInstance));
        } else {
            result.append(EObjectExt.getText((EObject)type));
        }
        if (ir.eContainer() instanceof Scenario) {
            Scenario scenario = (Scenario)ir.eContainer();
            for (InstanceRole element : scenario.getOwnedInstanceRoles()) {
                if (element == ir || element.getRepresentedInstance() != ir.getRepresentedInstance()) continue;
                result.insert(0, " : ").insert(0, EObjectExt.getText((EObject)ir));
                break;
            }
        }
        return result.toString();
    }

    public String getMessageName(SequenceMessage message) {
        return this.getMessageName(message, false);
    }

    public String getDFMessageName(SequenceMessage message, DDiagram diagram) {
        if (message == null) {
            return EMPTY_STRING;
        }
        boolean showExchangeItems = false;
        boolean showExchangeItemsParameters = false;
        boolean showFunctionalExchanges = false;
        boolean showFEEI = false;
        boolean showCEEI = false;
        boolean showFEParams = false;
        boolean showFEEIParams = false;
        boolean showCEParams = false;
        boolean showCEEIParams = false;
        boolean showExchangeContext = false;
        boolean showCEExchangeContext = false;
        boolean showFEExchangeContext = false;
        boolean hideCallArguments = false;
        EList eiOnMessage = message.getExchangedItems();
        for (FilterDescription filter : diagram.getActivatedFilters()) {
            if (filter.getName().equals("show.exchange.items.filter")) {
                showExchangeItems = true;
            }
            if (filter.getName().equals("show.exchange.items.parameters.filter")) {
                showExchangeItemsParameters = true;
            }
            if (filter.getName().equals("show.functional.exchanges.filter")) {
                showFunctionalExchanges = true;
            }
            if (filter.getName().equals("show.functional.exchanges.exchange.items.filter")) {
                showFEEI = true;
            }
            if (filter.getName().equals("show.functional.exchanges.parameters.filter")) {
                showFEParams = true;
            }
            if (filter.getName().equals("show.component.exchanges.exchange.items.filter")) {
                showCEEI = true;
            }
            if (filter.getName().equals("show.functional.exchanges.exchange.items.parameters.filter")) {
                showFEEIParams = true;
            }
            if (filter.getName().equals("show.ce.param.filter")) {
                showCEParams = true;
            }
            if (filter.getName().equals("show.ce.ei.param.filter")) {
                showCEEIParams = true;
            }
            if (filter.getName().equals("show.exchange.context.filter")) {
                showExchangeContext = true;
            }
            if (filter.getName().equals("show.ce.exchange.context.filter")) {
                showExchangeContext = true;
                showCEExchangeContext = true;
            }
            if (filter.getName().equals("show.fe.exchange.context.filter")) {
                showExchangeContext = true;
                showFEExchangeContext = true;
            }
            if (filter.getName().equals("show.ei.exchange.context.filter")) {
                showExchangeContext = true;
            }
            if (!filter.getName().equals("hide.call.arguments.filter")) continue;
            hideCallArguments = true;
        }
        StringBuilder result = new StringBuilder();
        if ("Component Interfaces Scenario".equals(diagram.getDescription().getName())) {
            result.append(this.getMessageName(message, hideCallArguments));
            if (showExchangeContext) {
                result.append(" ");
                ScenarioService.appendExchangeContext(message, result);
            }
            return result.toString().trim();
        }
        MessageEnd end = message.getSendingEnd() == null ? message.getReceivingEnd() : message.getSendingEnd();
        Event event = end.getEvent();
        AbstractEventOperation op = null;
        if (event != null) {
            if (event instanceof EventSentOperation) {
                EventSentOperation eso = (EventSentOperation)event;
                op = eso.getOperation();
            } else if (event instanceof EventReceiptOperation) {
                EventReceiptOperation ero = (EventReceiptOperation)event;
                op = ero.getOperation();
            }
        }
        if (op != null && showCEParams) {
            return ScenarioService.getShowCEParams(op, (List<? extends AbstractExchangeItem>)eiOnMessage);
        }
        if (op != null && showCEEIParams) {
            return ScenarioService.getShowCEEIParams(op, (List<? extends AbstractExchangeItem>)eiOnMessage);
        }
        if (op != null && showCEEI) {
            return ScenarioService.getCEEIMessageName(op, (List<? extends AbstractExchangeItem>)eiOnMessage);
        }
        if (op != null && showFEEI) {
            return ScenarioService.getFEEIMessageName(op, (List<? extends AbstractExchangeItem>)eiOnMessage);
        }
        if (op != null && (showFEEIParams || showFEParams)) {
            return ScenarioService.showFeEiParams(op, showFEEIParams, (List<? extends AbstractExchangeItem>)eiOnMessage);
        }
        if (showExchangeItems || showFunctionalExchanges || showExchangeItemsParameters) {
            if (op instanceof FunctionalExchange) {
                if (showFunctionalExchanges || ((FunctionalExchange)op).getExchangedItems().isEmpty()) {
                    result.append(ScenarioService.getSafeName((AbstractNamedElement)op));
                } else {
                    ScenarioService.appendExchangeItems((List<? extends AbstractExchangeItem>)eiOnMessage, op, showExchangeItemsParameters, result);
                }
            } else if (op instanceof ComponentExchange) {
                ComponentExchange ce = (ComponentExchange)op;
                if (showFunctionalExchanges) {
                    this.appendFunctionalExchanges((AbstractEventOperation)ce, result);
                } else {
                    ScenarioService.appendExchangeItems((List<? extends AbstractExchangeItem>)eiOnMessage, op, showExchangeItemsParameters, result);
                }
            } else {
                result.append(ScenarioService.getSafeName((AbstractNamedElement)message));
                result.append(" ");
            }
        } else if (showExchangeContext) {
            if (showCEExchangeContext && op instanceof ComponentExchange) {
                result.append(ScenarioService.getSafeName((AbstractNamedElement)op));
            } else if (showFEExchangeContext) {
                this.appendFunctionalExchanges(op, result);
            }
            result.append(" ");
            ScenarioService.appendExchangeContext(message, result);
        } else {
            result.append(ScenarioService.getSafeName((AbstractNamedElement)message));
            result.append(" ");
        }
        return result.toString().trim();
    }

    private StringBuilder appendFunctionalExchanges(AbstractEventOperation op, StringBuilder builder) {
        if (op instanceof FunctionalExchange) {
            builder.append(ScenarioService.getSafeName((AbstractNamedElement)op));
        } else if (op instanceof ComponentExchange) {
            ComponentExchange ce = (ComponentExchange)op;
            int size = ce.getOwnedComponentExchangeFunctionalExchangeAllocations().size();
            int index = 0;
            for (ComponentExchangeFunctionalExchangeAllocation fea : ce.getOwnedComponentExchangeFunctionalExchangeAllocations()) {
                builder.append(ScenarioService.getSafeName((AbstractNamedElement)fea.getAllocatedFunctionalExchange()));
                if (++index >= size) continue;
                builder.append(", ");
            }
        }
        return builder;
    }

    private static void appendExchangeItems(List<? extends AbstractExchangeItem> eiOnMessage, AbstractEventOperation op, boolean showExchangeItemParameters, StringBuilder builder) {
        EList eiOnOperation = Collections.emptyList();
        if (op instanceof ComponentExchange) {
            eiOnOperation = ((ComponentExchange)op).getConvoyedInformations();
        } else if (op instanceof FunctionalExchange) {
            eiOnOperation = ((FunctionalExchange)op).getExchangedItems();
        }
        List<? extends AbstractExchangeItem> selectEIList = ScenarioService.firstNonEmpty(eiOnMessage, (List<? extends AbstractExchangeItem>)eiOnOperation);
        if (selectEIList.size() != 0) {
            builder.append("[");
        }
        int index = 0;
        for (AbstractExchangeItem abstractExchangeItem : selectEIList) {
            builder.append(InformationServices.getEILabel(abstractExchangeItem, showExchangeItemParameters));
            if (++index >= selectEIList.size()) continue;
            builder.append(", ");
        }
        if (selectEIList.size() != 0) {
            builder.append("]");
        }
    }

    private static void appendExchangeContext(SequenceMessage message, StringBuilder builder) {
        builder.append(String.format("{%s}", message.getExchangeContext() == null ? EMPTY_STRING : CapellaServices.getService().getConstraintLabel(message.getExchangeContext())));
    }

    private static String getSafeName(AbstractNamedElement fe) {
        if (EMPTY_STRING.equals(fe.getName()) || fe.getName() == null) {
            return "<undefined>";
        }
        return EObjectExt.getText((EObject)fe);
    }

    public static String getShowCEEIParams(AbstractEventOperation op, List<? extends AbstractExchangeItem> eiOnMessage) {
        if (!(op instanceof ComponentExchange)) {
            return ScenarioService.getFEEIMessageName(op, eiOnMessage);
        }
        ComponentExchange ce = (ComponentExchange)op;
        StringBuilder result = new StringBuilder();
        result.append(ScenarioService.getSafeName((AbstractNamedElement)op));
        result.append(" ");
        result.append("[");
        int indice = 0;
        List<? extends AbstractExchangeItem> selectEIList = ScenarioService.firstNonEmpty(eiOnMessage, (List<? extends AbstractExchangeItem>)ce.getConvoyedInformations());
        for (AbstractExchangeItem abstractExchangeItem : selectEIList) {
            result.append(InformationServices.getEILabel(abstractExchangeItem, true));
            if (++indice >= selectEIList.size()) continue;
            result.append(", ");
        }
        result.append("]");
        return result.toString();
    }

    public static String getShowCEParams(AbstractEventOperation op, List<? extends AbstractExchangeItem> eiOnMessage) {
        if (op instanceof FunctionalExchange) {
            return EMPTY_STRING;
        }
        ComponentExchange ce = (ComponentExchange)op;
        StringBuilder result = new StringBuilder();
        List<? extends AbstractExchangeItem> selectEIList = ScenarioService.firstNonEmpty(eiOnMessage, (List<? extends AbstractExchangeItem>)ce.getConvoyedInformations());
        result.append(ScenarioService.getSafeName((AbstractNamedElement)ce));
        result.append("(");
        int indice = 0;
        ArrayList eies = new ArrayList();
        for (AbstractExchangeItem abstractExchangeItem : selectEIList) {
            if (!(abstractExchangeItem instanceof ExchangeItem)) continue;
            ExchangeItem ei = (ExchangeItem)abstractExchangeItem;
            eies.addAll(ei.getOwnedElements());
        }
        for (ExchangeItemElement exchangeItemElement : eies) {
            AbstractType type = exchangeItemElement.getAbstractType();
            if (type != null) {
                result.append(type.getName());
            } else {
                result.append("<undefined>");
            }
            if (++indice >= eies.size()) continue;
            result.append(", ");
        }
        result.append(")");
        return result.toString();
    }

    public static String showFeEiParams(AbstractEventOperation op, boolean showEIName, List<? extends AbstractExchangeItem> eiOnMessage) {
        FunctionalExchange fe = null;
        if (op instanceof ComponentExchange) {
            for (ComponentExchangeFunctionalExchangeAllocation fea : ((ComponentExchange)op).getOwnedComponentExchangeFunctionalExchangeAllocations()) {
                fe = fea.getAllocatedFunctionalExchange();
            }
        } else {
            fe = (FunctionalExchange)op;
        }
        StringBuilder result = new StringBuilder();
        List<? extends AbstractExchangeItem> selectEIList = ScenarioService.firstNonEmpty(eiOnMessage, (List<? extends AbstractExchangeItem>)(fe != null ? fe.getExchangedItems() : Collections.emptyList()));
        result.append(ScenarioService.getSafeName((AbstractNamedElement)fe));
        int indice = 0;
        if (showEIName) {
            result.append(" ");
            result.append("[");
            for (AbstractExchangeItem abstractExchangeItem : selectEIList) {
                result.append(InformationServices.getEILabel(abstractExchangeItem, true));
                if (++indice >= selectEIList.size()) continue;
                result.append(", ");
            }
            result.append("]");
        } else {
            result.append("(");
            ArrayList arrayList = new ArrayList();
            for (AbstractExchangeItem abstractExchangeItem : selectEIList) {
                if (!(abstractExchangeItem instanceof ExchangeItem)) continue;
                ExchangeItem ei = (ExchangeItem)abstractExchangeItem;
                arrayList.addAll(ei.getOwnedElements());
            }
            for (ExchangeItemElement exchangeItemElement : arrayList) {
                AbstractType type = exchangeItemElement.getAbstractType();
                if (type != null) {
                    result.append(type.getName());
                } else {
                    result.append("<undefined>");
                }
                if (++indice >= arrayList.size()) continue;
                result.append(", ");
            }
            result.append(")");
        }
        return result.toString();
    }

    public static String getFEEIMessageName(AbstractEventOperation op, List<? extends AbstractExchangeItem> eiOnMessage) {
        List<? extends AbstractExchangeItem> selectEIList;
        StringBuilder result = new StringBuilder();
        if (op instanceof FunctionalExchange) {
            result.append(ScenarioService.getSafeName((AbstractNamedElement)op));
            selectEIList = ScenarioService.firstNonEmpty(eiOnMessage, (List<? extends AbstractExchangeItem>)((FunctionalExchange)op).getExchangedItems());
        } else {
            ComponentExchange ce = (ComponentExchange)op;
            ArrayList arrayList = new ArrayList();
            int indice = 0;
            for (ComponentExchangeFunctionalExchangeAllocation fea : ce.getOwnedComponentExchangeFunctionalExchangeAllocations()) {
                FunctionalExchange fe = fea.getAllocatedFunctionalExchange();
                result.append(ScenarioService.getSafeName((AbstractNamedElement)fe));
                arrayList.addAll(fe.getExchangedItems());
                if (++indice >= ce.getOwnedComponentExchangeFunctionalExchangeAllocations().size()) continue;
                result.append(", ");
            }
            selectEIList = ScenarioService.firstNonEmpty(eiOnMessage, arrayList);
        }
        result.append(" ");
        result.append("[");
        int indice = 0;
        for (AbstractExchangeItem abstractExchangeItem : selectEIList) {
            result.append(InformationServices.getEILabel(abstractExchangeItem, false));
            if (++indice >= selectEIList.size()) continue;
            result.append(", ");
        }
        result.append("]");
        return result.toString();
    }

    public static String getCEEIMessageName(AbstractEventOperation op, List<? extends AbstractExchangeItem> eiOnMessage) {
        if (!(op instanceof ComponentExchange)) {
            return ScenarioService.getFEEIMessageName(op, eiOnMessage);
        }
        ComponentExchange ce = (ComponentExchange)op;
        StringBuilder result = new StringBuilder();
        result.append(ScenarioService.getSafeName((AbstractNamedElement)op));
        result.append(" ");
        result.append("[");
        int indice = 0;
        List<? extends AbstractExchangeItem> selectEIList = ScenarioService.firstNonEmpty(eiOnMessage, (List<? extends AbstractExchangeItem>)ce.getConvoyedInformations());
        for (AbstractExchangeItem abstractExchangeItem : selectEIList) {
            result.append(InformationServices.getEILabel(abstractExchangeItem, false));
            if (++indice >= selectEIList.size()) continue;
            result.append(", ");
        }
        result.append("]");
        return result.toString();
    }

    private static List<? extends AbstractExchangeItem> firstNonEmpty(List<? extends AbstractExchangeItem> first, List<? extends AbstractExchangeItem> second) {
        return !first.isEmpty() ? first : second;
    }

    public String getMessageName(SequenceMessage message, boolean hideParameters) {
        EventReceiptOperation event;
        AbstractEventOperation messageOperation = null;
        if (InterfaceHelper.isSharedDataAccess((SequenceMessage)message)) {
            return SequenceMessageExt.getMessageNameForSharedDataAccess((SequenceMessage)message);
        }
        if (message == null) {
            return EMPTY_STRING;
        }
        if (message.getKind() == MessageKind.REPLY && hideParameters) {
            return EMPTY_STRING;
        }
        Event associatedEvent = message.getReceivingEnd() != null ? message.getReceivingEnd().getEvent() : message.getSendingEnd().getEvent();
        if (associatedEvent instanceof EventReceiptOperation && (event = (EventReceiptOperation)associatedEvent).getOperation() != null) {
            messageOperation = event.getOperation();
        }
        if (associatedEvent instanceof EventSentOperation && (event = (EventSentOperation)associatedEvent).getOperation() != null) {
            messageOperation = event.getOperation();
        }
        if (messageOperation == null) {
            return message.getName();
        }
        StringBuilder sb = new StringBuilder();
        if (messageOperation instanceof ExchangeItemAllocation) {
            messageOperation = ((ExchangeItemAllocation)messageOperation).getAllocatedItem();
        }
        int nbParameters = 0;
        int nbOutParameters = 0;
        if (messageOperation instanceof ExchangeItem) {
            ExchangeItem item = (ExchangeItem)messageOperation;
            for (Iterator element : item.getOwnedElements()) {
                if (element.getKind() != ElementKind.MEMBER) continue;
                ++nbParameters;
                if (element.getDirection() != ParameterDirection.OUT && element.getDirection() != ParameterDirection.INOUT && element.getDirection() != ParameterDirection.RETURN) continue;
                ++nbOutParameters;
            }
        } else if (messageOperation instanceof Operation) {
            for (Parameter param : ((Operation)messageOperation).getOwnedParameters()) {
                ++nbParameters;
                if (param.getDirection() != ParameterDirection.OUT && param.getDirection() != ParameterDirection.INOUT && param.getDirection() != ParameterDirection.RETURN) continue;
                ++nbOutParameters;
            }
        }
        if (!hideParameters && message.getKind() == MessageKind.REPLY && nbOutParameters == 0) {
            sb.append(messageOperation.getName());
        }
        if (message.getKind() != MessageKind.REPLY) {
            sb.append(messageOperation.getName());
        }
        if (!hideParameters) {
            sb.append("(");
            ArrayList<String> paramNames = new ArrayList<String>(nbParameters);
            if (messageOperation instanceof ExchangeItem) {
                ExchangeItem item = (ExchangeItem)messageOperation;
                for (Iterator element : item.getOwnedElements()) {
                    String name;
                    if (element.getKind() != ElementKind.MEMBER || (name = this.getNameParameter((NamedElement)element, (AbstractType)element.getType(), element.getDirection(), message)) == null) continue;
                    paramNames.add(name);
                }
            } else if (messageOperation instanceof Operation) {
                for (Parameter param : ((Operation)messageOperation).getOwnedParameters()) {
                    String name = this.getNameParameter((NamedElement)param, param.getAbstractType(), param.getDirection(), message);
                    if (name == null) continue;
                    paramNames.add(name);
                }
            }
            int numParam = 0;
            for (String name : paramNames) {
                sb.append(name);
                if (numParam < paramNames.size() - 1) {
                    sb.append(", ");
                }
                ++numParam;
            }
            sb.append(")");
        }
        return sb.toString();
    }

    private String getNameParameter(NamedElement parameter, AbstractType type, ParameterDirection direction, SequenceMessage message) {
        String name = null;
        if (message.getKind() == MessageKind.REPLY && (direction == ParameterDirection.OUT || direction == ParameterDirection.INOUT)) {
            name = parameter.getName();
        } else if (message.getKind() == MessageKind.REPLY && direction == ParameterDirection.RETURN) {
            name = type == null ? EMPTY_STRING : type.getName();
        } else if (!(message.getKind() != MessageKind.SYNCHRONOUS_CALL && message.getKind() != MessageKind.ASYNCHRONOUS_CALL || direction != ParameterDirection.IN && direction != ParameterDirection.INOUT)) {
            name = parameter.getName();
        }
        return name;
    }

    public String getMessagePosition(SequenceMessage message) {
        if (message == null) {
            return "?";
        }
        if (message.getKind() == MessageKind.REPLY) {
            return this.getMessagePosition(this.getMessageOpposite((EObject)message));
        }
        Scenario scenario = (Scenario)message.eContainer();
        int basicPos = scenario.getOwnedMessages().indexOf((Object)message);
        int pos = basicPos + 1;
        for (SequenceMessage ownedMessage : scenario.getOwnedMessages()) {
            if (ownedMessage.getKind() == MessageKind.REPLY) {
                --pos;
            }
            if (ownedMessage == message) break;
        }
        return Integer.toString(pos);
    }

    public MessageEnd getPreviousMessageEnd(InteractionFragment end) {
        if (end instanceof MessageEnd) {
            return (MessageEnd)end;
        }
        int index = ((Scenario)end.eContainer()).getOwnedInteractionFragments().indexOf((Object)end);
        if (index == 0) {
            return null;
        }
        return this.getPreviousMessageEnd((InteractionFragment)((Scenario)end.eContainer()).getOwnedInteractionFragments().get(index - 1));
    }

    public String newCallName(SequenceMessage message) {
        return "Message Call";
    }

    public Collection<StateFragment> getInteractionStatesOnExecution(InstanceRole ir) {
        return ScenarioCache.getInstance().getStateFragmentSemanticCandidates(ir, (EObject)ir);
    }

    public Collection<StateFragment> getInteractionStatesOnExecution(Execution exec) {
        return ScenarioCache.getInstance().getStateFragmentSemanticCandidates(SequenceDiagramServices.currentInstanceRole((EObject)exec), (EObject)exec);
    }

    public List<InstanceRole> getCoveredFromAbstractFragment(AbstractFragment af) {
        return af.getStart().getCoveredInstanceRoles();
    }

    public InstanceRole getCoveredFromExecOrIR(EObject context, EObject container) {
        if (container instanceof Execution) {
            Execution exec = (Execution)container;
            return exec.getCovered();
        }
        return (InstanceRole)container;
    }

    public InteractionFragment getOperandBegin(InteractionOperand operand) {
        return operand;
    }

    public InteractionFragment getOperandEnd(InteractionOperand operand) {
        ScenarioCache.OperandContext operandContext = ScenarioCache.getInstance().getOperandContext(operand);
        return operandContext.getOperandEnd();
    }

    public boolean isFunctionalExecution(Execution execution) {
        MessageEnd me;
        InteractionFragment end = execution.getStart();
        if (end instanceof MessageEnd && (me = (MessageEnd)end).getEvent() instanceof EventReceiptOperation) {
            EventReceiptOperation ero = (EventReceiptOperation)me.getEvent();
            return ero.getOperation() instanceof FunctionalExchange;
        }
        return false;
    }

    public List<EObject> getReferenceScope(Scenario scenario) {
        ArrayList<EObject> availableElements = new ArrayList<EObject>();
        IBusinessQuery query = BusinessQueriesProvider.getInstance().getContribution(InteractionPackage.Literals.INTERACTION_USE, (EStructuralFeature)InteractionPackage.Literals.INTERACTION_USE__REFERENCED_SCENARIO);
        if (query != null) {
            availableElements.addAll(query.getAvailableElements((EObject)scenario));
        }
        return availableElements;
    }

    public Collection<AbstractState> getISStateModes(AbstractInstance instance) {
        return ScenarioExt.getAvailableStateModeStateFragment((AbstractInstance)instance);
    }

    public Collection<AbstractFunction> getFunctionsForStateAtOA(EObject context, AbstractInstance instance) {
        return ScenarioExt.getAvailableFunctionsStateFragment((AbstractInstance)instance);
    }

    public Collection<AbstractFunction> getFunctionsForState(EObject context, Component component) {
        return ScenarioExt.getAvailableFunctionsStateFragment((Component)component);
    }

    public String getOperandLabel(InteractionOperand operand) {
        StringBuilder builder = null;
        if (operand.getGuard() != null) {
            builder = new StringBuilder("[ ");
            builder.append(CapellaServices.getService().getConstraintLabel(operand.getGuard())).append(" ]");
        }
        return builder == null ? EMPTY_STRING : builder.toString();
    }

    public boolean isValidScenarioDrop(EObject context, Scenario scenario, EObject element) {
        if (element instanceof Component) {
            for (InstanceRole ir : scenario.getOwnedInstanceRoles()) {
                if (ir.getRepresentedInstance() == null || ir.getRepresentedInstance().getAbstractType() == null || !ir.getRepresentedInstance().getAbstractType().equals(element)) continue;
                return false;
            }
        } else if (element instanceof AbstractFunction || element instanceof Role) {
            for (InstanceRole ir : scenario.getOwnedInstanceRoles()) {
                if (!ir.getRepresentedInstance().equals(element)) continue;
                return false;
            }
        }
        BlockArchitecture architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)scenario);
        BlockArchitecture architecture2 = BlockArchitectureExt.getRootBlockArchitecture((EObject)element);
        if (!architecture.equals(architecture2)) {
            return false;
        }
        if (scenario.getKind() == ScenarioKind.DATA_FLOW || scenario.getKind() == ScenarioKind.INTERFACE) {
            return element instanceof Component && this.isCorrectComponentLevel(context, element);
        }
        if (scenario.getKind() == ScenarioKind.FUNCTIONAL) {
            return element instanceof AbstractFunction;
        }
        if (scenario.getKind() == ScenarioKind.INTERACTION) {
            if (scenario.getOwnedInstanceRoles().size() != 0) {
                InstanceRole firstIr = (InstanceRole)scenario.getOwnedInstanceRoles().get(0);
                if (firstIr.getRepresentedInstance() instanceof OperationalActivity) {
                    return element instanceof OperationalActivity;
                }
                return element instanceof Entity || element instanceof Role;
            }
            return element instanceof Entity || element instanceof Role || element instanceof OperationalActivity;
        }
        return true;
    }

    private boolean isCorrectComponentLevel(EObject context, EObject element) {
        if (ComponentExt.isActor((EObject)element)) {
            return true;
        }
        Component referenceComponent = null;
        EObject container = context;
        while (referenceComponent == null && container != null) {
            if (!((container = container.eContainer()) instanceof Component)) continue;
            referenceComponent = (Component)container;
        }
        if (referenceComponent != null) {
            return ComponentExt.getAllSubUsedComponents(referenceComponent).contains(element);
        }
        return true;
    }

    public List<EObject> getExchangeContextsToInsertInDiagram(EObject context) {
        DDiagramElement element;
        EObject target;
        ArrayList<EObject> result = new ArrayList<EObject>(0);
        if (context instanceof DDiagram) {
            DSemanticDecorator diagram = (DSemanticDecorator)context;
            EObject target2 = diagram.getTarget();
            if (target2 != null && target2 instanceof Scenario) {
                for (SequenceMessage msg : ((Scenario)target2).getOwnedMessages()) {
                    if (msg.getExchangeContext() == null || result.contains(msg.getExchangeContext())) continue;
                    result.add((EObject)msg.getExchangeContext());
                }
            }
        } else if (context instanceof DDiagramElement && (target = (element = (DDiagramElement)context).getTarget()) != null && target instanceof SequenceMessage && ((SequenceMessage)target).getExchangeContext() != null) {
            result.add((EObject)((SequenceMessage)target).getExchangeContext());
        }
        return result;
    }

    public List<EObject> getVisibleExchangeContexts(DSemanticDecorator context, DDiagram diagram) {
        HashSet<Constraint> allPresentConstraints = new HashSet<Constraint>();
        HashSet<Constraint> allAvailableExchangeContexts = new HashSet<Constraint>();
        for (DDiagramElement elem : diagram.getDiagramElements()) {
            if (elem.getTarget() instanceof Constraint) {
                allPresentConstraints.add((Constraint)elem.getTarget());
            } else if (elem.getTarget() instanceof SequenceMessage && ((SequenceMessage)elem.getTarget()).getExchangeContext() != null && (context == diagram || context == elem)) {
                allAvailableExchangeContexts.add(((SequenceMessage)elem.getTarget()).getExchangeContext());
            }
            allPresentConstraints.retainAll(allAvailableExchangeContexts);
        }
        return new ArrayList<EObject>(allPresentConstraints);
    }

    public String getOperatorLabel(EObject context) {
        String operatorkind = null;
        if (context instanceof CombinedFragment) {
            CombinedFragment combfragment = (CombinedFragment)context;
            operatorkind = " " + combfragment.getOperator().getLiteral();
        }
        return operatorkind;
    }

    public String addScenarioPrefix(String name, String prefix) {
        if (!name.startsWith(prefix)) {
            name = String.valueOf(prefix) + " " + name;
        }
        return name;
    }

    public List<Part> getAllMultiInstanceRoleParts(Scenario scenario) {
        BlockArchitecture ba = BlockArchitectureExt.getRootBlockArchitecture((EObject)scenario);
        ArrayList<ComponentPkg> roots = new ArrayList<ComponentPkg>();
        roots.add(BlockArchitectureExt.getComponentPkg((BlockArchitecture)ba, (boolean)false));
        return this.getAllParts(Collections2.filter(roots, (Predicate)Predicates.notNull()));
    }

    public List<Part> getAllMultiInstanceRoleComponentParts(Scenario scenario) {
        return new ArrayList<Part>(Collections2.filter(this.getAllMultiInstanceRoleParts(scenario), (Predicate)new Predicate<Part>(){

            public boolean apply(Part input) {
                return !ComponentExt.isActor((EObject)input);
            }
        }));
    }

    public List<Part> getAllMultiInstanceRoleActorParts(Scenario scenario) {
        return new ArrayList<Part>(Collections2.filter(this.getAllMultiInstanceRoleParts(scenario), (Predicate)new Predicate<Part>(){

            public boolean apply(Part input) {
                return ComponentExt.isActor((EObject)input);
            }
        }));
    }

    private List<Part> getAllParts(Collection<EObject> roots) {
        ArrayList<Part> result = new ArrayList<Part>();
        TreeIterator it = EcoreUtil.getAllContents(roots);
        while (it.hasNext()) {
            EObject next = (EObject)it.next();
            if (!(next instanceof Part)) continue;
            result.add((Part)next);
        }
        return result;
    }
}

