/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.magicdraw.osgi.adaptor;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osgi.container.Module;
import org.eclipse.osgi.container.ModuleRevision;
import org.eclipse.osgi.internal.hookregistry.ClassLoaderHook;
import org.eclipse.osgi.internal.hookregistry.HookConfigurator;
import org.eclipse.osgi.internal.hookregistry.HookRegistry;
import org.eclipse.osgi.internal.loader.classpath.ClasspathEntry;
import org.eclipse.osgi.internal.loader.classpath.ClasspathManager;
import org.eclipse.osgi.storage.BundleInfo;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.BundleException;

public class PathFromPropertyLoadingHook
extends ClassLoaderHook
implements HookConfigurator {
    private static final String PATH_FROM_PROPERTY = "pathfromproperty";
    private static final String PATH_FROM_PROPERTY_SCHEME = "pathfromproperty:";
    private static final int PATH_FROM_PROPERTY_SCHEME_LENGTH = "pathfromproperty:".length();
    private static final String PATH_FROM_PROPERTY_HEADER = "Bundle-ClassPath: pathfromproperty";
    private static final String EXCLUDE_DIRECTIVE = "exclude";
    private static final String[] EMPTY_CP_EXCLUDES = new String[0];
    private static final Matcher[] EMPTY_CP_EXCLUDE_MATCHERS = new Matcher[0];
    private static final Pattern CLASSPATH_SEPARATOR_PATTERN = Pattern.compile(" +");

    public void addHooks(HookRegistry hookRegistry) {
        hookRegistry.addClassLoaderHook((ClassLoaderHook)new PathFromPropertyLoadingHook());
    }

    public boolean addClassPathEntry(ArrayList<ClasspathEntry> cpEntries, String cp, ClasspathManager hostmanager, BundleInfo.Generation sourceGeneration) {
        ManifestElement[] cpPropertyElements;
        block15: {
            String cpPropertyManifest;
            block14: {
                block13: {
                    if (cp.startsWith(PATH_FROM_PROPERTY_SCHEME)) break block13;
                    return false;
                }
                cpPropertyManifest = cp.substring(PATH_FROM_PROPERTY_SCHEME_LENGTH);
                if (cpPropertyManifest.length() != 0) break block14;
                return true;
            }
            cpPropertyElements = ManifestElement.parseHeader((String)PATH_FROM_PROPERTY_HEADER, (String)cpPropertyManifest);
            if (cpPropertyElements != null && cpPropertyElements.length != 0) break block15;
            return true;
        }
        try {
            Set<File> cpFiles = null;
            int i = 0;
            while (i < cpPropertyElements.length) {
                Matcher[] cpExcludeMatchers;
                ManifestElement cpPropertyElement = cpPropertyElements[i];
                String[] cpExcludes = cpPropertyElement.getDirectives(EXCLUDE_DIRECTIVE);
                if (cpExcludes != null) {
                    cpExcludeMatchers = new Matcher[cpExcludes.length];
                } else {
                    cpExcludes = EMPTY_CP_EXCLUDES;
                    cpExcludeMatchers = EMPTY_CP_EXCLUDE_MATCHERS;
                }
                String[] cpProperties = cpPropertyElement.getValueComponents();
                int j = 0;
                while (j < cpProperties.length) {
                    String cpFromProperty = System.getProperty(cpProperties[j]);
                    if (cpFromProperty != null) {
                        if (cpFromProperty.startsWith("$")) {
                            cpFromProperty = System.getProperty(cpFromProperty.substring(1));
                        } else if (cpFromProperty.startsWith("file:")) {
                            cpFromProperty = PathFromPropertyLoadingHook.loadClasspathFromPropertyFile(cpFromProperty);
                        }
                        cpFiles = PathFromPropertyLoadingHook.tryAddClassPathEntry(cpEntries, cpFiles, cpFromProperty, cpExcludes, cpExcludeMatchers, hostmanager, sourceGeneration);
                    }
                    ++j;
                }
                ++i;
            }
            return true;
        }
        catch (BundleException e) {
            throw new RuntimeException(e);
        }
    }

    private static String loadClasspathFromPropertyFile(String cpFromProperty) {
        try {
            String cpUriString = cpFromProperty.startsWith("file:/") ? cpFromProperty : cpFromProperty.substring(5);
            URI cpUri = new File(".").toURI().resolve(new URI(cpUriString));
            File cpPropertyFile = new File(new URI(cpUri.getScheme(), cpUri.getHost(), cpUri.getPath(), null));
            String cpPropName = cpUri.getFragment();
            if (cpPropName == null) {
                return cpFromProperty;
            }
            Properties cpLoadedProperties = new Properties();
            Throwable throwable = null;
            Object var7_8 = null;
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(cpPropertyFile));){
                cpLoadedProperties.load(in);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            String relativeCp = cpLoadedProperties.getProperty(cpPropName);
            if (relativeCp == null) {
                return cpFromProperty;
            }
            String base = PathFromPropertyLoadingHook.getClasspathBase(cpUri);
            StringTokenizer cpTokenizer = new StringTokenizer(relativeCp, ":");
            StringBuilder cpFromPropertyBuilder = new StringBuilder();
            while (cpTokenizer.hasMoreTokens()) {
                String pathElement = cpTokenizer.nextToken();
                cpFromPropertyBuilder.append(new File(base, pathElement).getPath());
                if (!cpTokenizer.hasMoreTokens()) continue;
                cpFromPropertyBuilder.append(File.pathSeparator);
            }
            return cpFromPropertyBuilder.toString();
        }
        catch (IOException | URISyntaxException exception) {
            return cpFromProperty;
        }
    }

    private static String getClasspathBase(URI cpUri) throws UnsupportedEncodingException {
        String decodedQuery;
        String rawQuery = cpUri.getRawQuery();
        if (rawQuery != null && (decodedQuery = PathFromPropertyLoadingHook.decodeUrlUtf8(rawQuery)).startsWith("base=")) {
            return decodedQuery.substring("base=".length());
        }
        return null;
    }

    private static String decodeUrlUtf8(String s) throws UnsupportedEncodingException {
        return URLDecoder.decode(s, "UTF-8");
    }

    private static Set<File> tryAddClassPathEntry(ArrayList<ClasspathEntry> cpEntries, Set<File> cpFilesIn, String cpFromProperty, String[] cpExcludes, Matcher[] cpExcludeMatchers, ClasspathManager hostmanager, BundleInfo.Generation sourceGeneration) {
        Set<File> cpFilesOut = cpFilesIn;
        StringTokenizer classPathTokenizer = new StringTokenizer(cpFromProperty, File.pathSeparator);
        block0: while (classPathTokenizer.hasMoreTokens()) {
            String pathElement = classPathTokenizer.nextToken();
            String canonicalPathElement = pathElement.replace(File.separatorChar, '/');
            int i = 0;
            while (i < cpExcludes.length) {
                Matcher excludeMatcher = cpExcludeMatchers[i];
                if (excludeMatcher == null) {
                    cpExcludeMatchers[i] = excludeMatcher = Pattern.compile(cpExcludes[i]).matcher("");
                }
                excludeMatcher.reset(canonicalPathElement);
                if (excludeMatcher.find()) continue block0;
                ++i;
            }
            cpFilesOut = PathFromPropertyLoadingHook.addPathToEntries(PathFromPropertyLoadingHook.toEntryFile(pathElement), cpEntries, cpFilesOut, hostmanager, sourceGeneration);
        }
        return cpFilesOut;
    }

    private static Set<File> addPathToEntries(File pathElementFile, ArrayList<ClasspathEntry> cpEntries, Set<File> cpFilesIn, ClasspathManager hostmanager, BundleInfo.Generation sourceGeneration) {
        Set<File> cpFilesOut = cpFilesIn;
        ClasspathEntry cpEntryToAdd = hostmanager.getExternalClassPath(pathElementFile.getPath(), sourceGeneration);
        if (cpEntryToAdd == null) {
            return cpFilesOut;
        }
        if (cpFilesOut == null) {
            cpFilesOut = new HashSet<File>();
            int j = 0;
            int cpEntriesSize = cpEntries.size();
            while (j < cpEntriesSize) {
                cpFilesOut.add(cpEntries.get(j).getBundleFile().getBaseFile());
                ++j;
            }
            PathFromPropertyLoadingHook.addInstalledBundlesToCpFiles(sourceGeneration, cpFilesOut);
        }
        if (cpFilesOut.add(cpEntryToAdd.getBundleFile().getBaseFile())) {
            cpEntries.add(cpEntryToAdd);
            cpFilesOut = PathFromPropertyLoadingHook.tryAddClassPathEntriesFromManifest(pathElementFile, cpEntries, cpFilesOut, hostmanager, sourceGeneration);
        }
        return cpFilesOut;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Set<File> tryAddClassPathEntriesFromManifest(File pathElementFile, ArrayList<ClasspathEntry> cpEntries, Set<File> cpFilesIn, ClasspathManager hostmanager, BundleInfo.Generation sourceGeneration) {
        Set<File> cpFilesOut = cpFilesIn;
        if (!pathElementFile.isFile()) {
            return cpFilesOut;
        }
        try {
            Throwable throwable = null;
            Object var7_8 = null;
            try {
                JarFile pathElementJar = new JarFile(pathElementFile);
                try {
                    Manifest jarManifest = pathElementJar.getManifest();
                    if (jarManifest == null) {
                        return cpFilesOut;
                    }
                    String classPath = jarManifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
                    if (classPath == null) {
                        return cpFilesOut;
                    }
                    URI pathElementUri = pathElementFile.toURI();
                    Iterator i = CLASSPATH_SEPARATOR_PATTERN.splitAsStream(classPath).map(pathElementUri::resolve).iterator();
                    while (true) {
                        if (!i.hasNext()) {
                            return cpFilesOut;
                        }
                        URI classPathUri = (URI)i.next();
                        cpFilesOut = PathFromPropertyLoadingHook.addPathToEntries(PathFromPropertyLoadingHook.toEntryFile(classPathUri), cpEntries, cpFilesOut, hostmanager, sourceGeneration);
                    }
                }
                finally {
                    if (pathElementJar == null) return cpFilesOut;
                    pathElementJar.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException iOException) {}
        return cpFilesOut;
    }

    private static void addInstalledBundlesToCpFiles(BundleInfo.Generation sourceGeneration, Set<File> cpFilesOut) {
        List installedModules = sourceGeneration.getBundleInfo().getStorage().getModuleContainer().getModules();
        int i = 0;
        while (i < installedModules.size()) {
            Module module = (Module)installedModules.get(i);
            PathFromPropertyLoadingHook.addCpFileFromBundle(module.getCurrentRevision(), cpFilesOut);
            ++i;
        }
    }

    private static void addCpFileFromBundle(ModuleRevision moduleRevision, Set<File> cpFilesOut) {
        BundleInfo.Generation generation = (BundleInfo.Generation)moduleRevision.getRevisionInfo();
        cpFilesOut.add(generation.getBundleFile().getBaseFile());
    }

    private static File toEntryFile(String pathElement) {
        try {
            return Paths.get(pathElement, new String[0]).toRealPath(new LinkOption[0]).toFile();
        }
        catch (IOException iOException) {
            return new File(pathElement).getAbsoluteFile();
        }
    }

    private static File toEntryFile(URI pathElement) {
        try {
            return Paths.get(pathElement).toRealPath(new LinkOption[0]).toFile();
        }
        catch (IOException iOException) {
            return new File(pathElement).getAbsoluteFile();
        }
    }
}

