/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.accessibility.com.win32.impl;

import com.ibm.accessibility.com.win32.ComException;
import com.ibm.accessibility.com.win32.IUnknown;
import com.ibm.accessibility.com.win32.ResourceManager;
import com.ibm.accessibility.com.win32.impl.IDispatchImpl;
import com.ibm.accessibility.com.win32.impl.IOleContainerImpl;
import com.ibm.accessibility.com.win32.impl.IResourceImpl;
import java.util.UUID;

public class IUnknownImpl
extends IResourceImpl
implements IUnknown {
    private int internalRefCount;

    @Override
    public IUnknown queryInterface(UUID iid) {
        IUnknown iunk = this._queryInterface(this.getPtr(), iid.getMostSignificantBits(), iid.getLeastSignificantBits());
        if (iunk instanceof IUnknownImpl) {
            IUnknownImpl iunkImpl = (IUnknownImpl)iunk;
            if (iid.equals(IUnknown.IID_IOleContainer)) {
                IOleContainerImpl ioc = new IOleContainerImpl(iunkImpl);
                iunk.release();
                return ioc;
            }
            if (iid.equals(IUnknown.IID_IWebBrowser2) || iid.equals(IUnknown.IID_IDispatch)) {
                IDispatchImpl idisp = new IDispatchImpl(iunkImpl);
                iunk.release();
                return idisp;
            }
        }
        return iunk;
    }

    @Override
    public void release() {
        --this.internalRefCount;
        if (this.internalRefCount == 0) {
            super.release();
        } else if (this.internalRefCount < 0) {
            throw new ComException("Too many releases have been invoked:" + this.internalRefCount);
        }
        this._release(this.getPtr());
    }

    @Override
    public int getTotalRefCount() {
        int r = this._addRef(this.getPtr());
        this._release(this.getPtr());
        return r - 1;
    }

    protected IUnknownImpl(ResourceManager rm, long ptr, IResourceImpl.Lifecycle lifecycle) {
        super(rm, lifecycle, ptr);
        this.internalRefCount = lifecycle == IResourceImpl.Lifecycle.UNTOUCHED ? 0 : 1;
    }

    protected IUnknownImpl(ResourceManager rm, IUnknown base) {
        this(rm, base.getPtr(), IResourceImpl.Lifecycle.DEFAULT);
        this._addRef(this.getPtr());
    }

    protected IUnknownImpl(IUnknownImpl base) {
        this(base.getResourceManager(), base);
    }

    private native int _release(long var1);

    private native int _addRef(long var1);

    private native IUnknown _queryInterface(long var1, long var3, long var5);

    private static native void _addReleaseWaitQueue(long var0);

    protected void finalize() {
        if (this.isToBeFinalized()) {
            while (this.internalRefCount > 0) {
                IUnknownImpl._addReleaseWaitQueue(this.getPtr());
                --this.internalRefCount;
            }
        }
    }

    public static IUnknown newIUnknown(ResourceManager rm, long ptr, boolean permanent) {
        if (ptr == 0L) {
            return null;
        }
        IResourceImpl.Lifecycle lc = permanent ? IResourceImpl.Lifecycle.PERMANENT : IResourceImpl.Lifecycle.DEFAULT;
        IUnknownImpl iunk = new IUnknownImpl(rm, ptr, lc);
        return iunk;
    }

    public static IUnknown newUntouchedIUnknown(ResourceManager rm, long ptr) {
        IUnknownImpl iunk = new IUnknownImpl(rm, ptr, IResourceImpl.Lifecycle.UNTOUCHED);
        return iunk;
    }

    protected void internalAddRef() {
        ++this.internalRefCount;
    }

    @Override
    public IUnknown newIUnknown(long ptr) {
        IUnknownImpl iunk = (IUnknownImpl)this.findInResource(ptr);
        if (iunk == null) {
            iunk = new IUnknownImpl(this.getResourceManager(), ptr, IResourceImpl.Lifecycle.DEFAULT);
        } else {
            iunk.internalAddRef();
        }
        return iunk;
    }

    @Override
    public void addRef() {
        this._addRef(this.getPtr());
        this.manage();
        ++this.internalRefCount;
    }

    @Override
    public boolean equalsCOMObject(Object o) {
        if (!(o instanceof IUnknown)) {
            return false;
        }
        IUnknown iunk = (IUnknown)o;
        if (this.getPtr() == iunk.getPtr()) {
            return true;
        }
        IUnknown thisIU = this.queryInterface(IID_IUnknown);
        IUnknown otherIU = iunk.queryInterface(IID_IUnknown);
        if (thisIU == null) {
            if (otherIU == null) {
                return true;
            }
            otherIU.release();
            return false;
        }
        if (otherIU == null) {
            return false;
        }
        long thisPtr = thisIU.getPtr();
        long otherPtr = otherIU.getPtr();
        thisIU.release();
        otherIU.release();
        return thisPtr == otherPtr;
    }
}

