/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.accessibility.com.win32.impl;

import com.ibm.accessibility.com.win32.IResource;
import com.ibm.accessibility.com.win32.ResourceManager;
import com.ibm.accessibility.com.win32.impl.IResourceKeyImpl;

public abstract class IResourceImpl
extends IResourceKeyImpl
implements IResource {
    private ResourceManager resourceManager;
    private Lifecycle lifecycle;
    protected final Exception exception;

    protected boolean isToBeFinalized() {
        return this.lifecycle == Lifecycle.DEFAULT;
    }

    public boolean isManaged() {
        return this.resourceManager != null && this.lifecycle != Lifecycle.UNTOUCHED;
    }

    protected void manage() {
        if (this.lifecycle == Lifecycle.UNTOUCHED) {
            this.lifecycle = Lifecycle.DEFAULT;
        }
    }

    @Override
    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    @Override
    public void addResource(IResource target) {
        if (this.isManaged()) {
            this.resourceManager.addResource(target);
        }
    }

    @Override
    public void release() {
        if (this.isManaged()) {
            this.resourceManager.removeResource(this);
        }
    }

    @Override
    public IResource findInResource(long ptr) {
        if (this.isManaged()) {
            return this.resourceManager.findInResource(ptr);
        }
        return null;
    }

    public String toString() {
        return super.toString() + " PTR:" + this.getPtr();
    }

    protected IResourceImpl(ResourceManager rm, Lifecycle lifecycle, long ptr) {
        super(ptr);
        this.resourceManager = rm;
        this.lifecycle = lifecycle;
        this.exception = null;
        if (this.isManaged()) {
            rm.addResource(this);
        }
    }

    public static enum Lifecycle {
        DEFAULT,
        PERMANENT,
        UNTOUCHED;

    }
}

