/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.accessibility.com.win32.impl;

import com.ibm.accessibility.com.win32.DispatchException;
import com.ibm.accessibility.com.win32.IDispatch;
import com.ibm.accessibility.com.win32.IResource;
import com.ibm.accessibility.com.win32.IUnknown;
import com.ibm.accessibility.com.win32.ResourceManager;
import com.ibm.accessibility.com.win32.impl.IResourceImpl;
import com.ibm.accessibility.com.win32.impl.IUnknownImpl;
import java.util.HashMap;

public class IDispatchImpl
extends IUnknownImpl
implements IDispatch {
    private static final int LCID_SYSTEM_DEFAULT = 2048;
    private static final int LCID_USER_DEFAULT = 1024;
    private static int LCID = 1024;
    private static final int DISPATCH_METHOD = 1;
    private static final int DISPATCH_PROPERTYGET = 2;
    private HashMap<String, Long> nameCache;

    private long getDispID(String name) {
        if (this.nameCache == null) {
            this.nameCache = new HashMap(4);
        } else {
            Long ll = this.nameCache.get(name);
            if (ll != null) {
                return ll;
            }
        }
        long[] idl = this._getIDsOfNames(this.getPtr(), new String[]{name}, LCID);
        if (idl == null) {
            return -1L;
        }
        long dispid = idl[0];
        this.nameCache.put(name.intern(), dispid);
        return dispid;
    }

    @Override
    public void cacheDispIDs(String[] names) {
        if (this.nameCache == null) {
            this.nameCache = new HashMap(names.length);
        }
        long[] idl = this._getIDsOfNames(this.getPtr(), names, LCID);
        for (int i = 0; i < idl.length; ++i) {
            this.nameCache.put(names[i].intern(), idl[i]);
        }
    }

    @Override
    public Object invoke(String method, Object[] args) {
        long id = this.getDispID(method);
        if (id == -1L) {
            throw new DispatchException(method + " is not available.");
        }
        Object obj = this._invoke(this.getPtr(), id, LCID, 1, args);
        return obj;
    }

    @Override
    public Object invoke0(String method) {
        long id = this.getDispID(method);
        if (id == -1L) {
            throw new DispatchException(method + " is not available.");
        }
        Object obj = this._invoke(this.getPtr(), id, LCID, 1, null);
        return obj;
    }

    @Override
    public Object invoke1(String method, Object arg1) {
        long id = this.getDispID(method);
        if (id == -1L) {
            throw new DispatchException(method + " is not available.");
        }
        Object obj = this._invoke(this.getPtr(), id, LCID, 1, new Object[]{arg1});
        return obj;
    }

    @Override
    public Object get(String prop) {
        long id = this.getDispID(prop);
        if (id == -1L) {
            return null;
        }
        Object obj = this._invoke(this.getPtr(), id, LCID, 2, null);
        return obj;
    }

    @Override
    public Object get(String prop, Object[] args) {
        long id = this.getDispID(prop);
        if (id == -1L) {
            return null;
        }
        Object obj = this._invoke(this.getPtr(), id, LCID, 2, args);
        return obj;
    }

    @Override
    public void put(String prop, Object val) {
        long id = this.getDispID(prop);
        if (id == -1L) {
            throw new DispatchException(prop + " is not available.");
        }
        this._put(this.getPtr(), id, LCID, val);
    }

    protected IDispatchImpl(ResourceManager rm, long ptr, IResourceImpl.Lifecycle lifecycle) {
        super(rm, ptr, lifecycle);
    }

    protected IDispatchImpl(ResourceManager rm, IUnknown base) {
        super(rm, base);
    }

    protected IDispatchImpl(IUnknownImpl base) {
        super(base);
    }

    private native long[] _getIDsOfNames(long var1, String[] var3, int var4);

    private native Object _invoke(long var1, long var3, int var5, int var6, Object[] var7);

    private native void _put(long var1, long var3, int var5, Object var6);

    public static IDispatch newIDispatch(ResourceManager rm, long ptr, boolean permanent) {
        IResourceImpl.Lifecycle lc = permanent ? IResourceImpl.Lifecycle.PERMANENT : IResourceImpl.Lifecycle.DEFAULT;
        IDispatchImpl idisp = new IDispatchImpl(rm, ptr, lc);
        return idisp;
    }

    public static IDispatch newUntouchedIDispatch(ResourceManager rm, long ptr) {
        IDispatchImpl idisp = new IDispatchImpl(rm, ptr, IResourceImpl.Lifecycle.UNTOUCHED);
        return idisp;
    }

    @Override
    public IDispatch newIDispatch(long ptr) {
        IResource r = this.findInResource(ptr);
        if (r != null) {
            IDispatchImpl x = (IDispatchImpl)r;
            x.internalAddRef();
            return x;
        }
        IDispatchImpl idisp = new IDispatchImpl(this.getResourceManager(), ptr, IResourceImpl.Lifecycle.DEFAULT);
        return idisp;
    }
}

