/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.accessibility.com.win32;

import com.ibm.accessibility.com.win32.ComException;
import com.ibm.accessibility.com.win32.IResource;
import com.ibm.accessibility.com.win32.impl.IResourceKeyImpl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.WeakHashMap;

public class ResourceManager {
    public static final boolean DEBUG = false;
    private final ResourceManager parent;
    private ArrayList<ResourceManager> childRMs;
    private WeakHashMap<IResource, IResource> resources = new WeakHashMap();

    public IResource findInResource(long ptr) {
        IResourceKeyImpl irki = new IResourceKeyImpl(ptr);
        IResource r = this.resources.get(irki);
        return r;
    }

    public void releaseAll(IResource except) {
        IResource[] rarray = new IResource[this.resources.size()];
        for (IResource r : rarray = this.resources.values().toArray(rarray)) {
            if (r == null || r.equals(except)) continue;
            try {
                r.release();
            }
            catch (ComException comException) {
                // empty catch block
            }
        }
        this.resources.clear();
        if (except != null) {
            this.addResource(except);
        }
        if (this.childRMs != null) {
            Iterator<ResourceManager> itm = this.childRMs.iterator();
            while (itm.hasNext()) {
                itm.next().releaseAll(except);
            }
        }
    }

    public void removeResource(IResource resource) {
        this.resources.remove(resource);
    }

    public void addResource(IResource target) {
        this.resources.put(target, target);
    }

    public static ResourceManager newResourceManager(ResourceManager parent) {
        ResourceManager rm = new ResourceManager(parent);
        if (parent != null) {
            if (parent.childRMs == null) {
                parent.childRMs = new ArrayList(1);
            }
            parent.childRMs.add(rm);
        }
        return rm;
    }

    private ResourceManager(ResourceManager parent) {
        this.parent = parent;
    }
}

