/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.re.properties;

import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.flexibility.properties.property.AbstractProperty;
import org.polarsys.capella.common.flexibility.properties.schema.ICompoundProperty;
import org.polarsys.capella.common.flexibility.properties.schema.IEditableProperty;
import org.polarsys.capella.common.flexibility.properties.schema.IModifiedProperty;
import org.polarsys.capella.common.flexibility.properties.schema.IProperty;
import org.polarsys.capella.common.flexibility.properties.schema.IPropertyContext;
import org.polarsys.capella.common.flexibility.properties.schema.IRestraintProperty;
import org.polarsys.capella.common.re.CatalogElement;
import org.polarsys.capella.common.re.CompliancyDefinition;
import org.polarsys.capella.common.re.handlers.replicable.ReplicableElementHandlerHelper;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class DefaultChildrenCompliancyProperty
extends AbstractProperty
implements IEditableProperty,
IRestraintProperty,
ICompoundProperty,
IModifiedProperty {
    public Object getValue(IPropertyContext context) {
        IProperty property = context.getProperties().getProperty("itarget");
        CatalogElement element = (CatalogElement)context.getCurrentValue(property);
        if (element != null && element.getDefaultReplicaCompliancy() != null) {
            return element.getDefaultReplicaCompliancy();
        }
        Collection<Object> objects = this.getChoiceValues(context);
        if (!objects.isEmpty()) {
            return objects.iterator().next();
        }
        return null;
    }

    public IStatus validate(Object newValue, IPropertyContext context) {
        if (newValue == null || !(newValue instanceof CompliancyDefinition)) {
            return new Status(2, this.getGroupId(), "A default compliancy should be set");
        }
        return Status.OK_STATUS;
    }

    public Object getType() {
        return CompliancyDefinition.class;
    }

    public Object toType(Object value, IPropertyContext context) {
        return value;
    }

    public boolean isModified(IPropertyContext context) {
        return true;
    }

    public String[] getRelatedProperties() {
        return new String[]{"locationTarget", "itarget"};
    }

    public void updatedValue(IProperty property, IPropertyContext context) {
    }

    public Collection<Object> getChoiceValues(IPropertyContext context) {
        IProperty locationProperty = context.getProperties().getProperty("locationTarget");
        EObject sourceProperty = (EObject)context.getCurrentValue(locationProperty);
        IContext ctx = (IContext)context.getSource();
        Collection<CompliancyDefinition> compliancies = ReplicableElementHandlerHelper.getInstance(ctx).getAllDefinedCompliancy(sourceProperty);
        if (compliancies.isEmpty()) {
            ReplicableElementHandlerHelper.getInstance(ctx).createDefaultCompliancies(sourceProperty);
            compliancies = ReplicableElementHandlerHelper.getInstance(ctx).getAllDefinedCompliancy(sourceProperty);
        }
        return compliancies;
    }

    public boolean isMany() {
        return false;
    }

    public void setValue(IPropertyContext context) {
        CompliancyDefinition definition;
        IProperty locationProperty = context.getProperties().getProperty("itarget");
        EObject sourceProperty = (EObject)context.getCurrentValue(locationProperty);
        if (sourceProperty != null && sourceProperty instanceof CatalogElement && (definition = (CompliancyDefinition)context.getCurrentValue((IProperty)this)) != null) {
            ((CatalogElement)sourceProperty).setDefaultReplicaCompliancy(definition);
        }
    }
}

