/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.trinity.spi;

import com.ibm.trinity.spi.DefaultModelAccessAdapter;
import com.ibm.trinity.spi.ModelAccessCommand;
import com.ibm.trinity.spi.ModelAccessException;
import com.ibm.trinity.spi.ModelAccessModifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;

public abstract class ModifiableModelAccessAdapter
extends DefaultModelAccessAdapter {
    private Map<EStructuralFeature, ModelAccessModifier> modelAccessModifierMap = new HashMap<EStructuralFeature, ModelAccessModifier>();
    private List<ModelAccessCommand> modelAccessLog;

    protected void registerModelAccessModifier(EStructuralFeature feature, ModelAccessModifier modifier) {
        modifier.setModifiableModelAccessAdapter(this);
        this.modelAccessModifierMap.put(feature, modifier);
    }

    private boolean isTransactionEnabled() {
        return this.modelAccessLog != null;
    }

    protected void setTransaction(boolean flag) {
        this.modelAccessLog = flag ? new ArrayList<ModelAccessCommand>() : null;
    }

    protected Set<EObject> getLockTargets() {
        HashSet<EObject> ret = new HashSet<EObject>(this.modelAccessLog.size());
        for (ModelAccessCommand mac : this.modelAccessLog) {
            mac.addLockTarget(ret);
        }
        return ret;
    }

    protected void clearTx() {
        this.modelAccessLog.clear();
    }

    protected void commit() throws ModelAccessException {
        for (ModelAccessCommand c : this.modelAccessLog) {
            c.execute();
        }
    }

    @Override
    public void doSet(EObject target, EStructuralFeature feature, Object value) {
        if (this.isTransactionEnabled()) {
            this.modelAccessLog.add(new ModelAccessCommand.Set(target, feature, value, false));
        } else {
            super.doSet(target, feature, value);
        }
    }

    @Override
    protected void doSetForcibly(EObject target, EStructuralFeature feature, Object value) {
        if (this.isTransactionEnabled()) {
            this.modelAccessLog.add(new ModelAccessCommand.Set(target, feature, value, true));
        } else {
            super.doSet(target, feature, value);
        }
    }

    @Override
    public void doUnset(EObject target, EStructuralFeature feature) {
        if (this.isTransactionEnabled()) {
            this.modelAccessLog.add(new ModelAccessCommand.Unset(target, feature));
        } else {
            super.doUnset(target, feature);
        }
    }

    @Override
    public void doAdd(EObject target, EStructuralFeature feature, Object value, int index) {
        if (this.isTransactionEnabled()) {
            this.modelAccessLog.add(new ModelAccessCommand.Add(target, feature, value, index));
        } else {
            super.doAdd(target, feature, value, index);
        }
    }

    @Override
    public void doAdd(EObject target, EStructuralFeature feature, Object value) {
        this.doAdd(target, feature, value, -1);
    }

    @Override
    public void doRemove(EObject target, EStructuralFeature feature, Object value) {
        if (this.isTransactionEnabled()) {
            this.modelAccessLog.add(new ModelAccessCommand.Remove(target, feature, value));
        } else {
            super.doRemove(target, feature, value);
        }
    }

    @Override
    public void doDelete(EObject target, Resource resource) {
        if (this.isTransactionEnabled()) {
            this.modelAccessLog.add(new ModelAccessCommand.Delete(target, resource));
        } else {
            super.doDelete(target, resource);
        }
    }

    @Override
    public Object get(EObject obj, EStructuralFeature feature) throws ModelAccessException {
        ModelAccessModifier m = this.modelAccessModifierMap.get(feature);
        if (m != null) {
            return m.get(obj, feature);
        }
        return super.get(obj, feature);
    }

    @Override
    public void set(EObject obj, EStructuralFeature feature, Object value) throws ModelAccessException {
        ModelAccessModifier m = this.modelAccessModifierMap.get(feature);
        if (m != null) {
            m.set(obj, feature, value);
        } else {
            super.set(obj, feature, value);
        }
    }

    @Override
    public void add(EObject owner, EStructuralFeature feature, Object value, int index) throws ModelAccessException {
        ModelAccessModifier m = this.modelAccessModifierMap.get(feature);
        if (m != null) {
            m.add(owner, feature, value, index);
        } else {
            super.add(owner, feature, value, index);
        }
    }

    private EObject translate(EObject value, Map<EStructuralFeature, Object> inits) throws ModelAccessException {
        ArrayList<EStructuralFeature> translated = new ArrayList<EStructuralFeature>(1);
        for (EStructuralFeature f : inits.keySet()) {
            Object initValue;
            EObject v;
            ModelAccessModifier m = this.modelAccessModifierMap.get(f);
            if (m == null || (v = m.init(value, f, initValue = inits.get(f))) == null) continue;
            value = v;
            translated.add(f);
        }
        for (EStructuralFeature f : translated) {
            inits.remove(f);
        }
        return value;
    }

    @Override
    public void set(EObject obj, EStructuralFeature feature, EObject value, Map<EStructuralFeature, Object> inits) throws ModelAccessException {
        value = this.translate(value, inits);
        super.set(obj, feature, value, inits);
    }

    @Override
    public void add(EObject owner, EStructuralFeature feature, EObject value, int index, Map<EStructuralFeature, Object> inits) throws ModelAccessException {
        value = this.translate(value, inits);
        super.add(owner, feature, value, index, inits);
    }

    @Override
    public void remove(EObject owner, EStructuralFeature feature, Object value) throws ModelAccessException {
        ModelAccessModifier m = this.modelAccessModifierMap.get(feature);
        if (m != null) {
            m.remove(owner, feature, value);
        } else {
            super.remove(owner, feature, value);
        }
    }
}

