/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.trinity.spi;

import com.ibm.trinity.spi.ModelAccessAdapter;
import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;

public abstract class ModelAccessCommand {
    protected final EObject target;
    protected final EStructuralFeature feature;

    public void addLockTarget(Collection<EObject> c) {
        c.add(this.target);
    }

    public abstract void execute();

    private ModelAccessCommand(EObject target, EStructuralFeature feature) {
        this.target = target;
        this.feature = feature;
    }

    public static class Delete
    extends ModelAccessCommand {
        private final Resource resource;

        public static void go(EObject t, Resource r) {
            r.getContents().remove((Object)t);
        }

        @Override
        public void execute() {
            Delete.go(this.target, this.resource);
        }

        public Delete(EObject target, Resource resource) {
            super(target, null);
            this.resource = resource;
        }
    }

    public static class Remove
    extends ModelAccessCommand {
        private final Object value;

        @Override
        public void addLockTarget(Collection<EObject> c) {
            if (this.value instanceof EObject) {
                c.add((EObject)this.value);
            }
            super.addLockTarget(c);
        }

        public static void go(EObject t, EStructuralFeature f, Object v) {
            EList valueList = (EList)t.eGet(f);
            valueList.remove(v);
        }

        @Override
        public void execute() {
            Remove.go(this.target, this.feature, this.value);
        }

        public Remove(EObject target, EStructuralFeature feature, Object value) {
            super(target, feature);
            assert (feature.isMany());
            this.value = value;
        }
    }

    public static class Add
    extends ModelAccessCommand {
        private final Object value;
        private final int index;

        public static void go(EObject t, EStructuralFeature f, Object v, int i) {
            EList valueList = (EList)t.eGet(f);
            if (i >= 0) {
                ModelAccessAdapter.setToList(valueList, i, v);
            } else {
                valueList.add(v);
            }
        }

        @Override
        public void execute() {
            Add.go(this.target, this.feature, this.value, this.index);
        }

        public Add(EObject target, EStructuralFeature feature, Object value, int index) {
            super(target, feature);
            assert (feature.isMany());
            this.value = value;
            this.index = index;
        }

        public Add(EObject target, EStructuralFeature feature, Object value) {
            this(target, feature, value, -1);
        }
    }

    public static class Unset
    extends ModelAccessCommand {
        public static void go(EObject t, EStructuralFeature f) {
            t.eUnset(f);
        }

        @Override
        public void execute() {
            Unset.go(this.target, this.feature);
        }

        public Unset(EObject target, EStructuralFeature feature) {
            super(target, feature);
        }
    }

    public static class Set
    extends ModelAccessCommand {
        private final Object value;
        private final boolean force;

        public static void go(EObject t, EStructuralFeature f, Object v) {
            t.eSet(f, v);
        }

        public static void forcibly(EObject t, EStructuralFeature f, Object v) {
            if (f.isChangeable()) {
                t.eSet(f, v);
            } else {
                try {
                    f.setChangeable(true);
                    t.eSet(f, v);
                }
                finally {
                    f.setChangeable(false);
                }
            }
        }

        @Override
        public void execute() {
            if (this.force) {
                Set.forcibly(this.target, this.feature, this.value);
            } else {
                Set.go(this.target, this.feature, this.value);
            }
        }

        public Set(EObject target, EStructuralFeature feature, Object value, boolean force) {
            super(target, feature);
            this.value = value;
            this.force = force;
        }
    }
}

