/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.trinity.spi;

import com.ibm.trinity.spi.InvalidModelAccessException;
import com.ibm.trinity.spi.ModelAccessCommand;
import com.ibm.trinity.spi.ModelAccessException;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;

public abstract class ModelAccessAdapter {
    public static final Logger LOGGER = Logger.getLogger(ModelAccessAdapter.class);

    public void setEPackage(EPackage ePackage) {
    }

    public abstract Resource load(URI var1) throws ModelAccessException, IllegalStateException;

    public abstract ReloadResult reload() throws ModelAccessException, IllegalStateException;

    public void setTransactionalEditingDomain(TransactionalEditingDomain txDomain) {
    }

    public abstract Resource getResource();

    public abstract void save() throws ModelAccessException, IllegalStateException;

    public abstract void saveAs(URI var1, boolean var2) throws ModelAccessException, IllegalStateException;

    public abstract void unload();

    public abstract Map<String, EObject[]> getPrimaryDataSources();

    public EObject instantiate(EClass eClass) throws ModelAccessException {
        EPackage ePkg = eClass.getEPackage();
        try {
            return ePkg.getEFactoryInstance().create(eClass);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidModelAccessException("Failed to instantiate: " + e);
        }
    }

    public abstract void dispose(EObject var1) throws ModelAccessException;

    public abstract Object get(EObject var1, EStructuralFeature var2) throws ModelAccessException;

    public abstract void set(EObject var1, EStructuralFeature var2, Object var3) throws ModelAccessException;

    public void set(EObject obj, EStructuralFeature feature, EObject value, Map<EStructuralFeature, Object> inits) throws ModelAccessException {
        this.initFeatures(value, inits);
        this.set(obj, feature, value);
    }

    public abstract void add(EObject var1, EStructuralFeature var2, Object var3, int var4) throws ModelAccessException;

    public void add(EObject owner, EStructuralFeature feature, EObject value, int index, Map<EStructuralFeature, Object> inits) throws ModelAccessException {
        this.initFeatures(value, inits);
        this.add(owner, feature, value, index);
    }

    public abstract void remove(EObject var1, EStructuralFeature var2, Object var3) throws ModelAccessException;

    protected boolean isContainementReference(EStructuralFeature feature) {
        return feature instanceof EReference && ((EReference)feature).isContainment();
    }

    public static boolean isGlobal(EModelElement e) {
        EAnnotation ea = e.getEAnnotation("http://maplembse.maplesoft.com/common/global");
        return ea != null;
    }

    protected void initFeatures(EObject eobj, Map<EStructuralFeature, Object> inits) {
        for (Map.Entry<EStructuralFeature, Object> e : inits.entrySet()) {
            EStructuralFeature feature = e.getKey();
            if (ModelAccessAdapter.isGlobal((EModelElement)feature)) continue;
            Object val = e.getValue();
            this.doSetForcibly(eobj, feature, val);
        }
    }

    public static <T> void setToList(List<T> list, int index, T element) {
        int size = list.size();
        if (size > index) {
            list.set(index, element);
        } else {
            while (size < index) {
                list.add(null);
                ++size;
            }
            list.add(element);
        }
    }

    public void doSet(EObject target, EStructuralFeature feature, Object value) {
        ModelAccessCommand.Set.go(target, feature, value);
    }

    protected void doSetForcibly(EObject target, EStructuralFeature feature, Object value) {
        ModelAccessCommand.Set.forcibly(target, feature, value);
    }

    public void doUnset(EObject target, EStructuralFeature feature) {
        ModelAccessCommand.Unset.go(target, feature);
    }

    public void doAdd(EObject target, EStructuralFeature feature, Object value, int index) {
        ModelAccessCommand.Add.go(target, feature, value, index);
    }

    public void doAdd(EObject target, EStructuralFeature feature, Object value) {
        this.doAdd(target, feature, value, -1);
    }

    public void doRemove(EObject target, EStructuralFeature feature, Object value) {
        ModelAccessCommand.Remove.go(target, feature, value);
    }

    public void doDelete(EObject target, Resource resource) {
        ModelAccessCommand.Delete.go(target, resource);
    }

    public static enum ReloadResult {
        UNSUPPORTED,
        DONE,
        NEED_REACTIVATE;

    }
}

