/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.trinity.spi;

import com.ibm.trinity.spi.ModelAccessAdapter;
import com.ibm.trinity.spi.ModelAccessException;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;

public class LoggingModelAccessAdapterWrapper
extends ModelAccessAdapter {
    private ModelAccessAdapter delegate;

    public LoggingModelAccessAdapterWrapper(ModelAccessAdapter delegate) {
        assert (delegate != null);
        this.delegate = delegate;
    }

    private String asString(EStructuralFeature feature) {
        return feature.getName();
    }

    @Override
    public void setEPackage(EPackage ePackage) {
        this.delegate.setEPackage(ePackage);
    }

    @Override
    public EObject instantiate(EClass eClass) throws ModelAccessException {
        EObject eo = this.delegate.instantiate(eClass);
        LOGGER.debug((Object)("Instantiate (" + eClass + "): " + eo));
        return eo;
    }

    @Override
    public Resource load(URI uri) throws ModelAccessException, IllegalStateException {
        Resource result = this.delegate.load(uri);
        LOGGER.debug((Object)("Loaded a resource: " + uri));
        return result;
    }

    @Override
    public ModelAccessAdapter.ReloadResult reload() throws ModelAccessException, IllegalStateException {
        ModelAccessAdapter.ReloadResult r = this.delegate.reload();
        LOGGER.debug((Object)("Reloaded the resource.:" + r));
        return r;
    }

    @Override
    public Resource getResource() {
        return this.delegate.getResource();
    }

    @Override
    public void save() throws ModelAccessException, IllegalStateException {
        this.delegate.save();
        String uri = this.delegate.getResource().getURI().toString();
        LOGGER.debug((Object)("Resource saved: " + uri));
    }

    @Override
    public void saveAs(URI path, boolean saveCopyAs) throws ModelAccessException, IllegalStateException {
        this.delegate.saveAs(path, saveCopyAs);
        String uri = this.delegate.getResource().getURI().toString();
        LOGGER.debug((Object)("Resource saved as: " + uri + "(saveCopyAs=" + saveCopyAs + ")"));
    }

    @Override
    public void unload() {
        String uri = this.delegate.getResource().getURI().toString();
        this.delegate.unload();
        LOGGER.debug((Object)("Resource unloaded: " + uri));
    }

    @Override
    public Map<String, EObject[]> getPrimaryDataSources() {
        return this.delegate.getPrimaryDataSources();
    }

    @Override
    public void dispose(EObject obj) throws ModelAccessException {
        StringBuilder sb = new StringBuilder();
        sb.append("DISPOSE: object=").append(obj);
        LOGGER.debug((Object)sb.toString());
        this.delegate.dispose(obj);
    }

    @Override
    public Object get(EObject obj, EStructuralFeature feature) throws ModelAccessException {
        return this.delegate.get(obj, feature);
    }

    @Override
    public void set(EObject obj, EStructuralFeature feature, Object value) throws ModelAccessException {
        StringBuilder sb = new StringBuilder();
        sb.append("SET: owner=").append(obj);
        sb.append(", feature=").append(this.asString(feature));
        sb.append(", value=").append(value);
        LOGGER.debug((Object)sb.toString());
        this.delegate.set(obj, feature, value);
    }

    @Override
    public void set(EObject obj, EStructuralFeature feature, EObject value, Map<EStructuralFeature, Object> inits) throws ModelAccessException {
        StringBuilder sb = new StringBuilder();
        sb.append("SET: owner=").append(obj);
        sb.append(", feature=").append(this.asString(feature));
        sb.append(", value=").append(value);
        sb.append(", inits=").append(inits);
        LOGGER.debug((Object)sb.toString());
        this.delegate.set(obj, feature, value, inits);
    }

    @Override
    public void add(EObject owner, EStructuralFeature feature, Object value, int index) throws ModelAccessException {
        StringBuilder sb = new StringBuilder();
        sb.append("ADD: owner=").append(owner);
        sb.append(", feature=").append(this.asString(feature));
        sb.append(", value=").append(value);
        sb.append(", index=").append(index);
        LOGGER.debug((Object)sb.toString());
        this.delegate.add(owner, feature, value, index);
    }

    @Override
    public void add(EObject owner, EStructuralFeature feature, EObject value, int index, Map<EStructuralFeature, Object> inits) throws ModelAccessException {
        StringBuilder sb = new StringBuilder();
        sb.append("ADD: owner=").append(owner);
        sb.append(", feature=").append(this.asString(feature));
        sb.append(", value=").append(value);
        sb.append(", index=").append(index);
        sb.append(", inits=").append(inits);
        LOGGER.debug((Object)sb.toString());
        this.delegate.add(owner, feature, value, index, inits);
    }

    @Override
    public void remove(EObject owner, EStructuralFeature feature, Object value) throws ModelAccessException {
        StringBuilder sb = new StringBuilder();
        sb.append("REMOVE: owner=").append(owner);
        sb.append(", feature=").append(this.asString(feature));
        sb.append(", value=").append(value);
        LOGGER.debug((Object)sb.toString());
        this.delegate.remove(owner, feature, value);
    }
}

