/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.trinity.spi;

import com.ibm.trinity.spi.DataSourceModelAccessException;
import com.ibm.trinity.spi.ModelAccessAdapter;
import com.ibm.trinity.spi.ModelAccessException;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMapUtil;

public class DefaultModelAccessAdapter
extends ModelAccessAdapter {
    private ResourceSet rset;
    private Resource resource;

    @Override
    public Resource load(URI uri) throws ModelAccessException {
        this.rset = new ResourceSetImpl();
        this.resource = this.rset.getResource(uri, true);
        if (this.resource == null) {
            throw new DataSourceModelAccessException("Model not found: " + uri);
        }
        return this.resource;
    }

    @Override
    public ModelAccessAdapter.ReloadResult reload() throws ModelAccessException, IllegalStateException {
        if (!this.resource.isLoaded()) {
            return ModelAccessAdapter.ReloadResult.DONE;
        }
        this.resource.unload();
        try {
            this.resource.load(Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            throw new DataSourceModelAccessException("Failed to reload", e);
        }
        return ModelAccessAdapter.ReloadResult.NEED_REACTIVATE;
    }

    @Override
    public Resource getResource() {
        return this.resource;
    }

    @Override
    public Map<String, EObject[]> getPrimaryDataSources() {
        if (this.resource == null) {
            throw new IllegalStateException();
        }
        HashMap<String, EObject[]> result = new HashMap<String, EObject[]>();
        EObject root = (EObject)this.resource.getContents().get(0);
        EObject[] entry = new EObject[]{root};
        result.put("Root", entry);
        return result;
    }

    @Override
    public void unload() {
        if (this.resource == null) {
            throw new IllegalStateException();
        }
        this.resource.unload();
        this.resource = null;
    }

    @Override
    public void save() throws ModelAccessException {
        try {
            this.resource.save(null);
        }
        catch (IOException e) {
            throw new DataSourceModelAccessException("Failed to save model file: " + this.resource.getURI().toString(), e);
        }
    }

    @Override
    public void saveAs(URI uri, boolean saveCopyAs) throws ModelAccessException {
        if (this.resource == null) {
            throw new IllegalStateException();
        }
        URI origURI = this.resource.getURI();
        if (!origURI.equals(uri)) {
            this.resource.setURI(uri);
        }
        try {
            this.resource.save(null);
        }
        catch (Exception e) {
            StringBuilder sb = new StringBuilder("SaveAs failed: ");
            sb.append("saveAs=").append(saveCopyAs);
            sb.append(", uri=").append(this.resource.getURI());
            sb.append(", origUri=").append(origURI);
            String msg = sb.toString();
            throw new DataSourceModelAccessException(msg, e);
        }
        finally {
            if (saveCopyAs && !origURI.equals(uri)) {
                this.resource.setURI(origURI);
            }
        }
    }

    @Override
    public void dispose(EObject obj) throws ModelAccessException {
        this.deleteRecursively(obj);
    }

    protected void deleteEObject(EObject eobj) throws ModelAccessException {
        Collection usages = EcoreUtil.UsageCrossReferencer.find((EObject)eobj, (ResourceSet)this.rset);
        for (EStructuralFeature.Setting setting : usages) {
            EObject eoS = setting.getEObject();
            EStructuralFeature f = setting.getEStructuralFeature();
            if (!f.isChangeable()) continue;
            if (FeatureMapUtil.isMany((EObject)eoS, (EStructuralFeature)f)) {
                this.doRemove(eoS, f, eobj);
                continue;
            }
            this.doUnset(eoS, f);
        }
        if (eobj instanceof InternalEObject) {
            Resource.Internal dr;
            EReference feature;
            InternalEObject ieo = (InternalEObject)eobj;
            InternalEObject container = ieo.eInternalContainer();
            if (container != null && (feature = eobj.eContainmentFeature()).isChangeable()) {
                if (FeatureMapUtil.isMany((EObject)container, (EStructuralFeature)feature)) {
                    this.doRemove((EObject)container, (EStructuralFeature)feature, eobj);
                } else {
                    this.doUnset((EObject)container, (EStructuralFeature)feature);
                }
            }
            if ((dr = ieo.eDirectResource()) != null) {
                this.doDelete(eobj, (Resource)dr);
            }
        }
    }

    private void deleteRecursively(EObject obj) throws ModelAccessException {
        EClass cls = obj.eClass();
        this.deleteContents(obj, cls);
        this.deleteEObject(obj);
    }

    private void deleteContents(EObject obj, EClass cls) throws ModelAccessException {
        for (EReference ref : cls.getEAllContainments()) {
            Object o = obj.eGet((EStructuralFeature)ref);
            if (o == null) continue;
            if (ref.isMany()) {
                EObject[] childrenArray;
                EList children = (EList)o;
                if (children == null || children.isEmpty()) continue;
                for (EObject child : childrenArray = (EObject[])children.toArray((Object[])new EObject[0])) {
                    this.deleteRecursively(child);
                }
                continue;
            }
            this.deleteRecursively((EObject)o);
        }
    }

    @Override
    public Object get(EObject obj, EStructuralFeature feature) throws ModelAccessException {
        return obj.eGet(feature);
    }

    @Override
    public void set(EObject obj, EStructuralFeature feature, Object value) throws ModelAccessException {
        if (DefaultModelAccessAdapter.isGlobal((EModelElement)feature)) {
            return;
        }
        if (this.isContainementReference(feature) && value == null) {
            Object oldValue = this.get(obj, feature);
            this.dispose((EObject)oldValue);
        } else {
            this.doSet(obj, feature, value);
        }
    }

    @Override
    public void add(EObject owner, EStructuralFeature feature, Object value, int index) throws ModelAccessException {
        assert (feature != null);
        assert (feature.isMany());
        if (DefaultModelAccessAdapter.isGlobal((EModelElement)feature)) {
            return;
        }
        this.doAdd(owner, feature, value, index);
    }

    @Override
    public void remove(EObject owner, EStructuralFeature feature, Object value) throws ModelAccessException {
        assert (feature != null);
        assert (feature.isMany());
        if (this.isContainementReference(feature)) {
            this.dispose((EObject)value);
        } else {
            this.doRemove(owner, feature, value);
        }
    }
}

