/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.trinity.spi;

import com.ibm.trinity.spi.LicenseModelAccessException;
import java.io.RandomAccessFile;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class CheckLicense {
    private static final String envname = "MAPLEMBSE_NP_NAME";
    private static final String NPKEY = "8f52ce1f262e51f2633caf5235af1615fdce67d3bb65a48ba02d97826796532af49faaf6329b549268beec5e2b720c407bc90eb47ea62136150f4b2b0f31c1db";
    private static final String ENCODING = "UTF-8";
    private static final int DEFAULT_BUF_SIZE = 2048;

    private static String getNamedPipePath() {
        try {
            return System.getenv(envname);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String getHash(String key) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("SHA-512");
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        md.update(key.getBytes());
        StringBuilder ret = new StringBuilder();
        for (byte b : md.digest()) {
            String hex = String.format("%02x", b);
            ret.append(hex);
        }
        return ret.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void check(String feature) throws LicenseModelAccessException {
        try {
            int size;
            byte[] buf;
            String path = CheckLicense.getNamedPipePath();
            if (path == null) {
                String hash;
                String key = System.getProperty("com.maplesoft.maplembse.NPKEY");
                if (key != null && NPKEY.equals(hash = CheckLicense.getHash(key))) {
                    return;
                }
                throw new LicenseModelAccessException("Internal Error (failed to access NPENV)", feature);
            }
            try (RandomAccessFile f = new RandomAccessFile(path, "rw");){
                byte[] fw = feature.getBytes(ENCODING);
                f.write(fw);
                buf = new byte[2048];
                size = f.read(buf);
            }
            if (size > 0) {
                byte st = buf[0];
                switch (st) {
                    case 79: {
                        return;
                    }
                    case 85: {
                        throw new LicenseModelAccessException("Internal Error (uninit)", feature);
                    }
                    case 81: {
                        throw new LicenseModelAccessException.Queued(feature);
                    }
                }
                String errorMsg = new String(buf, 1, size - 1, ENCODING);
                throw new LicenseModelAccessException(errorMsg, feature);
            }
            throw new LicenseModelAccessException("Internal Error (no response)", feature);
        }
        catch (LicenseModelAccessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new LicenseModelAccessException(feature, e);
        }
    }
}

