/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.trinity.spi;

import com.ibm.trinity.spi.DefaultModelAccessAdapter;
import com.ibm.trinity.spi.LogUtil;
import com.ibm.trinity.spi.ModelAccessAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator
implements BundleActivator {
    private static final Logger LOGGER = LogUtil.getLogger();
    public static final String PLUGIN_ID = "com.ibm.trinity.spi";
    private static Activator plugin;
    private List<ModelAccessAdapterRef> adapterRefs;
    private Map<String, ModelAccessAdapterRef> selectedRefs;

    private ModelAccessAdapterRef getModelAccessAdapterRef(String nsURI) {
        return this.selectedRefs.get(nsURI);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public void start(BundleContext context) throws Exception {
        IConfigurationElement[] configs;
        plugin = this;
        this.adapterRefs = new ArrayList<ModelAccessAdapterRef>();
        this.selectedRefs = new HashMap<String, ModelAccessAdapterRef>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        for (IConfigurationElement elem : configs = registry.getConfigurationElementsFor("com.ibm.trinity.spi.ecore")) {
            ModelAccessAdapterRef ref = ModelAccessAdapterRef.newRef(elem);
            if (ref == null) continue;
            this.adapterRefs.add(ref);
        }
    }

    public void stop(BundleContext context) throws Exception {
        this.adapterRefs = null;
        this.selectedRefs = null;
        plugin = null;
    }

    private ModelAccessAdapter selectModelAccessAdapter(String nsURI, ModelAccessAdapterRef maar) {
        this.selectedRefs.put(nsURI, maar);
        return maar.getInstance(this);
    }

    public ModelAccessAdapter lookupModelAccessAdapter(String ecoreURI, URI modelURI) {
        ModelAccessAdapterRef ecoreMatch = null;
        ModelAccessAdapterRef extMatch = null;
        for (ModelAccessAdapterRef maar : this.adapterRefs) {
            if (maar.matchEcoreURI(ecoreURI)) {
                if (maar.matchModelURI(modelURI)) {
                    return this.selectModelAccessAdapter(ecoreURI, maar);
                }
                ecoreMatch = maar;
                continue;
            }
            if (!maar.matchModelURI(modelURI)) continue;
            extMatch = maar;
        }
        if (ecoreMatch != null) {
            return this.selectModelAccessAdapter(ecoreURI, ecoreMatch);
        }
        if (extMatch != null) {
            return this.selectModelAccessAdapter(ecoreURI, extMatch);
        }
        return null;
    }

    private ModelAccessAdapter lookupModelAccessAdapter(String ecoreURI) {
        ModelAccessAdapterRef m = this.selectedRefs.get(ecoreURI);
        if (m != null) {
            return m.getInstance(this);
        }
        for (ModelAccessAdapterRef maar : this.adapterRefs) {
            if (!maar.matchEcoreURI(ecoreURI)) continue;
            return this.selectModelAccessAdapter(ecoreURI, maar);
        }
        return null;
    }

    public ModelAccessAdapter getModelAccessAdapter(EPackage pkg) {
        String nsURI = pkg.getNsURI();
        ModelAccessAdapter adapter = this.lookupModelAccessAdapter(nsURI);
        if (adapter != null) {
            return adapter;
        }
        DefaultModelAccessAdapter result = new DefaultModelAccessAdapter();
        result.setEPackage(pkg);
        return result;
    }

    private static abstract class ModelAccessAdapterRef {
        public final String uri;
        protected final IConfigurationElement configuration;

        public abstract ModelAccessAdapter getInstance(Activator var1) throws IllegalStateException;

        public abstract boolean matchModelURI(URI var1);

        public boolean matchEcoreURI(String ecoreURI) {
            return this.uri.equals(ecoreURI);
        }

        public static ModelAccessAdapterRef newRef(IConfigurationElement configuration) {
            String name = configuration.getName();
            if ("adapter".equals(name)) {
                return new ModelAccessAdapterDef(configuration);
            }
            if ("proxy".equals(name)) {
                return new ModelAccessAdapterProxy(configuration);
            }
            LOGGER.error((Object)("Invalid ModelAccessAdapter name: " + name + " uri=" + configuration.getAttribute("uri")));
            return null;
        }

        protected ModelAccessAdapterRef(IConfigurationElement configuration) {
            this.configuration = configuration;
            this.uri = configuration.getAttribute("uri");
        }
    }

    private static class ModelAccessAdapterDef
    extends ModelAccessAdapterRef {
        public final String scheme;
        public final String[] extArray;
        private ModelAccessAdapter adapter;
        private static final String[] EMPTY_EXT = new String[0];

        @Override
        public boolean matchModelURI(URI modelURI) {
            if (this.scheme != null && this.scheme.equals(modelURI.scheme())) {
                return true;
            }
            String uriExt = modelURI.fileExtension();
            if (uriExt == null) {
                return false;
            }
            for (String ext : this.extArray) {
                if (!ext.equals(uriExt)) continue;
                return true;
            }
            return false;
        }

        @Override
        public ModelAccessAdapter getInstance(Activator activator) throws IllegalStateException {
            if (this.adapter == null) {
                try {
                    this.adapter = (ModelAccessAdapter)this.configuration.createExecutableExtension("class");
                    EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(this.uri);
                    this.adapter.setEPackage(ePackage);
                }
                catch (CoreException e) {
                    throw new IllegalStateException(e);
                }
            }
            return this.adapter;
        }

        protected ModelAccessAdapterDef(IConfigurationElement configuration) {
            super(configuration);
            this.scheme = configuration.getAttribute("scheme");
            String extensions = configuration.getAttribute("extensions");
            this.extArray = extensions != null ? extensions.split(",", 0) : EMPTY_EXT;
            LOGGER.info((Object)("Register a ModelAccessAdapter: uri=" + this.uri + " scheme=" + this.scheme + " extensions=" + extensions + ", " + configuration.getAttribute("class")));
        }
    }

    private static class ModelAccessAdapterProxy
    extends ModelAccessAdapterRef {
        private final String targetURI;
        private ModelAccessAdapterRef target;

        @Override
        public boolean matchModelURI(URI modelURI) {
            return false;
        }

        @Override
        public ModelAccessAdapter getInstance(Activator activator) throws IllegalStateException {
            if (this.target == null) {
                this.target = activator.getModelAccessAdapterRef(this.targetURI);
                if (this.target == null) {
                    LOGGER.error((Object)("Failed to find a ModelAccessAdapter for " + this.targetURI));
                    return null;
                }
            }
            return this.target.getInstance(activator);
        }

        protected ModelAccessAdapterProxy(IConfigurationElement configuration) {
            super(configuration);
            this.targetURI = configuration.getAttribute("targetURI");
            if (this.uri.equals(this.targetURI)) {
                throw new IllegalArgumentException("Invalid ModelAccessAdapter Proxy:" + this.targetURI);
            }
            LOGGER.info((Object)("Register a ModelAccessAdapter Proxy: uri=" + this.uri + " target=" + this.targetURI));
        }
    }
}

